/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.query.parser;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import org.ascape.query.parser.BoolExprTree;
import org.ascape.query.parser.ParseException;
import org.ascape.query.parser.SimpleNode;

public class QTField
extends SimpleNode {
    private String name;
    private PropertyDescriptor descriptor;

    public QTField(int id) {
        super(id);
    }

    public QTField(BoolExprTree p, int id) {
        super(p, id);
    }

    public void validate(Object object) throws ParseException {
        try {
            try {
                this.descriptor = new PropertyDescriptor(this.getName(), object.getClass());
            }
            catch (IntrospectionException introspectionException) {
                String base = QTField.capitalize(this.getName());
                try {
                    this.descriptor = new PropertyDescriptor(this.getName(), object.getClass(), "is" + base, null);
                }
                catch (IntrospectionException introspectionException2) {
                    this.descriptor = new PropertyDescriptor(this.getName(), object.getClass(), "get" + base, null);
                }
            }
            this.getValue(object);
        }
        catch (IntrospectionException e) {
            throw new ParseException("Couldn't recognize field: " + this.getName() + " for class: " + object.getClass() + e);
        }
    }

    static String capitalize(String s) {
        if (s.length() == 0) {
            return s;
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public PropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Object getComparedValue(Object object) throws ParseException {
        Class<?> type = this.getDescriptor().getPropertyType();
        Object value = this.getValue(object);
        if (!(value instanceof Number) && type != String.class && !(value instanceof Boolean)) {
            value = value != null ? value.toString() : "null";
        }
        return value;
    }

    public Object getValue(Object object) throws ParseException {
        Object o = null;
        try {
            o = this.descriptor.getReadMethod().invoke(object, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ParseException("Couldn't access field: " + this.getName() + " for class: " + object.getClass());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException("Couldn't make argument for field: " + this.getName() + " for class: " + object.getClass());
        }
        catch (InvocationTargetException e) {
            e.getCause().printStackTrace();
            throw new ParseException("Couldn't target field: " + this.getName() + " for class: " + object.getClass() + " because: " + e.getCause());
        }
        return o;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }
}

