/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm.commands;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.metaabm.IID;
import org.metaabm.MetaABMPackage;
import org.metaabm.SAgent;
import org.metaabm.SContext;
import org.metaabm.SImplemented;
import org.metaabm.SProjection;
import org.metaabm.act.ABuildProjection;
import org.metaabm.act.ACreateAgents;
import org.metaabm.act.ALoadAgents;
import org.metaabm.act.ALoadShapedAgents;
import org.metaabm.commands.AddAgentsActsCommand;
import org.metaabm.commands.AddSpacesActsCommand;
import org.metaabm.commands.StringTranslator;
import org.metaabm.commands.SuggestLabelCommand;
import org.metaabm.provider.MetaABMEditPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TargetTranslator
implements StringTranslator {
    EStructuralFeature sourceFeature;
    EStructuralFeature targetFeature;
    public static final TargetTranslator LABEL_TO_CLASSNAME_TRANSLATOR = new TargetTranslator((EStructuralFeature)MetaABMPackage.Literals.SIMPLEMENTATION__CLASS_NAME){

        public String translateName(String otherName, IID source) {
            String className = this.removeSpecialChars(otherName);
            return className;
        }

        public EObject targetFor(EObject source) {
            return ((SImplemented)source).getImplementation();
        }
    };
    public static final TargetTranslator LABEL_TO_AGENT_COUNT_DESC_TRANSLATOR = new TargetTranslator((EStructuralFeature)MetaABMPackage.Literals.SNAMED__PLURAL_LABEL, (EStructuralFeature)MetaABMPackage.Literals.SNAMED__DESCRIPTION){

        public String translateName(String otherName, IID source) {
            return "The number of " + (otherName != null ? otherName.toLowerCase() : "?") + " to create.";
        }

        public EObject targetFor(EObject source) {
            ACreateAgents creator = AddAgentsActsCommand.findCreatorFor((SAgent)source);
            return creator != null ? creator.getAgentCount() : null;
        }
    };
    public static final TargetTranslator LABEL_TO_AGENT_COUNT_LABEL_TRANSLATOR = new TargetTranslator(){

        public String translateName(String otherName, IID source) {
            return String.valueOf(otherName) + " Count";
        }

        public EObject targetFor(EObject source) {
            ACreateAgents creator = AddAgentsActsCommand.findCreatorFor((SAgent)source);
            return creator != null ? creator.getAgentCount() : null;
        }
    };
    public static final TargetTranslator LABEL_TO_AGENT_CREATOR_LABEL_TRANSLATOR = new TargetTranslator((EStructuralFeature)MetaABMPackage.Literals.SNAMED__PLURAL_LABEL, (EStructuralFeature)MetaABMPackage.Literals.IID__LABEL){

        public String translateName(String otherName, IID source) {
            String label = !StringUtils.isEmpty((String)otherName) ? otherName : "Unspecified";
            label = source instanceof ALoadAgents || source instanceof ALoadShapedAgents ? "Load " + label : "Create " + label;
            return label;
        }

        public EObject targetFor(EObject source) {
            ACreateAgents creator = AddAgentsActsCommand.findCreatorFor((SAgent)source);
            return creator;
        }
    };
    public static final TargetTranslator LABEL_TO_SPACE_BUILDER_LABEL_TRANSLATOR = new TargetTranslator((EStructuralFeature)MetaABMPackage.Literals.SNAMED__PLURAL_LABEL, (EStructuralFeature)MetaABMPackage.Literals.IID__LABEL){

        public String translateName(String otherName, IID source) {
            String label;
            String string = label = !StringUtils.isEmpty((String)otherName) ? otherName : "Undefined";
            if (source instanceof ABuildProjection) {
                label = "Build " + label;
            }
            return label;
        }

        public EObject targetFor(EObject source) {
            ABuildProjection creator = AddSpacesActsCommand.findBuilderOf((SContext)((SProjection)source).eContainer(), (SProjection)source);
            return creator;
        }
    };
    public static final TargetTranslator LABEL_TO_PLURAL_NAME_TRANSLATOR = new TargetTranslator((EStructuralFeature)MetaABMPackage.Literals.SNAMED__PLURAL_LABEL){

        public String translateName(String otherName, IID source) {
            return !StringUtils.isEmpty((String)otherName) ? otherName.concat("s") : "";
        }
    };
    public static final TargetTranslator LABEL_TO_ID_TRANSLATOR = new TargetTranslator((EStructuralFeature)MetaABMPackage.Literals.IID__ID){

        public String translateName(String otherName, IID source) {
            String legalID = this.removeSpecialChars(otherName);
            legalID = StringUtils.uncapitalize((String)legalID);
            return legalID;
        }
    };
    public static final List<TargetTranslator> ID_TRANSLATORS = Arrays.asList(LABEL_TO_ID_TRANSLATOR);
    public static final List<TargetTranslator> PLURAL_TRANSLATORS = Arrays.asList(LABEL_TO_AGENT_CREATOR_LABEL_TRANSLATOR, LABEL_TO_AGENT_COUNT_DESC_TRANSLATOR);
    public static final List<TargetTranslator> AGENT_TRANSLATORS = Arrays.asList(LABEL_TO_ID_TRANSLATOR, LABEL_TO_PLURAL_NAME_TRANSLATOR, LABEL_TO_CLASSNAME_TRANSLATOR, LABEL_TO_AGENT_COUNT_DESC_TRANSLATOR, LABEL_TO_AGENT_CREATOR_LABEL_TRANSLATOR, LABEL_TO_AGENT_COUNT_LABEL_TRANSLATOR);
    public static final List<TargetTranslator> SAPCE_TRANSLATORS = Arrays.asList(LABEL_TO_ID_TRANSLATOR, LABEL_TO_PLURAL_NAME_TRANSLATOR, LABEL_TO_SPACE_BUILDER_LABEL_TRANSLATOR);
    public static final List<TargetTranslator> NAMED_IMPLEMENTED_TRANSLATORS = Arrays.asList(LABEL_TO_ID_TRANSLATOR, LABEL_TO_PLURAL_NAME_TRANSLATOR, LABEL_TO_CLASSNAME_TRANSLATOR);
    public static final List<TargetTranslator> NAMED_TRANSLATORS = Arrays.asList(LABEL_TO_ID_TRANSLATOR, LABEL_TO_PLURAL_NAME_TRANSLATOR);
    public static final List<TargetTranslator> IMPLEMENTED_TRANSLATORS = Arrays.asList(LABEL_TO_ID_TRANSLATOR, LABEL_TO_CLASSNAME_TRANSLATOR);

    public TargetTranslator() {
        this((EStructuralFeature)MetaABMPackage.Literals.IID__LABEL);
    }

    public TargetTranslator(EStructuralFeature targetFeature) {
        this((EStructuralFeature)MetaABMPackage.Literals.IID__LABEL, targetFeature);
    }

    public TargetTranslator(EStructuralFeature sourceFeature, EStructuralFeature targetFeature) {
        this.sourceFeature = sourceFeature;
        this.targetFeature = targetFeature;
    }

    public EObject targetFor(EObject source) {
        return source;
    }

    public boolean includeFor(EditingDomain domain, EObject source) {
        String sourceName = (String)source.eGet(this.sourceFeature);
        String oldTranslatedName = this.translateName(sourceName, (IID)source);
        EObject target = this.targetFor(source);
        if (target != null) {
            String oldName = (String)target.eGet(this.targetFeature);
            oldName = StringUtils.remove((String)oldName, (String)" Copy");
            oldName = StringUtils.remove((String)oldName, (String)"Copy");
            oldTranslatedName = StringUtils.remove((String)oldTranslatedName, (String)" Copy");
            oldTranslatedName = StringUtils.remove((String)oldTranslatedName, (String)"Copy");
            String defaultString = MetaABMEditPlugin.INSTANCE.getString("_UI_" + source.eClass().getName() + "_type");
            if (!StringUtils.isEmpty((String)StringUtils.deleteWhitespace((String)oldName)) && !oldName.equals(oldTranslatedName)) {
                if (target instanceof IID) {
                    SuggestLabelCommand testCmd = new SuggestLabelCommand(domain, (IID)target);
                    if (this.targetFeature == MetaABMPackage.Literals.IID__LABEL && (testCmd.suggestLabel((IID)target).equals(oldName) || defaultString.equals(oldName)) || this.targetFeature == MetaABMPackage.Literals.IID__ID && testCmd.suggestID((IID)target).equals(oldName)) {
                        return true;
                    }
                }
                return false;
            }
        }
        return true;
    }

    public Command createCommand(EditingDomain domain, IID source) {
        String sourceName;
        if (source != null && !StringUtils.isEmpty((String)(sourceName = (String)source.eGet(this.sourceFeature)))) {
            EObject targetFor = this.targetFor((EObject)source);
            String targetValue = this.translateName(sourceName, targetFor instanceof IID ? (IID)targetFor : source);
            return SetCommand.create((EditingDomain)domain, (Object)targetFor, (Object)this.targetFeature, (Object)targetValue);
        }
        return null;
    }

    public static Command create(EditingDomain domain, List<TargetTranslator> translators, IID source) {
        CompoundCommand cmd = new CompoundCommand();
        for (TargetTranslator targetTranslator : translators) {
            cmd.append(targetTranslator.createCommand(domain, source));
        }
        return cmd;
    }

    protected String removeSpecialChars(String otherName) {
        String legalID = StringUtils.deleteWhitespace((String)StringUtils.capitalize((String)otherName));
        legalID = StringUtils.replace((String)legalID, (String)"()", (String)"");
        legalID = StringUtils.replace((String)legalID, (String)"(", (String)"_");
        legalID = StringUtils.replace((String)legalID, (String)")", (String)"_");
        legalID = StringUtils.replace((String)legalID, (String)"[?]", (String)"");
        legalID = StringUtils.replace((String)legalID, (String)"[", (String)"_");
        legalID = StringUtils.replace((String)legalID, (String)"]", (String)"_");
        legalID = StringUtils.replace((String)legalID, (String)"?", (String)"");
        legalID = StringUtils.replace((String)legalID, (String)"&&", (String)"AND");
        legalID = StringUtils.replace((String)legalID, (String)"&", (String)"And");
        legalID = StringUtils.replace((String)legalID, (String)"!", (String)"Not");
        legalID = StringUtils.replace((String)legalID, (String)"||", (String)"OR");
        legalID = StringUtils.replace((String)legalID, (String)"|", (String)"Or");
        legalID = StringUtils.replace((String)legalID, (String)",", (String)"");
        legalID = StringUtils.replace((String)legalID, (String)".", (String)"pt");
        legalID = StringUtils.replace((String)legalID, (String)":", (String)"");
        return legalID;
    }
}

