/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf.zest;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.amp.agf.IGraphicsAdapter;
import org.eclipse.amp.agf.gef.GenericEditPart;
import org.eclipse.amp.axf.core.ICompositionProvider;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.zest.core.viewers.EntityConnectionData;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.core.viewers.IConnectionStyleProvider;
import org.eclipse.zest.core.viewers.IEntityStyleProvider;
import org.eclipse.zest.core.viewers.IFigureProvider;

public class ZestStyleProvider
implements IEntityStyleProvider,
ILabelProvider,
IColorProvider,
IConnectionStyleProvider,
IFigureProvider {
    public static final Color HIGHLIGHT_COLOR = Display.getCurrent().getSystemColor(7);
    IGraphicsAdapter graphicsAdapter;
    private Map<Object, IColorProvider> colorProviderFor = new HashMap<Object, IColorProvider>();
    private HashMap<Object, ILabelProvider> labelProviderFor = new HashMap();
    private HashMap<Object, org.eclipse.amp.agf.gef.IFigureProvider> figureProviderFor = new HashMap();
    private HashMap<Object, IFigure> figureFor = new HashMap();
    private ICompositionProvider compositionProvider;
    private GraphViewer viewer;

    public ZestStyleProvider(GraphViewer viewer, Object object, ICompositionProvider compositionProvider, IGraphicsAdapter graphicsAdapter) {
        this.viewer = viewer;
        this.compositionProvider = compositionProvider;
        this.graphicsAdapter = graphicsAdapter;
    }

    public boolean fisheyeNode(Object entity) {
        return false;
    }

    public Color getBackgroundColour(Object entity) {
        return this.getBackground(entity);
    }

    public Color getBorderColor(Object entity) {
        return null;
    }

    public Color getBorderHighlightColor(Object entity) {
        return HIGHLIGHT_COLOR;
    }

    public int getBorderWidth(Object entity) {
        return 2;
    }

    public Color getForegroundColour(Object entity) {
        return this.getForeground(entity);
    }

    public Color getNodeHighlightColor(Object entity) {
        return HIGHLIGHT_COLOR;
    }

    public IFigure getTooltip(Object entity) {
        return null;
    }

    public void dispose() {
    }

    public Image getImage(Object element) {
        if (!(element instanceof EntityConnectionData) && this.getFigureProvider(element) != null) {
            return this.getLabelProvider(element).getImage(element);
        }
        return null;
    }

    public String getText(Object element) {
        if (!(element instanceof EntityConnectionData)) {
            return this.getLabelProvider(element).getText(element);
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.getLabelProvider(element).isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Color getBackground(Object element) {
        return this.getColorProvider(element).getBackground(element);
    }

    public Color getForeground(Object element) {
        return this.getColorProvider(element).getForeground(element);
    }

    public Color getColor(Object rel) {
        return null;
    }

    public int getConnectionStyle(Object rel) {
        return 4;
    }

    public Color getHighlightColor(Object rel) {
        return HIGHLIGHT_COLOR;
    }

    public int getLineWidth(Object rel) {
        return 3;
    }

    public IFigure getFigure(Object element) {
        IFigure figure = this.figureFor.get(element);
        if (figure == null) {
            figure = this.getFigureProvider(element).getFigure(element);
            this.figureFor.put(element, figure);
        }
        if (this.isSelected(element)) {
            this.highlightFigure(figure);
        } else {
            figure.setBorder(null);
        }
        return figure;
    }

    private boolean isSelected(Object element) {
        if (this.viewer.getSelection() instanceof StructuredSelection) {
            StructuredSelection ss = (StructuredSelection)this.viewer.getSelection();
            Object[] objectArray = ss.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object sel = objectArray[n2];
                if (sel == element) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void highlightFigure(IFigure figure) {
        if (figure instanceof Ellipse) {
            figure.setBorder(GenericEditPart.HIGHLIGHT_ELLIPSE);
        } else if (figure instanceof RoundedRectangle) {
            figure.setBorder(GenericEditPart.HIGHLIGHT_RECTANGLE);
        } else {
            figure.setBorder(GenericEditPart.HIGHLIGHT_RECTANGLE);
        }
    }

    protected org.eclipse.amp.agf.gef.IFigureProvider getFigureProvider(Object object) {
        org.eclipse.amp.agf.gef.IFigureProvider figureProvider = this.figureProviderFor.get(object);
        if (figureProvider == null) {
            figureProvider = (org.eclipse.amp.agf.gef.IFigureProvider)this.graphicsAdapter.getAdapter(object, org.eclipse.amp.agf.gef.IFigureProvider.class);
            this.figureProviderFor.put(object, figureProvider);
            Assert.isNotNull((Object)figureProvider);
        }
        return figureProvider;
    }

    protected IColorProvider getColorProvider(Object object) {
        IColorProvider colorProvider = this.colorProviderFor.get(object);
        if (colorProvider == null) {
            colorProvider = (IColorProvider)this.graphicsAdapter.getAdapter(object, IColorProvider.class);
            this.colorProviderFor.put(object, colorProvider);
            Assert.isNotNull((Object)colorProvider);
        }
        return colorProvider;
    }

    protected ILabelProvider getLabelProvider(Object object) {
        ILabelProvider labelProvider = this.labelProviderFor.get(object);
        if (labelProvider == null) {
            labelProvider = (ILabelProvider)this.graphicsAdapter.getAdapter(object, ILabelProvider.class);
            this.labelProviderFor.put(object, labelProvider);
        }
        return labelProvider;
    }
}

