/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.parameters;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.amp.amf.abase.ICached;
import org.eclipse.amp.amf.abase.IInterpreterProvider;
import org.eclipse.amp.amf.abase.aBase.BOOLEAN;
import org.eclipse.amp.amf.abase.aBase.BooleanValue;
import org.eclipse.amp.amf.abase.aBase.IntValue;
import org.eclipse.amp.amf.abase.aBase.RealValue;
import org.eclipse.amp.amf.abase.aBase.StringValue;
import org.eclipse.amp.amf.parameters.AParFactory;
import org.eclipse.amp.amf.parameters.aPar.Import;
import org.eclipse.amp.amf.parameters.aPar.Incorporates;
import org.eclipse.amp.amf.parameters.aPar.Model;
import org.eclipse.amp.amf.parameters.aPar.Parameter;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.metaabm.SAttribute;
import org.metaabm.SAttributeType;
import org.metaabm.SContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AParInterpreter
implements ICached {
    Resource emfResource;
    private String modelClass;
    private String runName;
    private String[] args;
    private SContext rootContext;
    private Model aparModel;
    private List<Parameter> parameters;
    private String localPath;
    private IInterpreterProvider cache;

    public void load(Resource emfResource) {
        this.emfResource = emfResource;
        ((ResourceImpl)emfResource).setIntrinsicIDToEObjectMap(new HashMap());
        this.aparModel = (Model)emfResource.getContents().get(0);
        assert (this.aparModel != null);
        String convertURI = AParInterpreter.convertURI(this.aparModel.getModel());
        URI modelURI = URI.createURI((String)convertURI);
        Resource amfResource = emfResource.getResourceSet().getResource(modelURI, true);
        ((ResourceImpl)amfResource).setIntrinsicIDToEObjectMap(new HashMap());
        this.rootContext = (SContext)amfResource.getContents().get(0);
        this.modelClass = this.rootContext.getImplementation().getQualifiedName();
        this.runName = String.valueOf(this.rootContext.getLabel()) + "_" + emfResource.getURI().trimFileExtension().lastSegment();
        this.parameters = this.collect(new HashSet<String>());
        String rootPath = amfResource.getURI().toPlatformString(true);
        this.localPath = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(rootPath)).getProject().getLocation().toOSString();
        this.args = new String[this.parameters.size()];
        int i = 0;
        for (Parameter parameter : this.parameters) {
            String value = AParInterpreter.value((EObject)parameter.getValue());
            if (parameter.getValue() instanceof StringValue) {
                value = StringUtils.replace((String)value, (String)"|", (String)(String.valueOf(this.localPath) + "/"));
            }
            this.args[i] = parameter.getAttribute().getLabel() != null ? String.valueOf(parameter.getAttribute().getLabel().replaceAll(" ", "")) + "=" + value : "";
            ++i;
        }
    }

    List<Parameter> collect(Set<String> overridden) {
        ArrayList<Parameter> includeIncorporated = new ArrayList<Parameter>();
        for (Parameter parameter : this.aparModel.getParameters()) {
            String label = parameter.getAttribute().getLabel();
            if (parameter.getAttribute().getOwner() != this.rootContext) {
                label = String.valueOf(parameter.getAttribute().getOwner().getLabel()) + " " + label;
            }
            if (overridden.contains(label)) continue;
            includeIncorporated.add(parameter);
            overridden.add(label);
        }
        Incorporates[] reverseIncorporates = new Incorporates[this.aparModel.getIncorporates().size()];
        int i = 0;
        while (i < reverseIncorporates.length) {
            reverseIncorporates[reverseIncorporates.length - (i + 1)] = (Incorporates)this.aparModel.getIncorporates().get(i);
            ++i;
        }
        Incorporates[] incorporatesArray = reverseIncorporates;
        int n = reverseIncorporates.length;
        int n2 = 0;
        while (n2 < n) {
            Incorporates incorporates = incorporatesArray[n2];
            String convertURI = AParInterpreter.convertURI(incorporates);
            URI incURI = URI.createURI((String)convertURI);
            if (this.cache == null) {
                this.cache = AParFactory.createPooled(this.emfResource.getResourceSet());
            }
            AParInterpreter incInterpreter = (AParInterpreter)this.cache.getInterpreter(incURI);
            includeIncorporated.addAll(incInterpreter.collect(overridden));
            ++n2;
        }
        return includeIncorporated;
    }

    public SContext getRootContext() {
        return this.rootContext;
    }

    public String getRunName() {
        return this.runName;
    }

    public String getModelClass() {
        return this.modelClass;
    }

    public String[] getArgs() {
        return this.args;
    }

    public String getArgsString() {
        String argString = "";
        for (Parameter param : this.parameters) {
            argString = String.valueOf(argString) + param.getAttribute().getID() + "\t" + AParInterpreter.value((EObject)param.getValue()) + "\r";
        }
        return argString.substring(0, argString.length() - 1);
    }

    public static String value(EObject value) {
        if (value instanceof StringValue) {
            return ((StringValue)value).getValue();
        }
        if (value instanceof IntValue) {
            return ((IntValue)value).getValue();
        }
        if (value instanceof RealValue) {
            return ((RealValue)value).getValue();
        }
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).getValue().getLiteral();
        }
        throw new RuntimeException("Unexpected object type: " + value.getClass());
    }

    private void assign(PropertyDescriptor desc, Object assignee, Object assignment) throws IllegalAccessException, InvocationTargetException {
        Object[] assignArg = new Object[]{assignment};
        desc.getWriteMethod().invoke(assignee, assignArg);
    }

    public void assignValues(Object assignee, MultiStatus status) {
        this.assignValues(new Object[]{assignee}, status);
    }

    public void assignValues(Object[] assignees, MultiStatus status) {
        HashMap<PropertyDescriptor, Object> assigneeForProperty = new HashMap<PropertyDescriptor, Object>();
        HashMap<String, PropertyDescriptor> propertyForID = new HashMap<String, PropertyDescriptor>();
        Object[] objectArray = assignees;
        int n = assignees.length;
        int n2 = 0;
        while (n2 < n) {
            Object assignee = objectArray[n2];
            try {
                PropertyDescriptor[] infoProperties;
                PropertyDescriptor[] propertyDescriptorArray = infoProperties = Introspector.getBeanInfo(assignee.getClass()).getPropertyDescriptors();
                int n3 = infoProperties.length;
                int n4 = 0;
                while (n4 < n3) {
                    PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n4];
                    propertyForID.put(StringUtils.capitalize((String)propertyDescriptor.getName()), propertyDescriptor);
                    assigneeForProperty.put(propertyDescriptor, assignee);
                    ++n4;
                }
            }
            catch (IntrospectionException e) {
                this.warn(status, "Could not introspect on \"" + assignee + ". Continuing.", e);
            }
            ++n2;
        }
        for (Parameter param : this.getParameters()) {
            SAttribute attribute = param.getAttribute();
            try {
                try {
                    String attrName = StringUtils.capitalize((String)attribute.getID());
                    PropertyDescriptor desc = (PropertyDescriptor)propertyForID.get(attrName);
                    if (desc == null && attribute.getOwner() != this.getRootContext()) {
                        attrName = String.valueOf(StringUtils.capitalize((String)attribute.getOwner().getID())) + attrName;
                        desc = (PropertyDescriptor)propertyForID.get(attrName);
                    }
                    if (desc == null) {
                        this.warn(status, "Could not find attribute \"" + attrName + "\" in " + assignees, null);
                        continue;
                    }
                    Object assignee = assigneeForProperty.get(desc);
                    if (attribute.getSType() == SAttributeType.REAL_LITERAL) {
                        this.assign(desc, assignee, Double.valueOf(AParInterpreter.value((EObject)param.getValue())));
                        continue;
                    }
                    if (attribute.getSType() == SAttributeType.INTEGER_LITERAL) {
                        this.assign(desc, assignee, Integer.valueOf(AParInterpreter.value((EObject)param.getValue())));
                        continue;
                    }
                    if (attribute.getSType() == SAttributeType.BOOLEAN_LITERAL) {
                        this.assign(desc, assignee, ((BooleanValue)param.getValue()).getValue() == BOOLEAN.TRUE);
                        continue;
                    }
                    if (attribute.getSType() == SAttributeType.SYMBOL_LITERAL) {
                        String string = AParInterpreter.value((EObject)param.getValue());
                        string = StringUtils.replace((String)string, (String)"|", (String)(String.valueOf(this.getLocalPath()) + "/"));
                        this.assign(desc, assignee, string);
                        continue;
                    }
                    status.add((IStatus)new Status(2, "org.eclipse.amp.amf.testing.ide", "Unrecognized type: " + attribute.getSType()));
                }
                catch (Exception e) {
                    status.add((IStatus)new Status(2, "org.eclipse.amp.amf.testing.ide", "Problem assigning parameter: " + attribute, (Throwable)e));
                }
            }
            catch (Exception e) {
                status.add((IStatus)new Status(2, "org.eclipse.amp.amf.testing.ide", "Couldn't obtain property descriptors for \"" + this.getModelClass() + "\"", (Throwable)e));
            }
        }
    }

    private void warn(MultiStatus status, String msg, Exception e) {
        if (status != null) {
            status.add((IStatus)new Status(2, "org.eclipse.amp.amf.testing.ide", msg, (Throwable)e));
        } else {
            System.err.println(msg);
        }
    }

    public Model getModel() {
        return this.aparModel;
    }

    public Resource getResource() {
        return this.emfResource;
    }

    public void setCache(IInterpreterProvider cache) {
        this.cache = cache;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public static String convertURI(Incorporates incorporateModel) {
        return AParInterpreter.convertURI(incorporateModel, incorporateModel.getImportURI());
    }

    public static String convertURI(Import importModel) {
        return AParInterpreter.convertURI(importModel, importModel.getImportURI());
    }

    public static String convertURI(EObject projectObject, String uri) {
        URI fileURI = projectObject.eResource().getURI();
        if (uri.startsWith("|")) {
            String platformString = "platform:/" + fileURI.segment(0) + "/" + fileURI.segment(1);
            return String.valueOf(platformString) + "/" + uri.substring(1);
        }
        if (!uri.startsWith("/") && !uri.startsWith("platform")) {
            fileURI = fileURI.trimSegments(1).resolve(fileURI);
            String platformString = fileURI + "/" + uri;
            return platformString;
        }
        return uri;
    }
}

