/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometry;

import org.eclipse.draw3d.geometry.AbstractHost3D;
import org.eclipse.draw3d.geometry.AbstractPosition3D;
import org.eclipse.draw3d.geometry.BoundingBoxImpl;
import org.eclipse.draw3d.geometry.IBoundingBox;
import org.eclipse.draw3d.geometry.IHost3D;
import org.eclipse.draw3d.geometry.IPosition3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Position3D;
import org.eclipse.draw3d.geometry.Vector3fImpl;

public class Position3DImpl
extends AbstractPosition3D {
    private IHost3D host;
    private BoundingBoxImpl bounds3D;

    public Position3DImpl(IHost3D i_host) {
        if (i_host == null) {
            throw new NullPointerException("i_host must not be null, use empty constructor instead");
        }
        this.host = i_host;
        this.bounds3D = new BoundingBoxImpl();
    }

    public Position3DImpl() {
        this.bounds3D = new BoundingBoxImpl();
        this.host = new AbstractHost3D(null){

            public Position3D getPosition3D() {
                return Position3DImpl.this;
            }

            public String toString() {
                return "no host, absolute position";
            }
        };
    }

    public IHost3D getHost() {
        return this.host;
    }

    public IBoundingBox getBounds3D() {
        return this.bounds3D;
    }

    public IVector3f getLocation3D() {
        return this.bounds3D.m_position;
    }

    public void setLocation3D(IVector3f i_point) {
        if (i_point == null) {
            throw new NullPointerException("i_point must not be null");
        }
        if (this.getLocation3D().equals(i_point)) {
            return;
        }
        Vector3fImpl delta = new Vector3fImpl();
        Math3D.sub(i_point, this.getLocation3D(), delta);
        this.bounds3D.setLocation(i_point.getX(), i_point.getY(), i_point.getZ());
        this.invalidate();
        this.firePositionChanged(IPosition3D.PositionHint.LOCATION, delta);
    }

    public IVector3f getSize3D() {
        return this.bounds3D.m_size;
    }

    public void setSize3D(IVector3f i_size) {
        if (i_size == null) {
            throw new NullPointerException("i_size must not be null");
        }
        IVector3f size3D = this.getSize3D();
        if (size3D.equals(i_size)) {
            return;
        }
        Vector3fImpl delta = new Vector3fImpl();
        Math3D.sub(i_size, size3D, delta);
        this.bounds3D.setSize(i_size);
        this.invalidate();
        this.firePositionChanged(IPosition3D.PositionHint.SIZE, delta);
    }
}

