/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d.lwjgl.graphics;

import org.eclipse.draw3d.graphics.optimizer.PrimitiveSet;
import org.eclipse.draw3d.graphics.optimizer.classification.PrimitiveClass;
import org.eclipse.draw3d.graphics.optimizer.primitive.OutlineRenderRule;
import org.eclipse.draw3d.graphics3d.Graphics3D;
import org.eclipse.draw3d.graphics3d.ILodHelper;
import org.eclipse.draw3d.graphics3d.lwjgl.graphics.LwjglVertexPrimitiveVBO;
import org.eclipse.draw3d.util.ColorConverter;
import org.eclipse.swt.graphics.Color;
import org.lwjgl.opengl.GL11;

public class LwjglLineVBO
extends LwjglVertexPrimitiveVBO {
    private float[] m_color = new float[4];

    public LwjglLineVBO(PrimitiveSet i_primitives) {
        super(i_primitives);
        PrimitiveClass primitiveClass = i_primitives.getPrimitiveClass();
        if (!primitiveClass.isLine() || !primitiveClass.isOutline()) {
            throw new IllegalArgumentException(i_primitives + " does not contain lines");
        }
        OutlineRenderRule renderRule = primitiveClass.getRenderRule().asOutline();
        ColorConverter.toFloatArray((Color)renderRule.getColor(), (int)renderRule.getAlpha(), (float[])this.m_color);
    }

    protected void doRender(Graphics3D i_g3d, ILodHelper i_lodContext) {
        i_g3d.glColor4f(this.m_color);
        GL11.glDrawArrays((int)1, (int)0, (int)this.getVertexCount());
    }
}

