/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.view.vis;

import org.ascape.model.Agent;
import org.ascape.util.vis.ColorFeature;
import org.ascape.util.vis.SimplexFeature;
import org.ascape.view.vis.GraphicsView;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;

public class SimplexView
extends GraphicsView {
    private static final long serialVersionUID = -1696040917980876267L;
    private SimplexFeature simplexFeature;
    private boolean displayCentroid;
    private ConcreteSimplexFeature centroid;
    private ConcreteSimplexFeature z1;
    private ConcreteSimplexFeature z2;
    private ConcreteSimplexFeature z3;
    private static int gap = 30;
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private int x3;
    private int y3;
    private int xSpan;
    private int ySpan;
    private Polygon innerTriangle;
    private Polygon playLowPoly;
    private Polygon playMediumPoly;
    private Polygon playHighPoly;
    private boolean firstTime = true;

    public SimplexView(String name) {
        super(name);
        this.setSimplexFeature(new ConcreteSimplexFeature(0.0f, 0.0f, 0.0f));
    }

    public SimplexView() {
        this("Simplex View");
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 300);
    }

    public synchronized void setCentroidTradeoff(float t) {
        this.displayCentroid = true;
        float cl = t / (1.0f - t);
        float cm = (t - 2.0f * (float)Math.pow(t, 2.0)) / (1.0f - t);
        float ch = 1.0f - 2.0f * t;
        this.centroid = new ConcreteSimplexFeature(ch, cm, cl);
        float z1l = 1.0f / (2.0f * (1.0f - t));
        float z1m = (1.0f - 2.0f * t) / (2.0f - 2.0f * t);
        float z1h = 0.0f;
        this.z1 = new ConcreteSimplexFeature(z1h, z1m, z1l);
        float z2l = t / (1.0f - t);
        float z2m = 0.0f;
        float z2h = (1.0f - 2.0f * t) / (1.0f - t);
        this.z2 = new ConcreteSimplexFeature(z2h, z2m, z2l);
        float z3l = 0.0f;
        float z3m = 2.0f * t;
        float z3h = 1.0f - 2.0f * t;
        this.z3 = new ConcreteSimplexFeature(z3h, z3m, z3l);
    }

    public int getXPosition(SimplexFeature f, Agent a) {
        return (int)((double)((float)this.xSpan * f.getAxis3Value(a)) + (double)this.xSpan / 2.0 * (double)f.getAxis1Value(a)) + this.x2;
    }

    public int getYPosition(SimplexFeature f, Agent a) {
        return (int)((double)this.ySpan * (1.0 - (double)f.getAxis1Value(a))) + this.y1;
    }

    public synchronized void updateScapeGraphics(Graphics graphics) {
        super.updateScapeGraphics(graphics);
        if (this.firstTime) {
            graphics.setForegroundColor(ColorFeature.BLACK);
            this.x1 = this.getPreferredSize().width / 2;
            this.y1 = gap;
            this.x2 = gap;
            this.y2 = this.getPreferredSize().height - gap;
            this.x3 = this.getPreferredSize().width - gap;
            this.y3 = this.getPreferredSize().height - gap;
            this.innerTriangle = new Polygon();
            this.innerTriangle.addPoint(new Point(this.x1, this.y1 + 2));
            this.innerTriangle.addPoint(new Point(this.x2 + 2, this.y2 - 1));
            this.innerTriangle.addPoint(new Point(this.x3 - 2, this.y3 - 1));
            graphics.drawOval(this.x1 - 1, this.y1 - 1, 2, 2);
            graphics.drawString(this.simplexFeature.getAxis1Name(), this.x1, this.y1 - 15);
            graphics.drawOval(this.x2 - 1, this.y2 - 1, 2, 2);
            graphics.drawString(this.simplexFeature.getAxis2Name(), this.x2, this.y2 + 15);
            graphics.drawOval(this.x3 - 2, this.y3 - 2, 2, 2);
            graphics.drawString(this.simplexFeature.getAxis3Name(), this.x3, this.y3 + 15);
            this.xSpan = this.x3 - this.x2;
            this.ySpan = this.y2 - this.y1;
            if (this.displayCentroid) {
                this.playLowPoly = new Polygon();
                this.playLowPoly.addPoint(new Point(this.getXPosition(this.z3, null) - 1, this.getYPosition(this.z3, null)));
                this.playLowPoly.addPoint(new Point(this.getXPosition(this.centroid, null), this.getYPosition(this.centroid, null)));
                this.playLowPoly.addPoint(new Point(this.getXPosition(this.z2, null) + 2, this.getYPosition(this.z2, null)));
                this.playLowPoly.addPoint(new Point(this.x1, this.y1 - 2));
                this.playMediumPoly = new Polygon();
                this.playMediumPoly.addPoint(new Point(this.getXPosition(this.z3, null) - 1, this.getYPosition(this.z3, null)));
                this.playMediumPoly.addPoint(new Point(this.getXPosition(this.centroid, null), this.getYPosition(this.centroid, null)));
                this.playMediumPoly.addPoint(new Point(this.getXPosition(this.z1, null), this.getYPosition(this.z1, null) + 2));
                this.playMediumPoly.addPoint(new Point(this.x2 - 3, this.y2 + 2));
                this.playHighPoly = new Polygon();
                this.playHighPoly.addPoint(new Point(this.getXPosition(this.z2, null) + 2, this.getYPosition(this.z2, null)));
                this.playHighPoly.addPoint(new Point(this.getXPosition(this.centroid, null), this.getYPosition(this.centroid, null)));
                this.playHighPoly.addPoint(new Point(this.getXPosition(this.z1, null), this.getYPosition(this.z1, null) + 2));
                this.playHighPoly.addPoint(new Point(this.x3 + 3, this.y3 + 2));
            }
            this.firstTime = false;
        }
        if (this.displayCentroid) {
            graphics.setBackgroundColor(ColorFeature.BLUE);
            graphics.fillPolygon(this.playLowPoly.getPoints().toIntArray());
            graphics.setBackgroundColor(ColorFeature.GREEN);
            graphics.fillPolygon(this.playMediumPoly.getPoints().toIntArray());
            graphics.setForegroundColor(ColorFeature.RED);
            graphics.fillPolygon(this.playHighPoly.getPoints().toIntArray());
        } else {
            graphics.setBackgroundColor(ColorFeature.WHITE);
            graphics.fillPolygon(this.innerTriangle.getPoints().toIntArray());
        }
        for (Agent agent : this.getScape()) {
            graphics.setBackgroundColor(ColorFeature.BLACK);
            graphics.fillRectangle(this.getXPosition(this.simplexFeature, agent), this.getYPosition(this.simplexFeature, agent), 2, 2);
        }
    }

    public SimplexFeature getSimplexFeature() {
        return this.simplexFeature;
    }

    public void setSimplexFeature(SimplexFeature simplexFeature) {
        this.simplexFeature = simplexFeature;
        this.firstTime = true;
    }

    public class ConcreteSimplexFeature
    extends SimplexFeature {
        float axis1Value;
        float axis2Value;
        float axis3Value;

        public ConcreteSimplexFeature(float axis1Value, float axis2Value, float axis3Value) {
            this.axis1Value = axis1Value;
            this.axis2Value = axis2Value;
            this.axis3Value = axis3Value;
        }

        public float getAxis1Value(Object object) {
            return this.axis1Value;
        }

        public String getAxis1Name() {
            return "";
        }

        public float getAxis2Value(Object object) {
            return this.axis2Value;
        }

        public String getAxis2Name() {
            return "";
        }

        public float getAxis3Value(Object object) {
            return this.axis3Value;
        }

        public String getAxis3Name() {
            return "";
        }
    }
}

