/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RectanglePacker<T> {
    private Comparator<Rectangle> m_comparator = new Comparator<Rectangle>(){

        @Override
        public int compare(Rectangle i_r1, Rectangle i_r2) {
            if (i_r1.height < i_r2.height) {
                return -1;
            }
            if (i_r1.height > i_r2.height) {
                return 1;
            }
            return 0;
        }
    };
    private int m_length = 16;
    private boolean m_packed = false;
    private Map<T, Rectangle> m_rectangles = new HashMap<T, Rectangle>();
    private List<Strip> m_strips = new LinkedList<Strip>();
    private int m_totalHeight = 0;

    public void add(int i_w, int i_h, T i_data) {
        if (this.m_packed) {
            throw new IllegalStateException(this + " is already packed");
        }
        this.m_rectangles.put(i_data, new Rectangle(0, 0, i_w, i_h));
    }

    public int getLength() {
        return this.m_length;
    }

    public Point getPosition(T i_data, Point io_result) {
        Point result = io_result;
        if (result == null) {
            result = new Point();
        }
        Rectangle rectangle = this.m_rectangles.get(i_data);
        result.x = rectangle.x;
        result.y = rectangle.y;
        return result;
    }

    public void pack() {
        if (this.m_packed) {
            throw new IllegalStateException(this + " is already packed");
        }
        ArrayList<Rectangle> sorted = new ArrayList<Rectangle>(this.m_rectangles.values());
        Collections.sort(sorted, this.m_comparator);
        for (Rectangle rectangle : sorted) {
            this.pack(rectangle);
        }
        this.m_packed = true;
    }

    private void pack(Rectangle i_rectangle) {
        for (Strip strip : this.m_strips) {
            if (!strip.add(i_rectangle)) continue;
            return;
        }
        while (i_rectangle.height > this.m_length - this.m_totalHeight || i_rectangle.width > this.m_length) {
            this.m_length *= 2;
        }
        this.m_strips.add(new Strip(this.m_totalHeight, i_rectangle));
        this.m_totalHeight += i_rectangle.height;
    }

    private class Strip {
        private int m_height = 0;
        private int m_x = 0;
        private int m_y;

        public Strip(int i_y, Rectangle i_firstRectangle) {
            this.m_y = i_y;
            this.m_height = i_firstRectangle.height;
            this.add(i_firstRectangle);
        }

        public boolean add(Rectangle i_rectangle) {
            if (i_rectangle.width > RectanglePacker.this.getLength() - this.m_x || i_rectangle.height > this.m_height) {
                return false;
            }
            i_rectangle.x = this.m_x;
            i_rectangle.y = this.m_y;
            this.m_x += i_rectangle.width;
            return true;
        }
    }
}

