/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.axf.ide.handlers;

import org.eclipse.amp.axf.core.EngineControl;
import org.eclipse.amp.axf.core.IEngine;
import org.eclipse.amp.axf.core.ILifeCycleListener;
import org.eclipse.amp.axf.core.IModel;
import org.eclipse.amp.axf.core.IObservationProvider;
import org.eclipse.amp.axf.core.IStateListener;
import org.eclipse.amp.axf.core.LifecycleObservationAdapter;
import org.eclipse.amp.axf.ide.AXFWorkbenchPlugin;
import org.eclipse.amp.axf.ide.IModelWorkbenchListener;
import org.eclipse.amp.axf.ide.ModelViewManager;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;

public abstract class ModelRunHandler
extends AbstractHandler
implements ILifeCycleListener,
IModelWorkbenchListener {
    private IModel model;
    private EngineControl control;
    private IStateListener delegate;

    public ModelRunHandler(EngineControl control) {
        this.control = control;
        this.delegate = new LifecycleObservationAdapter((ILifeCycleListener)this);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.getRunner().control(this.control);
        ModelViewManager manager = AXFWorkbenchPlugin.getDefault().getManager();
        manager.getHandlers().notifyHandlers();
        return null;
    }

    public IEngine getRunner() {
        return this.model != null ? this.model.getEngine() : null;
    }

    public boolean isEnabled() {
        return this.getRunner() != null && !this.getRunner().isCloseRequested();
    }

    public void notifyChange() {
        if (AXFWorkbenchPlugin.getDefault() != null) {
            IWorkbench workbench = AXFWorkbenchPlugin.getDefault().getWorkbench();
            if (this.model != null && workbench.getDisplay() != null && !workbench.getDisplay().isDisposed()) {
                workbench.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ModelRunHandler.this.fireHandlerChanged(new HandlerEvent((IHandler)ModelRunHandler.this, true, false));
                    }
                });
            }
        }
    }

    public synchronized void observing(IObservationProvider model) {
        this.model = (IModel)model;
    }

    public synchronized void observationEnd(IObservationProvider model) {
        if (model == this.model) {
            this.model = null;
        }
    }

    public void stateChange(Object key, Object updated) {
        this.delegate.stateChange(key, updated);
        this.notifyChange();
    }

    @Override
    public synchronized void modelActivated(IModel model) {
        this.model = model;
        this.notifyChange();
    }

    @Override
    public void modelAdded(IModel model) {
    }

    @Override
    public void modelRemoved(IModel model) {
    }

    @Override
    public void viewActivated(IWorkbenchPart part) {
    }

    @Override
    public void viewAdded(IWorkbenchPart part) {
    }

    @Override
    public void viewRemoved(IWorkbenchPart part) {
    }

    public void observationEnding(IObservationProvider observed) {
    }

    public void observeCreate(IObservationProvider observed) {
    }

    public void observeInitialize(IObservationProvider observed) {
    }

    public void observeStart(IObservationProvider observed) {
    }

    public void observeStop(IObservationProvider observed) {
    }

    public void observeUpdate(IObservationProvider observed) {
    }
}

