/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm.act.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITableItemColorProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.metaabm.IID;
import org.metaabm.MetaABMPackage;
import org.metaabm.SNamed;
import org.metaabm.act.AAct;
import org.metaabm.act.AGroup;
import org.metaabm.act.AInput;
import org.metaabm.act.ARoot;
import org.metaabm.act.ASelect;
import org.metaabm.act.ASink;
import org.metaabm.act.ATransform;
import org.metaabm.act.MetaABMActFactory;
import org.metaabm.act.MetaABMActPackage;
import org.metaabm.act.provider.AActWrapperItemProvider;
import org.metaabm.commands.RemoveActTargetsCommand;
import org.metaabm.commands.SetLabelCommand;
import org.metaabm.commands.SuggestLabelCommand;
import org.metaabm.function.FFunction;
import org.metaabm.provider.IIDItemProvider;
import org.metaabm.provider.MetaABMEditPlugin;

public class AActItemProvider
extends IIDItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
ITableItemLabelProvider,
ITableItemColorProvider,
IItemColorProvider {
    public AActItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addSourcesPropertyDescriptor(object);
            this.addTargetsPropertyDescriptor(object);
            this.addReferencePropertyDescriptor(object);
            this.addGroupPropertyDescriptor(object);
            this.addSelectedPropertyDescriptor(object);
            this.addAllSourcesPropertyDescriptor(object);
            this.addAllTargetsPropertyDescriptor(object);
            this.addRootSelectedPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addSourcesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_AAct_sources_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_AAct_sources_feature", "_UI_AAct_type"), (EStructuralFeature)MetaABMActPackage.Literals.AACT__SOURCES, true, false, true, null, this.getString("_UI_RelationsPropertyCategory"), new String[]{"org.eclipse.ui.views.properties.expert"}));
    }

    protected void addTargetsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_AAct_targets_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_AAct_targets_feature", "_UI_AAct_type"), (EStructuralFeature)MetaABMActPackage.Literals.AACT__TARGETS, true, false, true, null, this.getString("_UI_RelationsPropertyCategory"), new String[]{"org.eclipse.ui.views.properties.expert"}));
    }

    protected void addReferencePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_AAct_reference_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_AAct_reference_feature", "_UI_AAct_type"), (EStructuralFeature)MetaABMActPackage.Literals.AACT__REFERENCE, false, false, true, null, this.getString("_UI_RelationsPropertyCategory"), new String[]{"org.eclipse.ui.views.properties.expert"}));
    }

    protected void addGroupPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_AAct_group_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_AAct_group_feature", "_UI_AAct_type"), (EStructuralFeature)MetaABMActPackage.Literals.AACT__GROUP, false, false, true, null, this.getString("_UI_RelationsPropertyCategory"), new String[]{"org.eclipse.ui.views.properties.expert"}));
    }

    protected void addSelectedPropertyDescriptor(Object object) {
        ItemPropertyDescriptor createItemPropertyDescriptor = new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_AAct_selected_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_AAct_selected_feature", "_UI_AAct_type"), (EStructuralFeature)MetaABMActPackage.Literals.AACT__SELECTED, true, true, true, null, this.getString("_UI_ActPropertyCategory"), null){

            public Collection<?> getChoiceOfValues(Object object) {
                Collection original = super.getChoiceOfValues(object);
                ArrayList<AAct> potential = new ArrayList<AAct>();
                for (AAct candidate : original) {
                    if (!((AAct)object).isTargetOf((Object)candidate)) continue;
                    potential.add(candidate);
                }
                return potential;
            }
        };
        this.itemPropertyDescriptors.add(createItemPropertyDescriptor);
    }

    protected void addAllSourcesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_AAct_allSources_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_AAct_allSources_feature", "_UI_AAct_type"), (EStructuralFeature)MetaABMActPackage.Literals.AACT__ALL_SOURCES, false, false, true, null, this.getString("_UI_RelationsPropertyCategory"), new String[]{"org.eclipse.ui.views.properties.expert"}));
    }

    protected void addAllTargetsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_AAct_allTargets_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_AAct_allTargets_feature", "_UI_AAct_type"), (EStructuralFeature)MetaABMActPackage.Literals.AACT__ALL_TARGETS, false, false, true, null, this.getString("_UI_RelationsPropertyCategory"), new String[]{"org.eclipse.ui.views.properties.expert"}));
    }

    protected void addRootSelectedPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_AAct_rootSelected_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_AAct_rootSelected_feature", "_UI_AAct_type"), (EStructuralFeature)MetaABMActPackage.Literals.AACT__ROOT_SELECTED, false, false, false, null, this.getString("_UI_RelationsPropertyCategory"), new String[]{"org.eclipse.ui.views.properties.expert"}));
    }

    public void addTargets(EList<AAct> sources, EList<AAct> result) {
        for (AAct source : sources) {
            if (!result.contains((Object)source)) {
                result.add((Object)source);
            }
            Iterator iterator = source.getTargets().iterator();
            while (iterator.hasNext()) {
                AAct target;
                AAct run = target = (AAct)iterator.next();
                while (run.getTargets().size() == 1 && run.getSources().size() == 1 && !result.contains((Object)run)) {
                    result.add((Object)run);
                    run = (AAct)run.getTargets().get(0);
                }
            }
            this.addTargets((EList<AAct>)source.getTargets(), result);
        }
    }

    public Collection<?> getChildren(Object object) {
        if (object instanceof ARoot) {
            ARoot root = (ARoot)object;
            BasicEList targets = new BasicEList(Collections.singleton(root));
            BasicEList result = new BasicEList();
            this.addTargets((EList<AAct>)targets, (EList<AAct>)result);
            result.remove((Object)root);
            return result;
        }
        if (object instanceof AGroup) {
            return super.getChildren(object);
        }
        return Collections.EMPTY_LIST;
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            this.childrenFeatures = new ArrayList();
            this.childrenFeatures.add(MetaABMActPackage.Literals.AACT__TARGETS);
        }
        return this.childrenFeatures;
    }

    public static CompoundCommand createActDragCommand(EditingDomain domain, int eventID, AAct sourceAct, final AAct targetAct) {
        CompoundCommand cmd = new CompoundCommand(){

            public Collection<?> getAffectedObjects() {
                return Collections.singleton(targetAct);
            }
        };
        if (eventID == 4) {
            cmd.append(AddCommand.create((EditingDomain)domain, (Object)sourceAct, (Object)MetaABMActPackage.Literals.AACT__TARGETS, (Object)targetAct));
        } else if (eventID == 1) {
            Command create = CopyCommand.create((EditingDomain)domain, (Object)targetAct);
            cmd.appendAndExecute(create);
            AAct newAct = (AAct)new ArrayList(create.getResult()).get(0);
            cmd.appendAndExecute(AddCommand.create((EditingDomain)domain, (Object)sourceAct, (Object)MetaABMActPackage.Literals.AACT__TARGETS, (Object)newAct));
        } else if (eventID == 2) {
            cmd.append(AddCommand.create((EditingDomain)domain, (Object)sourceAct, (Object)MetaABMActPackage.Literals.AACT__TARGETS, (Object)targetAct));
            EList sources = targetAct.getSources();
            sources.remove((Object)sourceAct);
            for (AAct targetSource : sources) {
                cmd.append(RemoveCommand.create((EditingDomain)domain, (Object)targetSource, (Object)MetaABMActPackage.Literals.AACT__TARGETS, (Object)targetAct));
            }
        }
        return cmd;
    }

    protected Command createDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
        if (owner instanceof AAct) {
            AAct source = (AAct)owner;
            ArrayList<AAct> allSources = new ArrayList<AAct>((Collection<AAct>)source.getAllSources());
            allSources.add(source);
            CompoundCommand cmd = new CompoundCommand();
            for (Object object : collection) {
                if (!(object instanceof AAct)) continue;
                AAct target = (AAct)object;
                cmd.append((Command)AActItemProvider.createActDragCommand(domain, operation, source, target));
            }
            return cmd;
        }
        return super.createDragAndDropCommand(domain, owner, location, operations, operation, collection);
    }

    protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
        if (feature == MetaABMActPackage.Literals.AACT__SOURCES) {
            CompoundCommand cmd = new CompoundCommand("Add Source");
            SuggestLabelCommand suggestLabelCommand = new SuggestLabelCommand(this, domain, (IID)owner);
            cmd.append(super.createAddCommand(domain, owner, feature, collection, index));
            cmd.append((Command)suggestLabelCommand);
            return cmd;
        }
        if (feature == MetaABMActPackage.Literals.AACT__TARGETS) {
            AAct source = (AAct)owner;
            if (Collections.disjoint(source.getAllSources(), collection) && !collection.contains(owner)) {
                CompoundCommand cmd = new CompoundCommand("Add Target");
                SuggestLabelCommand suggestLabelCommand = new SuggestLabelCommand(domain, collection);
                cmd.append(super.createAddCommand(domain, owner, feature, collection, index));
                AGroup group = source.getGroup();
                if (group != null) {
                    ArrayList newMembers = new ArrayList(collection);
                    newMembers.removeAll((Collection<?>)group.getMembers());
                    if (newMembers.size() > 0) {
                        cmd.append(AddCommand.create((EditingDomain)domain, (Object)group, (Object)MetaABMActPackage.Literals.AGROUP__MEMBERS, newMembers));
                    }
                }
                for (Object act : collection) {
                    AActItemProvider.reassignSelects(domain, cmd, source, (AAct)act);
                }
                cmd.append((Command)suggestLabelCommand);
                return cmd;
            }
            return UnexecutableCommand.INSTANCE;
        }
        return super.createAddCommand(domain, owner, feature, collection, index);
    }

    protected Command createSetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index) {
        AAct actOwner = (AAct)owner;
        if (feature == MetaABMPackage.Literals.IID__LABEL || feature == MetaABMPackage.Literals.SNAMED__PLURAL_LABEL) {
            CompoundCommand cmd = new CompoundCommand();
            ArrayList<SuggestLabelCommand> sugCmds = new ArrayList<SuggestLabelCommand>();
            EList allTargets = actOwner.getAllTargets();
            for (AAct act : allTargets) {
                sugCmds.add(new SuggestLabelCommand(domain, (IID)act));
            }
            Command createSetCommand = SetLabelCommand.create(domain, owner, feature, value, index);
            cmd.append(createSetCommand);
            for (SuggestLabelCommand sugCmd : sugCmds) {
                cmd.append((Command)sugCmd);
            }
            return cmd;
        }
        if (feature == MetaABMActPackage.Literals.ASINK__FUNCTION || feature == MetaABMActPackage.Literals.AINPUT__LITERAL || feature == MetaABMActPackage.Literals.AACCESSOR__ATTRIBUTE || feature == MetaABMActPackage.Literals.ASET__PARAMETER || feature == MetaABMActPackage.Literals.ABUILD_PROJECTION__PROJECTION || feature == MetaABMActPackage.Literals.ACREATE_AGENTS__AGENT_COUNT || feature == MetaABMActPackage.Literals.ASCHEDULE__PICK || feature == MetaABMActPackage.Literals.ASCHEDULE__PRIORITY || feature == MetaABMActPackage.Literals.ASCHEDULE__INTERVAL || feature == MetaABMActPackage.Literals.ASCHEDULE__START || feature == MetaABMActPackage.Literals.ASET__PARAMETER || feature == MetaABMActPackage.Literals.ASELECT__AGENT || feature == MetaABMActPackage.Literals.ASELECT__FOR || feature == MetaABMActPackage.Literals.ASELECT__SPACE || feature == MetaABMActPackage.Literals.AACT__SELECTED || feature == MetaABMActPackage.Literals.AINPUT__VALUE || feature == MetaABMActPackage.Literals.AINPUT__LITERAL || feature == MetaABMActPackage.Literals.ATRANSFORM__DESTINATION || feature == MetaABMActPackage.Literals.ANETWORK__WITHIN) {
            SuggestLabelCommand suggestLabelCommand = null;
            if (!(owner instanceof ASink && (((ASink)owner).isMultiValue() || feature == MetaABMActPackage.Literals.ASINK__FUNCTION && value instanceof FFunction && ((FFunction)value).isMultiValue()))) {
                suggestLabelCommand = new SuggestLabelCommand(domain, (IID)owner);
            }
            Command createSetCommand = super.createSetCommand(domain, owner, feature, value, index);
            createSetCommand.canExecute();
            CompoundCommand cmd = new CompoundCommand();
            cmd.append(createSetCommand);
            if (suggestLabelCommand != null) {
                cmd.append((Command)suggestLabelCommand);
            }
            return cmd;
        }
        Command createSetCommand = super.createSetCommand(domain, owner, feature, value, index);
        createSetCommand.canExecute();
        return createSetCommand;
    }

    protected Command createRemoveCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection) {
        if (feature == MetaABMActPackage.Literals.AACT__TARGETS) {
            CompoundCommand cmd = new CompoundCommand();
            for (Object target : collection) {
                if (!((AAct)owner).getTargets().contains(target)) continue;
                cmd.append((Command)new RemoveActTargetsCommand(domain, owner, feature, Collections.singleton(target)));
            }
            return cmd;
        }
        return super.createRemoveCommand(domain, owner, feature, collection);
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/AAct"));
    }

    @Override
    public String getText(Object object) {
        AAct act = (AAct)object;
        String label = act.getLabel();
        if (!(act.getSelected() instanceof ARoot) && act.getSelected() != null) {
            label = String.valueOf(label) + " [" + act.getSelected().getLabel() + "]";
        }
        if (act.getSources().size() > 0) {
            Object[] terms = new String[act.getSources().size()];
            int i = 0;
            while (i < terms.length) {
                terms[i] = ((AAct)act.getSources().get(i)).getLabel();
                ++i;
            }
            label = String.valueOf(label) + "[<-" + StringUtils.join((Object[])terms, (String)",") + "]";
        }
        return label == null || label.length() == 0 ? this.getString("_UI_" + ((EObject)object).eClass().getName() + "_type") : label;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        AAct act = (AAct)notification.getNotifier();
        ASelect root = act.getRootSelected();
        switch (notification.getFeatureID(AAct.class)) {
            case 0: 
            case 1: {
                ASelect rootSelected = root;
                if (rootSelected != null) {
                    for (AAct allTarget : rootSelected.getAllTargets()) {
                        if (allTarget == act) continue;
                        this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)allTarget, false, true));
                        if (!(allTarget instanceof ASink)) continue;
                        for (AInput input : ((ASink)allTarget).getInputs()) {
                            if (input.getValue() != act) continue;
                            this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)input, false, true));
                        }
                    }
                }
                for (Object object : this.getChildren(notification.getNotifier())) {
                    if (!(object instanceof AActWrapperItemProvider)) continue;
                    this.fireNotifyChanged((Notification)new ViewerNotification(notification, object, false, true));
                }
            }
            case 4: 
            case 6: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)act, false, true));
                return;
            }
            case 2: 
            case 3: 
            case 5: 
            case 13: {
                if (root != null) {
                    this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)root, true, false));
                    this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)root.getAllTargets(), false, true));
                }
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        for (EClassifier cl : MetaABMActPackage.eINSTANCE.getEClassifiers()) {
            EClass actClass;
            if (!(cl instanceof EClass) || !MetaABMActPackage.Literals.AACT.isSuperTypeOf(actClass = (EClass)cl) || MetaABMActPackage.Literals.AROOT.isSuperTypeOf(actClass) || actClass.isAbstract()) continue;
            newChildDescriptors.add(this.createChildParameter(MetaABMActPackage.Literals.AACT__TARGETS, MetaABMActFactory.eINSTANCE.create(actClass)));
        }
    }

    protected Object createWrapper(EObject owner, EStructuralFeature feature, Object value, int index) {
        if (!((EReference)feature).isContainment() && value instanceof AAct && !(value instanceof ARoot)) {
            return new AActWrapperItemProvider(value, owner, feature, index, this.adapterFactory);
        }
        return value;
    }

    protected boolean isWrappingNeeded(Object object) {
        return false;
    }

    @Override
    public boolean hasChildren(Object object) {
        return object instanceof ARoot && ((AAct)object).getTargets().size() > 0 || object instanceof AGroup && ((AGroup)object).getMembers().size() > 0;
    }

    protected static Collection<ASelect> getSourceSelects(AAct source) {
        HashSet<ASelect> allSourceSelects = new HashSet<ASelect>();
        if (source instanceof ASelect) {
            allSourceSelects.add((ASelect)source);
        } else {
            allSourceSelects.add(source.getSelected());
        }
        for (Object object : source.getAllSources()) {
            if (!(object instanceof ASelect)) continue;
            allSourceSelects.add((ASelect)object);
        }
        return allSourceSelects;
    }

    protected static void reassignSelects(EditingDomain domain, CompoundCommand cmd, AAct newSource, AAct value) {
        ASelect newSelect = null;
        newSelect = newSource instanceof ASelect ? (ASelect)newSource : newSource.getSelected();
        if (newSelect != null) {
            Collection<ASelect> allSourceSelects = AActItemProvider.getSourceSelects(newSource);
            AActItemProvider.reassignSelects(domain, cmd, value, newSelect, allSourceSelects, new HashSet<Object>());
        }
    }

    private static void reassignSelects(EditingDomain domain, CompoundCommand cmd, AAct act, ASelect newSelect, Collection<ASelect> allSourceSelects, Collection<Object> processed) {
        processed.add(act);
        if (act instanceof ATransform) {
            if (act.getSelected() == null || !allSourceSelects.contains(act.getSelected())) {
                cmd.append(SetCommand.create((EditingDomain)domain, (Object)act, (Object)MetaABMActPackage.Literals.AACT__SELECTED, (Object)newSelect.getSelected()));
            }
            if (((ATransform)act).getDestination() == null || !allSourceSelects.contains(((ATransform)act).getDestination())) {
                cmd.append(SetCommand.create((EditingDomain)domain, (Object)act, (Object)MetaABMActPackage.Literals.ATRANSFORM__DESTINATION, (Object)newSelect));
            }
        } else if (!allSourceSelects.contains(act.getSelected())) {
            cmd.append(SetCommand.create((EditingDomain)domain, (Object)act, (Object)MetaABMActPackage.Literals.AACT__SELECTED, (Object)newSelect));
        }
        if (act instanceof ASink) {
            for (AInput input : ((ASink)act).getInputs()) {
                if (allSourceSelects.contains(input.getSelected()) || processed.contains(input)) continue;
                cmd.append(SetCommand.create((EditingDomain)domain, (Object)input, (Object)MetaABMActPackage.Literals.AINPUT__SELECTED, (Object)newSelect));
                processed.add(input);
            }
        }
        if (act instanceof ASelect) {
            allSourceSelects.add((ASelect)act);
        }
        for (AAct target : act.getAllTargets()) {
            if (processed.contains(target)) continue;
            AActItemProvider.reassignSelects(domain, cmd, target, newSelect, allSourceSelects, processed);
        }
    }

    protected String suggestSeperatedSourceLabel(Object object, String seperator) {
        String label;
        AAct source = (AAct)object;
        EList sources = source.getSources();
        switch (sources.size()) {
            case 0: {
                label = String.valueOf(seperator) + " Undefined";
                break;
            }
            case 1: {
                label = "(" + seperator + ") " + StringUtils.strip((String)((AAct)sources.get(0)).getLabel());
                break;
            }
            default: {
                label = "(" + StringUtils.join(AActItemProvider.labels(sources).iterator(), (String)(" " + seperator + " ")) + ")";
            }
        }
        return label;
    }

    @Override
    public String getColumnText(Object object, int columnIndex) {
        if (columnIndex == 0) {
            return ((IID)object).getLabel();
        }
        if (columnIndex == 1) {
            if (object instanceof SNamed) {
                return ((SNamed)object).getDescription();
            }
            return this.getText(object);
        }
        return super.getColumnText(object, columnIndex);
    }

    public Object getParent(Object object) {
        if (!(object instanceof ARoot)) {
            EList sources = ((AAct)object).getSources();
            if (!sources.isEmpty()) {
                return sources.get(0);
            }
        } else if (object instanceof ARoot) {
            return ((AAct)object).getGroup();
        }
        return super.getParent(object);
    }

    @Override
    public ResourceLocator getResourceLocator() {
        return MetaABMEditPlugin.INSTANCE;
    }

    public List<AAct> getParents(Object object) {
        if (object instanceof ARoot) {
            Collections.singletonList(((AAct)object).getGroup());
        }
        return ((AAct)object).getSources();
    }

    @Override
    public String suggestID(IID object) {
        String suggestID = StringUtils.deleteWhitespace((String)this.suggestLabel(object));
        suggestID = StringUtils.replaceChars((String)suggestID, (String)"[]()", null);
        return StringUtils.uncapitalize((String)suggestID);
    }
}

