/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw3d.DelegatingLayoutManager;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Position3D;
import org.eclipse.draw3d.geometry.Vector3fImpl;

public class SurfaceLayout
extends XYLayout
implements DelegatingLayoutManager {
    private Map<IFigure, SurfaceConstraint> m_constraints = new HashMap<IFigure, SurfaceConstraint>();
    private LayoutManager m_delegate;

    public static boolean setDelegate(IFigure3D io_figure, LayoutManager i_delegate) {
        if (io_figure == null) {
            throw new NullPointerException("io_figure must not be null");
        }
        Object layoutManager = io_figure.getLayoutManager();
        if (layoutManager == null) {
            if (i_delegate == null) {
                return true;
            }
            layoutManager = new SurfaceLayout();
            io_figure.setLayoutManager((LayoutManager)layoutManager);
        }
        if (layoutManager instanceof DelegatingLayoutManager) {
            DelegatingLayoutManager delegatingLayout = (DelegatingLayoutManager)layoutManager;
            delegatingLayout.setDelegate(i_delegate);
            return true;
        }
        return false;
    }

    public Object getConstraint(IFigure i_child) {
        if (this.m_delegate == null) {
            return null;
        }
        return this.m_delegate.getConstraint(i_child);
    }

    public LayoutManager getDelegate() {
        return this.m_delegate;
    }

    public Dimension getMinimumSize(IFigure i_container, int i_hint, int i_hint2) {
        if (this.m_delegate == null) {
            return new Dimension(i_hint, i_hint2);
        }
        return this.m_delegate.getMinimumSize(i_container, i_hint, i_hint2);
    }

    public Dimension getPreferredSize(IFigure i_container, int i_hint, int i_hint2) {
        if (this.m_delegate == null) {
            return new Dimension(i_hint, i_hint2);
        }
        return this.m_delegate.getPreferredSize(i_container, i_hint, i_hint2);
    }

    public void invalidate() {
        if (this.m_delegate != null) {
            this.m_delegate.invalidate();
        }
    }

    public void layout(IFigure i_container) {
        if (this.m_delegate != null) {
            this.m_delegate.layout(i_container);
        }
        if (i_container instanceof IFigure3D) {
            List children = i_container.getChildren();
            for (Object child : children) {
                SurfaceConstraint constraint;
                if (!(child instanceof IFigure3D) || (constraint = this.m_constraints.get(child)) != null && !constraint.doZCorrection) continue;
                IFigure3D child3D = (IFigure3D)child;
                Position3D position3d = child3D.getPosition3D();
                IVector3f childLocation = position3d.getLocation3D();
                float depth = position3d.getSize3D().getZ();
                Vector3fImpl newLocation = new Vector3fImpl(childLocation);
                newLocation.z = -1.0f * depth;
                position3d.setLocation3D((IVector3f)newLocation);
            }
        }
    }

    public void remove(IFigure i_child) {
        if (this.m_delegate != null) {
            this.m_delegate.remove(i_child);
        }
    }

    public void setConstraint(IFigure i_child, Object i_constraint) {
        if (i_constraint instanceof SurfaceConstraint) {
            SurfaceConstraint surfaceConstraint = (SurfaceConstraint)i_constraint;
            this.m_constraints.put(i_child, surfaceConstraint);
        } else if (this.m_delegate != null) {
            this.m_delegate.setConstraint(i_child, i_constraint);
        }
    }

    public void setDelegate(LayoutManager i_delegate) {
        this.m_delegate = i_delegate;
    }

    public static class SurfaceConstraint {
        public boolean doZCorrection = true;
    }
}

