/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SBorderRule implements Enumerator
{
    STICKY_LITERAL(1000, "Sticky", "STICKY"),
    STRICT_LITERAL(100, "Strict", "STRICT"),
    BOUNCY_LITERAL(2000, "Bouncy", "BOUNCY"),
    PERIODIC_LITERAL(3000, "Periodic", "PERIODIC");

    public static final int STICKY = 1000;
    public static final int STRICT = 100;
    public static final int BOUNCY = 2000;
    public static final int PERIODIC = 3000;
    private static final SBorderRule[] VALUES_ARRAY;
    public static final List<SBorderRule> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SBorderRule[]{STICKY_LITERAL, STRICT_LITERAL, BOUNCY_LITERAL, PERIODIC_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SBorderRule get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SBorderRule result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SBorderRule getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SBorderRule result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SBorderRule get(int value) {
        switch (value) {
            case 1000: {
                return STICKY_LITERAL;
            }
            case 100: {
                return STRICT_LITERAL;
            }
            case 2000: {
                return BOUNCY_LITERAL;
            }
            case 3000: {
                return PERIODIC_LITERAL;
            }
        }
        return null;
    }

    private SBorderRule(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

