/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf.zest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.amp.axf.core.ICompositionProvider;
import org.eclipse.amp.axf.space.IGraphProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.zest.core.viewers.IGraphEntityContentProvider;

public class ZestContentProvider
implements IGraphEntityContentProvider {
    IGraphProvider graphProvider;
    ICompositionProvider compostionProvider;
    private Collection<Object> graphs;

    public ZestContentProvider(IGraphProvider graphProvider, ICompositionProvider compostionProvider) {
        this.graphProvider = graphProvider;
        this.compostionProvider = compostionProvider;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    Collection<Object> collectGraphs(Object parent, Collection<Object> buildCollection) {
        if (this.graphProvider.isGraph(parent)) {
            buildCollection.add(parent);
        }
        if (this.compostionProvider.isChildrenComposition(parent)) {
            for (Object child : this.compostionProvider.getIteratable(parent)) {
                this.collectGraphs(child, buildCollection);
            }
        }
        return buildCollection;
    }

    public Object[] getElements(Object parent) {
        HashSet allElements = new HashSet();
        this.graphs = this.collectGraphs(parent, new HashSet<Object>());
        for (Object graph : this.graphs) {
            Map graphMap = this.graphProvider.getAdjacencyMap(graph);
            Collection values = graphMap.values();
            for (Object valueMember : values) {
                allElements.addAll((Collection)valueMember);
            }
            allElements.addAll(graphMap.keySet());
        }
        return allElements.toArray();
    }

    public Object[] getConnectedTo(Object object) {
        ArrayList neighborsFor = new ArrayList();
        for (Object graph : this.graphs) {
            neighborsFor.addAll(this.graphProvider.getNeighborsFor(graph, object));
        }
        return neighborsFor.toArray();
    }
}

