/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model;

import org.ascape.model.LocatedAgent;
import org.ascape.model.space.Continuous;
import org.ascape.model.space.Coordinate;
import org.ascape.model.space.Coordinate2DContinuous;

public class MomentumAgent
extends LocatedAgent {
    private static final long serialVersionUID = 1L;
    private int agentSize = 5;
    protected double velocity;
    protected double heading;

    @Override
    public void moveToRandomLocation() {
        Coordinate coord = this.getScape().findRandomCoordinate();
        if (coord != null) {
            this.moveTo(coord);
        } else {
            System.err.println("Warning: no location to move to. Killing agent.");
            this.die();
        }
    }

    @Override
    public void randomWalk() {
        this.heading = this.randomInRange(0.0, Math.PI * 2);
        this.movement();
    }

    @Override
    public void moveTo(Coordinate coordinate) {
        this.moveTo(coordinate, true);
    }

    public void headToward(LocatedAgent a) {
        this.headToward(a.getCoordinate());
    }

    public double findHeadingToward(LocatedAgent target) {
        return this.findHeadingToward(target.getCoordinate());
    }

    public void headAway(LocatedAgent a) {
        this.headAway(a.getCoordinate());
    }

    public void headToward(Coordinate target) {
        this.setHeading(this.findHeadingToward(target));
    }

    public double findHeadingToward(Coordinate target) {
        double x1 = ((Coordinate2DContinuous)this.getCoordinate()).getXValue();
        double y1 = ((Coordinate2DContinuous)this.getCoordinate()).getYValue();
        double x2 = ((Coordinate2DContinuous)target).getXValue();
        double y2 = ((Coordinate2DContinuous)target).getYValue();
        return Math.atan2(y2 - y1, x2 - x1);
    }

    public void headAway(Coordinate target) {
        this.setHeading(this.findHeadingAway(target));
    }

    public double findHeadingAway(LocatedAgent target) {
        return this.findHeadingAway(target.getCoordinate());
    }

    public double findHeadingAway(Coordinate target) {
        return Math.PI + this.findHeadingToward(target);
    }

    public void moveTo(Coordinate coordinate, boolean adjustHeading) {
        if (adjustHeading) {
            this.setCoordinate(coordinate);
        } else {
            this.setCoordinate(coordinate);
        }
    }

    @Override
    public int getAgentSize() {
        return this.agentSize;
    }

    @Override
    public void setAgentSize(int agentSize) {
        this.agentSize = agentSize;
    }

    @Override
    public void movement() {
        double distance = ((Continuous)((Object)this.getScape().getSpace())).distancePerIteration(this.velocity);
        double x1 = ((Coordinate2DContinuous)this.getCoordinate()).getXValue();
        double y1 = ((Coordinate2DContinuous)this.getCoordinate()).getYValue();
        double x2 = x1 + distance * Math.cos(this.heading);
        double y2 = y1 + distance * Math.sin(this.heading);
        Coordinate2DContinuous coor = new Coordinate2DContinuous(x2, y2);
        ((Continuous)((Object)this.getScape().getSpace())).normalize(coor);
        this.moveTo(coor, false);
    }

    @Override
    public String toString() {
        if (this.getName() != null) {
            if (this.coordinate != null) {
                return String.valueOf(this.getName()) + " " + this.coordinate;
            }
            return this.getName();
        }
        if (this.coordinate != null) {
            return "Continuous Agent at " + this.coordinate;
        }
        return "Continuous Agent";
    }

    public double getVelocity() {
        return this.velocity;
    }

    public void setVelocity(double velocity) {
        this.velocity = velocity;
    }

    public double getHeading() {
        return this.heading;
    }

    public void setHeading(double heading) {
        this.heading = heading;
    }
}

