/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.util.vis;

import org.ascape.util.data.UnitIntervalDataPoint;
import org.ascape.util.vis.ColorFeatureGradiated;
import org.eclipse.swt.graphics.Color;

public class ColorFeatureGradiatedIndex
extends ColorFeatureGradiated {
    private static final long serialVersionUID = 1L;
    private Color[] indexedColors = new Color[1001];

    public ColorFeatureGradiatedIndex(String name) {
        super(name);
    }

    public ColorFeatureGradiatedIndex(String name, Color maximumColor, UnitIntervalDataPoint dataPoint) {
        super(name, maximumColor, dataPoint);
    }

    public ColorFeatureGradiatedIndex(String name, Color maximumColor, Color minimumColor, UnitIntervalDataPoint dataPoint) {
        super(name, maximumColor, minimumColor, dataPoint);
    }

    @Override
    public Color getColor(Object object) {
        float val = (float)this.dataPoint.getValue(object);
        try {
            Color c = this.indexedColors[(int)(val * 1000.0f)];
            if (c == null) {
                float agentColor = val;
                float r = this.redMinimum + agentColor * (this.redMaximum - this.redMinimum);
                float g = this.greenMinimum + agentColor * (this.greenMaximum - this.greenMinimum);
                float b = this.blueMinimum + agentColor * (this.blueMaximum - this.blueMinimum);
                this.indexedColors[(int)(val * 1000.0f)] = c = ColorFeatureGradiatedIndex.create(r, g, b);
            }
            return c;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RuntimeException("An error occurred while drawing a color feature; Gradiated Index Value not in [0.0, 1.0]: " + val);
        }
    }
}

