/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.space;

import java.util.Iterator;
import org.ascape.model.space.CollectionSpace;
import org.ascape.model.space.Continuous;
import org.ascape.model.space.Coordinate;
import org.ascape.model.space.Coordinate2DContinuous;
import org.ascape.model.space.Location;

public class Continuous2D
extends CollectionSpace
implements Continuous {
    private static final long serialVersionUID = 1L;
    private int size;

    public Continuous2D() {
        this(new Coordinate2DContinuous(0.0, 0.0));
    }

    public Continuous2D(Coordinate2DContinuous extent) {
        this.setExtent(extent);
    }

    public void coordinateSweep() {
    }

    @Override
    public void populate() {
        super.populate();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            ((Location)iter.next()).setCoordinate(new Coordinate2DContinuous(0.0, 0.0));
        }
    }

    @Override
    public double calculateDistance(Coordinate origin, Coordinate target) {
        if (this.geometry.isPeriodic()) {
            double originX = ((Coordinate2DContinuous)origin).getXValue();
            double originY = ((Coordinate2DContinuous)origin).getYValue();
            double targetX = ((Coordinate2DContinuous)target).getXValue();
            double targetY = ((Coordinate2DContinuous)target).getYValue();
            double boundsX = ((Coordinate2DContinuous)this.getExtent()).getXValue();
            double boundsY = ((Coordinate2DContinuous)this.getExtent()).getYValue();
            double distX = originX < targetX ? Math.min(targetX - originX, originX + (boundsX - targetX)) : Math.min(originX - targetX, targetX + (boundsX - originX));
            double distY = originY < targetY ? Math.min(targetY - originY, originY + (boundsY - targetY)) : Math.min(originY - targetY, targetY + (boundsY - originY));
            return Math.sqrt(distX * distX + distY * distY);
        }
        double minXDistance = Math.abs(((Coordinate2DContinuous)origin).getXValue() - ((Coordinate2DContinuous)target).getXValue());
        double minYDistance = Math.abs(((Coordinate2DContinuous)origin).getYValue() - ((Coordinate2DContinuous)target).getYValue());
        return Math.sqrt(minXDistance * minXDistance + minYDistance * minYDistance);
    }

    public Coordinate calculateRelativePosition(Location origin, Location target) {
        return this.calculateRelativePosition(origin.getCoordinate(), target.getCoordinate());
    }

    public Coordinate calculateRelativePosition(Coordinate origin, Coordinate target) {
        if (this.geometry.isPeriodic()) {
            double outsideSpanY;
            double insideSpanY;
            double outsideSpanX;
            double insideSpanX;
            double originX = ((Coordinate2DContinuous)origin).getXValue();
            double originY = ((Coordinate2DContinuous)origin).getYValue();
            double targetX = ((Coordinate2DContinuous)target).getXValue();
            double targetY = ((Coordinate2DContinuous)target).getYValue();
            double boundsX = ((Coordinate2DContinuous)this.getExtent()).getXValue();
            double boundsY = ((Coordinate2DContinuous)this.getExtent()).getYValue();
            double distX = originX < targetX ? ((insideSpanX = targetX - originX) < (outsideSpanX = originX + (boundsX - targetX)) ? insideSpanX : -outsideSpanX) : ((insideSpanX = originX - targetX) < (outsideSpanX = targetX + (boundsX - originX)) ? -insideSpanX : outsideSpanX);
            double distY = originY < targetY ? ((insideSpanY = targetY - originY) < (outsideSpanY = originY + (boundsY - targetY)) ? insideSpanY : -outsideSpanY) : ((insideSpanY = originY - targetY) < (outsideSpanY = targetY + (boundsY - originY)) ? -insideSpanY : outsideSpanY);
            return new Coordinate2DContinuous(distX, distY);
        }
        double distX = ((Coordinate2DContinuous)target).getXValue() - ((Coordinate2DContinuous)origin).getXValue();
        double distY = ((Coordinate2DContinuous)target).getYValue() - ((Coordinate2DContinuous)origin).getYValue();
        return new Coordinate2DContinuous(distX, distY);
    }

    @Override
    public double distancePerIteration(double velocity) {
        return velocity;
    }

    @Override
    public Coordinate findRandomCoordinate() {
        double maxX = ((Coordinate2DContinuous)this.getExtent()).getXValue();
        double maxY = ((Coordinate2DContinuous)this.getExtent()).getYValue();
        double randX = this.randomInRange(0.0, maxX);
        double randY = this.randomInRange(0.0, maxY);
        return new Coordinate2DContinuous(randX, randY);
    }

    @Override
    public void moveToward(Location origin, Coordinate target, double distance) {
        double originX = ((Coordinate2DContinuous)origin.getCoordinate()).getXValue();
        double originY = ((Coordinate2DContinuous)origin.getCoordinate()).getYValue();
        double targetX = ((Coordinate2DContinuous)target).getXValue();
        double targetY = ((Coordinate2DContinuous)target).getYValue();
        if (this.getGeometry().isPeriodic()) {
            double boundsX = ((Coordinate2DContinuous)this.getExtent()).getXValue();
            double boundsY = ((Coordinate2DContinuous)this.getExtent()).getYValue();
            if (originX < targetX) {
                if (targetX - originX > originX + (boundsX - targetX)) {
                    originX += boundsX;
                }
            } else if (originX - targetX > targetX + (boundsX - originX)) {
                targetX += boundsX;
            }
            if (originY < targetY) {
                if (targetY - originY > originY + (boundsY - targetY)) {
                    originY += boundsY;
                }
            } else if (originY - targetY > targetY + (boundsY - originY)) {
                targetY += boundsY;
            }
        }
        double distanceX = targetX - originX;
        double distanceY = targetY - originY;
        double theta = Math.atan2(distanceY, distanceX);
        double deltaX = distance * Math.cos(theta);
        double deltaY = distance * Math.sin(theta);
        deltaX += originX;
        deltaY += originY;
        if (originX < targetX) {
            if (deltaX > targetX) {
                deltaX = targetX;
            }
        } else if (deltaX < targetX) {
            deltaX = targetX;
        }
        if (originY < targetY) {
            if (deltaY > targetY) {
                deltaY = targetY;
            }
        } else if (deltaY < targetY) {
            deltaY = targetY;
        }
        ((Coordinate2DContinuous)origin.getCoordinate()).setXValue(deltaX);
        ((Coordinate2DContinuous)origin.getCoordinate()).setYValue(deltaY);
        this.normalize(origin.getCoordinate());
    }

    @Override
    public void moveAway(Location origin, Coordinate target, double distance) {
        double originX = ((Coordinate2DContinuous)origin.getCoordinate()).getXValue();
        double originY = ((Coordinate2DContinuous)origin.getCoordinate()).getYValue();
        double targetX = ((Coordinate2DContinuous)target).getXValue();
        double targetY = ((Coordinate2DContinuous)target).getYValue();
        double distanceX = targetX - originX;
        double distanceY = targetY - originY;
        double theta = Math.atan2(distanceY, distanceX);
        double deltaX = distance * Math.cos(theta);
        double deltaY = distance * Math.sin(theta);
        deltaX = originX - deltaX;
        deltaY = originY - deltaY;
        ((Coordinate2DContinuous)origin.getCoordinate()).setXValue(deltaX);
        ((Coordinate2DContinuous)origin.getCoordinate()).setYValue(deltaY);
        this.normalize(origin.getCoordinate());
    }

    @Override
    public void normalize(Coordinate coor) {
        if (this.geometry.isPeriodic()) {
            if (((Coordinate2DContinuous)coor).getXValue() < 0.0) {
                ((Coordinate2DContinuous)coor).setXValue(((Coordinate2DContinuous)coor).getXValue() + ((Coordinate2DContinuous)this.getExtent()).getXValue());
            } else if (((Coordinate2DContinuous)coor).getXValue() > ((Coordinate2DContinuous)this.getExtent()).getXValue()) {
                ((Coordinate2DContinuous)coor).setXValue(((Coordinate2DContinuous)coor).getXValue() - ((Coordinate2DContinuous)this.getExtent()).getXValue());
            }
            if (((Coordinate2DContinuous)coor).getYValue() < 0.0) {
                ((Coordinate2DContinuous)coor).setYValue(((Coordinate2DContinuous)coor).getYValue() + ((Coordinate2DContinuous)this.getExtent()).getYValue());
            } else if (((Coordinate2DContinuous)coor).getYValue() > ((Coordinate2DContinuous)this.getExtent()).getYValue()) {
                ((Coordinate2DContinuous)coor).setYValue(((Coordinate2DContinuous)coor).getYValue() - ((Coordinate2DContinuous)this.getExtent()).getYValue());
            }
        } else {
            if (((Coordinate2DContinuous)coor).getXValue() < 0.0) {
                ((Coordinate2DContinuous)coor).setXValue(0.0);
            } else if (((Coordinate2DContinuous)coor).getXValue() > ((Coordinate2DContinuous)this.getExtent()).getXValue()) {
                ((Coordinate2DContinuous)coor).setXValue(((Coordinate2DContinuous)this.getExtent()).getXValue());
            }
            if (((Coordinate2DContinuous)coor).getYValue() < 0.0) {
                ((Coordinate2DContinuous)coor).setYValue(0.0);
            } else if (((Coordinate2DContinuous)coor).getYValue() > ((Coordinate2DContinuous)this.getExtent()).getYValue()) {
                ((Coordinate2DContinuous)coor).setYValue(((Coordinate2DContinuous)this.getExtent()).getYValue());
            }
        }
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public int getSize() {
        return this.size;
    }
}

