/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d.lwjgl.texture;

import java.nio.IntBuffer;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw3d.graphics3d.DisplayListManager;
import org.eclipse.draw3d.graphics3d.lwjgl.font.LwjglFontManager;
import org.eclipse.draw3d.graphics3d.lwjgl.graphics.LwjglGraphics;
import org.eclipse.draw3d.graphics3d.lwjgl.texture.AbstractLwjglTexture;
import org.eclipse.draw3d.util.ColorConverter;
import org.eclipse.draw3d.util.Draw3DCache;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.opengl.GLCanvas;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.Pbuffer;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.RenderTexture;
import org.lwjgl.util.glu.GLU;

public class LwjglTexturePbuffer
extends AbstractLwjglTexture {
    private final GLCanvas m_context;
    private DisplayListManager m_displayListManager;
    private LwjglFontManager m_fontManager;
    private int m_glTexture;
    protected LwjglGraphics m_graphics;
    private int m_height;
    private Pbuffer m_pBuffer;
    private int m_width;

    private static Pbuffer createPBuffer(int i_width, int i_height) throws LWJGLException {
        RenderTexture renderTexture = new RenderTexture(false, true, false, false, 8354, 0);
        PixelFormat pixelFormat = new PixelFormat();
        return new Pbuffer(i_width, i_height, pixelFormat, renderTexture, null);
    }

    private static int createTexture() {
        int n;
        IntBuffer buffer = Draw3DCache.getIntBuffer((int)1);
        try {
            buffer.rewind();
            GL11.glGenTextures((IntBuffer)buffer);
            int glTexture = buffer.get(0);
            GL11.glBindTexture((int)3553, (int)glTexture);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            GL11.glBindTexture((int)3553, (int)0);
            n = glTexture;
        }
        catch (Throwable throwable) {
            Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{buffer});
            throw throwable;
        }
        Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{buffer});
        return n;
    }

    private static void deletePBuffer(Pbuffer i_pBuffer) {
        if (i_pBuffer != null) {
            i_pBuffer.destroy();
        }
    }

    private static void deleteTexture(int i_glTexture) {
        if (i_glTexture > 0) {
            IntBuffer buffer = Draw3DCache.getIntBuffer((int)1);
            try {
                buffer.rewind();
                buffer.put(i_glTexture);
                GL11.glDeleteTextures((IntBuffer)buffer);
            }
            catch (Throwable throwable) {
                Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{buffer});
                throw throwable;
            }
            Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{buffer});
        }
    }

    public static boolean isSupported(GLCanvas i_context) {
        if (i_context == null) {
            throw new NullPointerException("i_context must not be null");
        }
        int glTexture = 0;
        Pbuffer pBuffer = null;
        try {
            try {
                glTexture = LwjglTexturePbuffer.createTexture();
                pBuffer = LwjglTexturePbuffer.createPBuffer(32, 32);
                pBuffer.makeCurrent();
                GL11.glBindTexture((int)3553, (int)glTexture);
                pBuffer.releaseTexImage(8323);
                pBuffer.bindTexImage(8323);
            }
            catch (Exception exception) {
                GL11.glBindTexture((int)3553, (int)0);
                LwjglTexturePbuffer.deleteTexture(glTexture);
                LwjglTexturePbuffer.deletePBuffer(pBuffer);
                i_context.setCurrent();
                return false;
            }
        }
        finally {
            GL11.glBindTexture((int)3553, (int)0);
            LwjglTexturePbuffer.deleteTexture(glTexture);
            LwjglTexturePbuffer.deletePBuffer(pBuffer);
            i_context.setCurrent();
        }
        return true;
    }

    public LwjglTexturePbuffer(GLCanvas i_context, int i_width, int i_height, DisplayListManager i_displayListManager, LwjglFontManager i_fontManager) {
        if (i_context == null) {
            throw new NullPointerException("i_context must not be null");
        }
        this.m_context = i_context;
        this.setDimensions(i_width, i_height);
        this.m_displayListManager = i_displayListManager;
        this.m_fontManager = i_fontManager;
    }

    public void activate() {
        if (this.m_disposed) {
            throw new IllegalStateException("texture is disposed");
        }
        try {
            if (!this.m_valid || this.m_pBuffer != null && this.m_pBuffer.isBufferLost()) {
                this.m_graphics = new LwjglGraphics(this.m_width, this.m_height, this.m_displayListManager, this.m_fontManager);
                LwjglTexturePbuffer.deleteTexture(this.m_glTexture);
                LwjglTexturePbuffer.deletePBuffer(this.m_pBuffer);
                this.m_glTexture = LwjglTexturePbuffer.createTexture();
                this.m_pBuffer = LwjglTexturePbuffer.createPBuffer(this.m_width, this.m_height);
                this.m_pBuffer.makeCurrent();
                GL11.glDisable((int)32925);
                GL11.glShadeModel((int)7424);
                GL11.glDisable((int)2929);
                GL11.glDisable((int)2884);
                GL11.glHint((int)3154, (int)4354);
                GL11.glEnable((int)2848);
                GL11.glMatrixMode((int)5888);
                GL11.glLoadIdentity();
                GL11.glMatrixMode((int)5889);
                GL11.glLoadIdentity();
                GLU.gluOrtho2D((float)0.0f, (float)this.m_width, (float)this.m_height, (float)0.0f);
                GL11.glViewport((int)0, (int)0, (int)this.m_width, (int)this.m_height);
                this.m_valid = true;
            } else {
                this.m_pBuffer.makeCurrent();
            }
            GL11.glBindTexture((int)3553, (int)this.m_glTexture);
            this.m_pBuffer.releaseTexImage(8323);
            GL11.glBindTexture((int)3553, (int)0);
        }
        catch (LWJGLException ex) {
            throw new RuntimeException("caught exception while creating pbuffer", ex);
        }
    }

    public void clear(Color i_color, int i_alpha) {
        if (i_color == null) {
            throw new NullPointerException("i_color must not be null");
        }
        float[] color = ColorConverter.toFloatArray((Color)i_color, (int)i_alpha, null);
        GL11.glClearColor((float)color[0], (float)color[1], (float)color[2], (float)color[3]);
        GL11.glClear((int)16384);
    }

    public void deactivate() {
        if (this.m_disposed) {
            throw new IllegalStateException("texture is disposed");
        }
        GL11.glBindTexture((int)3553, (int)this.m_glTexture);
        this.m_pBuffer.bindTexImage(8323);
        this.m_context.setCurrent();
        GL11.glBindTexture((int)3553, (int)0);
    }

    public void dispose() {
        if (this.m_disposed) {
            return;
        }
        LwjglTexturePbuffer.deleteTexture(this.m_glTexture);
        this.m_glTexture = 0;
        LwjglTexturePbuffer.deletePBuffer(this.m_pBuffer);
        this.m_pBuffer = null;
        this.m_disposed = true;
    }

    public Graphics getGraphics() {
        if (this.m_disposed) {
            throw new IllegalStateException("texture is disposed");
        }
        if (!this.m_valid) {
            throw new IllegalStateException("texture not valid");
        }
        if (this.m_graphics == null) {
            throw new IllegalStateException("texture not initialized");
        }
        return this.m_graphics;
    }

    public int getTextureId() {
        if (this.m_disposed) {
            throw new IllegalStateException("texture is disposed");
        }
        return this.m_glTexture;
    }

    public void setDimensions(int i_width, int i_height) {
        if (this.m_disposed) {
            throw new IllegalStateException("texture is disposed");
        }
        if (i_width <= 0 || i_height <= 0) {
            throw new IllegalArgumentException("texture dimensions must not be negative");
        }
        this.m_valid = this.m_valid && this.m_width == i_width && this.m_height == i_height;
        this.m_width = i_width;
        this.m_height = i_height;
    }
}

