/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.testing;

import org.eclipse.amp.amf.abase.ICached;
import org.eclipse.amp.amf.abase.IInterpreterProvider;
import org.eclipse.amp.amf.abase.aBase.IntValue;
import org.eclipse.amp.amf.abase.aBase.RealValue;
import org.eclipse.amp.amf.parameters.AParInterpreter;
import org.eclipse.amp.amf.testing.aTest.Model;
import org.eclipse.amp.amf.testing.aTest.TestMember;
import org.eclipse.amp.amf.testing.aTest.Tests;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ATestInterpreter
implements ICached {
    Model atestModel;
    AParInterpreter aparInterpreter;
    private IInterpreterProvider aParCache;
    private Resource resource;

    public void load(Resource resource) {
        this.resource = resource;
        this.atestModel = (Model)resource.getContents().get(0);
    }

    public Model getModel() {
        return this.atestModel;
    }

    public AParInterpreter getAparInterpreter() {
        return this.aparInterpreter;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setCache(IInterpreterProvider cache) {
        this.aParCache = cache;
    }

    public static String convertURI(TestMember importModel) {
        return AParInterpreter.convertURI((EObject)importModel, (String)importModel.getImportURI());
    }

    public static String convertURI(Tests tests) {
        return AParInterpreter.convertURI((EObject)tests, (String)tests.getImportURI());
    }

    public static URI getParameterURI(Resource resource) {
        URI aparURI = null;
        Model model = (Model)resource.getContents().get(0);
        if (model.getTests() != null) {
            String convertURI = ATestInterpreter.convertURI(model.getTests());
            aparURI = URI.createURI((String)convertURI);
        } else {
            aparURI = resource.getURI().trimFileExtension().appendFileExtension("apar");
        }
        return aparURI;
    }

    public static double doubleValue(EObject constraintValue) {
        if (constraintValue instanceof IntValue) {
            return Integer.valueOf(((IntValue)constraintValue).getValue()).intValue();
        }
        if (constraintValue instanceof RealValue) {
            return Double.valueOf(((RealValue)constraintValue).getValue());
        }
        if (constraintValue == null) {
            return Double.NaN;
        }
        throw new RuntimeException("Unexpected value for constraint.");
    }
}

