/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.util.sweep;

import java.lang.reflect.InvocationTargetException;
import org.ascape.util.PropertyAccessor;
import org.ascape.util.sweep.Sweepable;

public class SweepDimension
extends PropertyAccessor
implements Sweepable {
    private static final long serialVersionUID = 1L;
    private TypedSweepDimension typedDimension;
    private Object[] assignValueArgs = new Object[1];

    private SweepDimension(Object object, String accessorName) {
        super(object, accessorName);
        this.propertyClass = this.descriptor.getPropertyType();
        this.object = object;
    }

    public SweepDimension(Object object, String accessorName, String start, String end, String increment) {
        this(object, accessorName);
        if (this.propertyClass == Integer.TYPE) {
            this.typedDimension = new TypedIntegerSweepDimension();
        } else if (this.propertyClass == Double.TYPE) {
            this.typedDimension = new TypedDoubleSweepDimension();
        } else if (this.propertyClass == Float.TYPE) {
            this.typedDimension = new TypedFloatSweepDimension();
        } else if (this.propertyClass == Long.TYPE) {
            this.typedDimension = new TypedLongSweepDimension();
        } else {
            throw new IllegalArgumentException("Type mismatch in creating " + accessorName + " sweep iterator.");
        }
        this.setMinAsText(start);
        this.setMaxAsText(end);
        this.setIncrementAsText(increment);
        this.typedDimension.reset();
    }

    public SweepDimension(Object object, String accessorName, int start, int end, int increment) {
        this(object, accessorName);
        if (this.propertyClass != Integer.TYPE) {
            throw new IllegalArgumentException("Type mismatch in creating " + accessorName + " sweep iterator.");
        }
        this.typedDimension = new TypedIntegerSweepDimension(start, end, increment);
        this.typedDimension.reset();
    }

    public SweepDimension(Object object, String accessorName, int start, int end) {
        this(object, accessorName, start, end, 1);
    }

    public SweepDimension(Object object, String accessorName, double start, double end, double increment) {
        this(object, accessorName);
        if (this.propertyClass != Double.TYPE) {
            throw new IllegalArgumentException("Type mismatch in creating " + accessorName + " sweep iterator.");
        }
        this.typedDimension = new TypedDoubleSweepDimension(start, end, increment);
        this.typedDimension.reset();
    }

    public SweepDimension(Object object, String accessorName, float start, float end, float increment) {
        this(object, accessorName);
        if (this.propertyClass != Float.TYPE) {
            throw new IllegalArgumentException("Type mismatch in creating " + accessorName + " sweep iterator.");
        }
        this.typedDimension = new TypedFloatSweepDimension(start, end, increment);
        this.typedDimension.reset();
    }

    public SweepDimension(Object object, String accessorName, long start, long end, long increment) {
        this(object, accessorName);
        if (this.propertyClass != Long.TYPE) {
            throw new IllegalArgumentException("Type mismatch in creating " + accessorName + " sweep iterator.");
        }
        this.typedDimension = new TypedLongSweepDimension(start, end, increment);
        this.typedDimension.reset();
    }

    private void assignValue(Object assignValue) {
        this.assignValueArgs[0] = assignValue;
        try {
            this.descriptor.getWriteMethod().invoke(this.object, this.assignValueArgs);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Exception in assign value write: " + e + ". Attempting to write " + assignValue + " to " + this.getName());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Exception in assign value write: " + e + ". Attempting to write " + assignValue + " to " + this.getName());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException("Exception (in invocation target) in assign value write: " + e.getTargetException() + ". Attempting to write " + assignValue + " to " + this.getName());
        }
    }

    public String getMinAsText() {
        return this.typedDimension.getMinAsText();
    }

    public void setMinAsText(String string) {
        this.typedDimension.setMinAsText(string);
    }

    public String getMaxAsText() {
        return this.typedDimension.getMaxAsText();
    }

    public void setMaxAsText(String string) {
        this.typedDimension.setMaxAsText(string);
    }

    public String getIncrementAsText() {
        return this.typedDimension.getIncrementAsText();
    }

    public void setIncrementAsText(String string) {
        this.typedDimension.setIncrementAsText(string);
    }

    @Override
    public void reset() {
        this.typedDimension.reset();
    }

    @Override
    public boolean hasNext() {
        return this.typedDimension.hasNext();
    }

    @Override
    public Object next() {
        Object value = this.typedDimension.next();
        this.assignValue(value);
        return value;
    }

    public class TypedDoubleSweepDimension
    extends TypedSweepDimension {
        double start;
        double end;
        double increment;
        double currentValue;

        public TypedDoubleSweepDimension() {
        }

        public TypedDoubleSweepDimension(double start, double end, double increment) {
            this.start = start;
            this.end = end;
            this.increment = increment;
        }

        @Override
        public void reset() {
            this.currentValue = this.start;
        }

        @Override
        public boolean hasNext() {
            if (this.increment > 0.0) {
                return this.currentValue <= this.end;
            }
            return this.currentValue >= this.end;
        }

        @Override
        public Object next() {
            Double nextValue = new Double(this.currentValue);
            this.currentValue += this.increment;
            return nextValue;
        }

        @Override
        public String getMinAsText() {
            return Double.toString(this.start);
        }

        @Override
        public void setMinAsText(String s) {
            this.currentValue = this.start = Double.parseDouble(s);
        }

        @Override
        public String getMaxAsText() {
            return Double.toString(this.increment);
        }

        @Override
        public void setMaxAsText(String s) {
            this.end = Double.parseDouble(s);
        }

        @Override
        public String getIncrementAsText() {
            return Double.toString(this.increment);
        }

        @Override
        public void setIncrementAsText(String s) {
            this.increment = Double.parseDouble(s);
        }
    }

    public class TypedFloatSweepDimension
    extends TypedSweepDimension {
        float start;
        float end;
        float increment;
        float currentValue;

        public TypedFloatSweepDimension() {
        }

        public TypedFloatSweepDimension(float start, float end, float increment) {
            this.start = start;
            this.end = end;
            this.increment = increment;
        }

        @Override
        public void reset() {
            this.currentValue = this.start;
        }

        @Override
        public boolean hasNext() {
            if (this.increment > 0.0f) {
                return this.currentValue <= this.end;
            }
            return this.currentValue >= this.end;
        }

        @Override
        public Object next() {
            Float nextValue = new Float(this.currentValue);
            this.currentValue += this.increment;
            return nextValue;
        }

        @Override
        public String getMinAsText() {
            return Float.toString(this.start);
        }

        @Override
        public void setMinAsText(String s) {
            this.currentValue = this.start = Float.parseFloat(s);
        }

        @Override
        public String getMaxAsText() {
            return Float.toString(this.increment);
        }

        @Override
        public void setMaxAsText(String s) {
            this.end = Float.parseFloat(s);
        }

        @Override
        public String getIncrementAsText() {
            return Float.toString(this.increment);
        }

        @Override
        public void setIncrementAsText(String s) {
            this.increment = Float.parseFloat(s);
        }
    }

    public class TypedIntegerSweepDimension
    extends TypedSweepDimension {
        int start;
        int end;
        int increment;
        int currentValue;

        public TypedIntegerSweepDimension() {
        }

        public TypedIntegerSweepDimension(int start, int end, int increment) {
            this.start = start;
            this.end = end;
            this.increment = increment;
        }

        @Override
        public void reset() {
            this.currentValue = this.start;
        }

        @Override
        public boolean hasNext() {
            if (this.increment > 0) {
                return this.currentValue <= this.end;
            }
            return this.currentValue >= this.end;
        }

        @Override
        public Object next() {
            Integer nextValue = new Integer(this.currentValue);
            this.currentValue += this.increment;
            return nextValue;
        }

        @Override
        public String getMinAsText() {
            return Integer.toString(this.start);
        }

        @Override
        public void setMinAsText(String s) {
            this.currentValue = this.start = Integer.parseInt(s);
        }

        @Override
        public String getMaxAsText() {
            return Integer.toString(this.increment);
        }

        @Override
        public void setMaxAsText(String s) {
            this.end = Integer.parseInt(s);
        }

        @Override
        public String getIncrementAsText() {
            return Integer.toString(this.increment);
        }

        @Override
        public void setIncrementAsText(String s) {
            this.increment = Integer.parseInt(s);
        }
    }

    public class TypedLongSweepDimension
    extends TypedSweepDimension {
        long start;
        long end;
        long increment;
        long currentValue;

        public TypedLongSweepDimension() {
        }

        public TypedLongSweepDimension(long start, long end, long increment) {
            this.start = start;
            this.end = end;
            this.increment = increment;
        }

        @Override
        public void reset() {
            this.currentValue = this.start;
        }

        @Override
        public boolean hasNext() {
            if (this.increment > 0L) {
                return this.currentValue <= this.end;
            }
            return this.currentValue >= this.end;
        }

        @Override
        public Object next() {
            Long nextValue = new Long(this.currentValue);
            this.currentValue += this.increment;
            return nextValue;
        }

        @Override
        public String getMinAsText() {
            return Long.toString(this.start);
        }

        @Override
        public void setMinAsText(String s) {
            this.currentValue = this.start = Long.parseLong(s);
        }

        @Override
        public String getMaxAsText() {
            return Long.toString(this.increment);
        }

        @Override
        public void setMaxAsText(String s) {
            this.end = Long.parseLong(s);
        }

        @Override
        public String getIncrementAsText() {
            return Long.toString(this.increment);
        }

        @Override
        public void setIncrementAsText(String s) {
            this.increment = Long.parseLong(s);
        }
    }

    abstract class TypedSweepDimension
    implements Sweepable {
        TypedSweepDimension() {
        }

        public abstract String getMinAsText();

        public abstract void setMinAsText(String var1);

        public abstract String getMaxAsText();

        public abstract void setMaxAsText(String var1);

        public abstract String getIncrementAsText();

        public abstract void setIncrementAsText(String var1);
    }
}

