/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import java.util.List;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.PositionBasedSurface;
import org.eclipse.draw3d.geometry.Position3D;

public class FigureSurface
extends PositionBasedSurface {
    private FigureListener m_figureListener = new FigureListener(){

        public void figureMoved(IFigure i_source) {
            FigureSurface.this.coordinateSystemChanged();
        }
    };
    private IFigure3D m_host;

    protected Position3D getPosition3D() {
        return this.m_host.getPosition3D();
    }

    public FigureSurface(IFigure3D i_host) {
        if (i_host == null) {
            throw new NullPointerException("i_host must not be null");
        }
        this.m_host = i_host;
        this.m_host.addFigureListener(this.m_figureListener);
    }

    public IFigure findFigureAt(int i_sx, int i_sy, TreeSearch i_search) {
        if (i_search != null && i_search.prune((IFigure)this.m_host)) {
            return null;
        }
        IFigure hit = null;
        ConnectionLayer connectionLayer = this.m_host.getConnectionLayer(null);
        if (connectionLayer != null && (hit = i_search != null ? connectionLayer.findFigureAt(i_sx, i_sy, i_search) : connectionLayer.findFigureAt(i_sy, i_sy)) != null && hit != connectionLayer) {
            return hit;
        }
        List children = this.m_host.getChildren();
        for (IFigure child : children) {
            if (child instanceof IFigure3D || (hit = i_search != null ? child.findFigureAt(i_sx, i_sy, i_search) : child.findFigureAt(i_sx, i_sy)) == null) continue;
            return hit;
        }
        if (i_search == null || i_search.accept((IFigure)this.m_host)) {
            return this.m_host;
        }
        return null;
    }

    public IFigure3D getHost() {
        return this.m_host;
    }

    public boolean is2DHost() {
        return true;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Figure surface for host [");
        b.append(this.m_host);
        b.append("]");
        return b.toString();
    }
}

