/*
 * generated by Xtext
 */
package org.eclipse.amp.amf.testing.scoping;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.amp.amf.parameters.AParInterpreter;
import org.eclipse.amp.amf.parameters.aPar.Model;
import org.eclipse.amp.amf.testing.ATestInterpreter;
import org.eclipse.amp.amf.testing.aTest.Constraint;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider;
import org.eclipse.xtext.scoping.impl.SimpleScope;

import org.apache.commons.lang.StringUtils;
import org.metaabm.MetaABMPackage;
import org.metaabm.SAgent;
import org.metaabm.SAttribute;
import org.metaabm.SAttributed;
import org.metaabm.SContext;
import org.metaabm.SProjection;
import org.metaabm.SState;
import org.metaabm.SStateValue;

import com.google.inject.Singleton;

/**
 * This class contains custom scoping description.
 * 
 * see : http://www.eclipse.org/Xtext/documentation/latest/xtext.html#scoping on how and when to use it
 * 
 */
@Singleton
public class ATestScopeProvider extends AbstractDeclarativeScopeProvider {

    /**
     * @param object
     * @param reference
     * @return
     * @see org.eclipse.xtext.scoping.impl.DefaultScopeProvider#getScope(org.eclipse.emf.ecore.EObject,
     *      org.eclipse.emf.ecore.EReference)
     */
    public IScope getScope(EObject object, EReference reference) {
        if (object instanceof Constraint) {
            Constraint constraint = (Constraint) object;
            List<IEObjectDescription> allElems = new ArrayList<IEObjectDescription>();
            ResourceSet resourceSet = getResourceSet(object);
            if (reference.getEType() == MetaABMPackage.eINSTANCE.getSAgent()
                    || reference.getEType() == MetaABMPackage.eINSTANCE.getSAttribute()
                    || reference.getEType() == MetaABMPackage.eINSTANCE.getSStateValue()) {

                if (reference.getEType() == MetaABMPackage.eINSTANCE.getSAgent()) {
                    for (Resource resource : resourceSet.getResources()) {
                        for (Iterator<EObject> iter = resource.getAllContents(); iter.hasNext();) {
                            EObject next = iter.next();
                            if (next instanceof SAgent) {
                                SAgent sAgent = (SAgent) next;
                                allElems.add(EObjectDescription.create(StringUtils.capitalize(sAgent.getID()),
                                                                       sAgent));
                            }
                        }
                    }
                } else if (reference.getEType() == MetaABMPackage.eINSTANCE.getSAttribute()) {
                    if (constraint.getAgent() != null) {
                        findAttributes(constraint.getAgent(), allElems);
                    } else {
                        return IScope.NULLSCOPE;
                    }
                } else if (reference.getEType() == MetaABMPackage.eINSTANCE.getSStateValue()) {
                    if (constraint.getAttribute() instanceof SState) {
                        SState state = (SState) constraint.getAttribute();
                        for (SStateValue value : state.getOptions()) {
                            allElems.add(EObjectDescription.create(StringUtils.capitalize(value.getID()), value));
                        }
                    } else {
                        return IScope.NULLSCOPE;
                    }
                }
            }
            IScope attrScope = new SimpleScope(allElems);
            return attrScope;
        }

        return super.getScope(object, reference);
    }

    protected ResourceSet getResourceSet(EObject object) {
        ResourceSet resourceSet = object.eResource().getResourceSet();
        URI aparURI = ATestInterpreter.getParameterURI(object.eResource());
        if (aparURI.isPlatform()) {
            if (URIConverter.INSTANCE.exists(aparURI, null)) {
                Resource aparAnalog = resourceSet.getResource(aparURI, true);
                if (aparAnalog != null && aparAnalog.getContents().size() > 0) {
                    Model aparModel = (Model) aparAnalog.getContents().get(0);
                    Resource agentModel = resourceSet.getResource(URI.createURI(AParInterpreter.convertURI(aparModel
                                                                                                           .getModel()), true), true);
                }
            }
        }
        return resourceSet;
    }

    protected void findAttributes(SAttributed attributed, List<IEObjectDescription> allElems) {
        for (SAttribute attr : attributed.getAttributes()) {
            // don't want to allow parameter entries that can't be changed..which is also why we don't get
            // core attributes.
            if (!attr.isImmutable()) {
                addElem(attributed, attr, allElems);
            }
        }
        if (attributed instanceof SContext) {
            for (SProjection proj : ((SContext) attributed).getProjections()) {
                findAttributes(proj, allElems);
            }
        }
    }

    private void addElem(SAttributed parent, SAttribute attr, List<IEObjectDescription> allElems) {
        String id = StringUtils.capitalize(attr.getID());
        if (parent instanceof SProjection) {
            id = StringUtils.capitalize(parent.getID() + id);
        }
        allElems.add(EObjectDescription.create(id, attr));
    }
}
