/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw3d.IFigure2DHost3D;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.ISurface;
import org.eclipse.draw3d.XYZLayout;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;

public class StackLayout3D
extends XYZLayout {
    protected float m_distance;
    protected Vector3f m_lastStackLocation;

    public StackLayout3D() {
        this(1000.0f);
    }

    public StackLayout3D(float i_distance) {
        this.m_distance = i_distance;
        this.m_lastStackLocation = new Vector3fImpl(0.0f, 0.0f, 0.0f);
    }

    public float getDistance() {
        return this.m_distance;
    }

    public void setDistance(float i_distance) {
        this.m_distance = i_distance;
    }

    public void layout(IFigure parent) {
        Point offset = this.getOrigin(parent);
        ISurface surface = null;
        if (parent instanceof IFigure2DHost3D) {
            surface = ((IFigure2DHost3D)parent).getSurface();
        }
        for (Object child : parent.getChildren()) {
            IFigure f = (IFigure)child;
            Object constraint = this.getConstraint(f);
            if (constraint == null) {
                if (!this.isChildStacked(f)) continue;
                constraint = new Vector3fImpl((IVector3f)this.m_lastStackLocation);
                this.setConstraint(f, constraint);
                this.m_lastStackLocation.translate(0.0f, 0.0f, this.m_distance);
            }
            this.layoutChild(f, constraint, offset, surface);
        }
    }

    protected boolean isChildStacked(Object i_child) {
        if (i_child instanceof IFigure3D) {
            return ((IFigure3D)i_child).getSurface() != null;
        }
        return false;
    }
}

