/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.camera.tracking;

import org.eclipse.draw3d.camera.CameraPosition;
import org.eclipse.draw3d.camera.ICameraPosition;
import org.eclipse.draw3d.camera.tracking.AbstractStartEndMove;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Math3DCache;
import org.eclipse.draw3d.geometry.Vector3f;

public class LinearRotation
extends AbstractStartEndMove {
    Vector3f upDir;
    Vector3f viewDir;

    public ICameraPosition init(ICameraPosition i_startPosition, ICameraPosition i_endPosition) {
        super.init(i_startPosition, i_endPosition);
        this.upDir = Math3D.sub((IVector3f)i_endPosition.getUpVector(), (IVector3f)i_startPosition.getUpVector(), null);
        this.viewDir = Math3D.sub((IVector3f)i_endPosition.getViewDirection(), (IVector3f)i_startPosition.getViewDirection(), null);
        return i_endPosition;
    }

    public void updateCameraPosition(CameraPosition io_cameraPosition, float i_prevTick, float i_currentTick) {
        if (i_currentTick == 1.0f) {
            io_cameraPosition.setCameraPosition(this.getEndPosition());
        } else if (i_currentTick == 0.0f) {
            io_cameraPosition.setCameraPosition(this.getStartPosition());
        } else {
            Vector3f v = Math3DCache.getVector3f();
            try {
                Math3D.scale((float)i_currentTick, (IVector3f)this.upDir, (Vector3f)v);
                Math3D.add((IVector3f)this.getStartPosition().getUpVector(), (IVector3f)v, (Vector3f)v);
                io_cameraPosition.setUpVector((IVector3f)v);
                Math3D.scale((float)i_currentTick, (IVector3f)this.viewDir, (Vector3f)v);
                Math3D.add((IVector3f)this.getStartPosition().getViewDirection(), (IVector3f)v, (Vector3f)v);
                io_cameraPosition.setViewDirection((IVector3f)v);
            }
            catch (Throwable throwable) {
                Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{v});
                throw throwable;
            }
            Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{v});
        }
    }
}

