/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.draw2d.IFigure;

public class FigureTreeDescriber {
    private static final String INDENT = "\t";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private IFigure m_rootFigure;

    public FigureTreeDescriber(IFigure i_rootFigure) {
        if (i_rootFigure == null) {
            throw new NullPointerException("i_figure must not be null");
        }
        this.m_rootFigure = i_rootFigure;
    }

    private void describeAsText(IFigure i_figure, int i_level, Printable o_printable) {
        this.indent(i_level, o_printable);
        o_printable.print(i_figure.getClass().getName());
        o_printable.print(NEW_LINE);
        List children = i_figure.getChildren();
        for (Object child : children) {
            if (!(child instanceof IFigure)) continue;
            IFigure figure = (IFigure)child;
            this.describeAsText(figure, i_level + 1, o_printable);
        }
    }

    public void describeAsText(final Logger o_log, final Level i_logLevel) {
        if (o_log == null) {
            throw new NullPointerException("o_log must not be null");
        }
        if (i_logLevel == null) {
            throw new NullPointerException("i_logLevel must not be null");
        }
        Printable printable = new Printable(){

            public void print(String i_text) {
                o_log.log(i_logLevel, i_text);
            }
        };
        this.describeAsText(this.m_rootFigure, 0, printable);
    }

    public void describeAsText(final PrintStream o_stream) {
        if (o_stream == null) {
            throw new NullPointerException("o_stream must not be null");
        }
        Printable printable = new Printable(){

            public void print(String i_text) {
                o_stream.print(i_text);
            }
        };
        this.describeAsText(this.m_rootFigure, 0, printable);
    }

    public void describeAsText(final PrintWriter o_writer) {
        if (o_writer == null) {
            throw new NullPointerException("o_writer must not be null");
        }
        Printable printable = new Printable(){

            public void print(String i_text) {
                o_writer.print(i_text);
            }
        };
        this.describeAsText(this.m_rootFigure, 0, printable);
    }

    private void indent(int i_level, Printable o_printable) {
        int i = 0;
        while (i < i_level) {
            o_printable.print(INDENT);
            ++i;
        }
    }

    private static interface Printable {
        public void print(String var1);
    }
}

