/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3d.editpolicies;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;

public abstract class AbstractDecoratorEditPolicy
extends AbstractEditPolicy {
    private EditPartListener m_listener;

    protected abstract EditPolicy[] createChildEditPolicies(EditPart var1);

    protected abstract Object getRole(EditPolicy var1);

    public void activate() {
        this.setListener(this.createChildListener());
        this.decorateChildren();
        super.activate();
    }

    public void deactivate() {
        this.setListener(null);
        super.deactivate();
    }

    protected void decorateChildren() {
        List children = this.getHost().getChildren();
        for (EditPart child : children) {
            this.decorateChild(child);
        }
    }

    protected void decorateChild(EditPart i_child) {
        EditPolicy[] policies;
        EditPolicy[] editPolicyArray = policies = this.createChildEditPolicies(i_child);
        int n = policies.length;
        int n2 = 0;
        while (n2 < n) {
            EditPolicy policy = editPolicyArray[n2];
            Object role = this.getRole(policy);
            i_child.installEditPolicy(role, policy);
            ++n2;
        }
    }

    public void setHost(EditPart i_host) {
        EditPart oldHost = i_host;
        super.setHost(i_host);
        if (oldHost != null && oldHost != this.getHost() && this.m_listener != null) {
            oldHost.removeEditPartListener(this.m_listener);
            if (this.getHost() != null) {
                this.getHost().addEditPartListener(this.m_listener);
            }
        }
    }

    protected void setListener(EditPartListener i_listener) {
        if (this.m_listener != null && this.getHost() != null) {
            this.getHost().removeEditPartListener(this.m_listener);
        }
        this.m_listener = i_listener;
        if (this.m_listener != null && this.getHost() != null) {
            this.getHost().addEditPartListener(this.m_listener);
        }
    }

    protected EditPartListener getListener() {
        return this.m_listener;
    }

    protected EditPartListener createChildListener() {
        return new EditPartListener.Stub(){

            public void childAdded(EditPart i_child, int i_index) {
                AbstractDecoratorEditPolicy.this.decorateChild(i_child);
            }
        };
    }
}

