/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf3d;

import org.eclipse.amp.agf3d.CompositeRenderShape;
import org.eclipse.amp.agf3d.IShape3DProvider;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.geometry.IPosition3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Position3D;
import org.eclipse.draw3d.geometry.Position3DUtil;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.shapes.CuboidFigureShape;
import org.eclipse.draw3d.shapes.CuboidShape;
import org.eclipse.draw3d.shapes.CylinderShape;
import org.eclipse.draw3d.shapes.CylindricFigureShape;
import org.eclipse.draw3d.shapes.PositionableShape;
import org.eclipse.draw3d.shapes.Shape;
import org.eclipse.draw3d.shapes.SphereFigureShape;

public class Shapes3D {
    private static final Vector3fImpl ORIGIN = new Vector3fImpl(0.0f, 0.0f, 0.0f);
    private static final Vector3fImpl FLAT_SIZE = new Vector3fImpl(20.0f, 20.0f, 0.0f);
    private static final Vector3fImpl NINETYPCT_SIZE = new Vector3fImpl(18.0f, 18.0f, 18.0f);
    private static final Vector3fImpl DISC_SIZE = new Vector3fImpl(18.0f, 18.0f, 4.0f);
    private static final Vector3fImpl CYLINDER_SIZE = new Vector3fImpl(18.0f, 18.0f, 16.0f);
    private static final Vector3fImpl TWENTIETH_IN = new Vector3fImpl(1.0f, 1.0f, 0.0f);
    private static final Vector3fImpl EIGHTH_IN = new Vector3fImpl(2.5f, 2.5f, 0.0f);
    private static final Vector3fImpl THREE_EIGHTS_IN = new Vector3fImpl(7.5f, 7.5099998f, 0.0f);
    private static final Vector3fImpl THREE_QUARTER_SIZE = new Vector3fImpl(15.0f, 15.0f, 15.0f);
    private static final Vector3fImpl FULL_SIZE = new Vector3fImpl(20.0f, 20.0f, 20.0f);
    private static final Vector3fImpl HALF_SIZE = new Vector3fImpl(10.0f, 10.0f, 10.0f);
    private static final Vector3fImpl QUARTER_SIZE = new Vector3fImpl(5.0f, 5.0f, 5.0f);
    public static IShape3DProvider CUBE_SHAPE_PROVIDER = new IShape3DProvider(){

        @Override
        public Shape getShape3D(Object object, IFigure3D figure) {
            return new CuboidFigureShape(figure, true);
        }

        @Override
        public IVector3f getSize3D(Object object) {
            return THREE_QUARTER_SIZE;
        }

        @Override
        public IVector3f getRelativeLocation3D(Object object) {
            return EIGHTH_IN;
        }
    };
    public static IShape3DProvider CYLINDER_SHAPE_PROVIDER = new IShape3DProvider(){

        @Override
        public Shape getShape3D(Object object, IFigure3D figure) {
            return new CylindricFigureShape(figure, 30, 1.0f, true);
        }

        @Override
        public IVector3f getSize3D(Object object) {
            return CYLINDER_SIZE;
        }

        @Override
        public IVector3f getRelativeLocation3D(Object object) {
            return TWENTIETH_IN;
        }
    };
    public static IShape3DProvider DISC_SHAPE_PROVIDER = new IShape3DProvider(){

        @Override
        public Shape getShape3D(Object object, IFigure3D figure) {
            CylindricFigureShape cylindricFigureShape = new CylindricFigureShape(figure, 30, 1.0f, true);
            cylindricFigureShape.setFill(true);
            return cylindricFigureShape;
        }

        @Override
        public IVector3f getSize3D(Object object) {
            return DISC_SIZE;
        }

        @Override
        public IVector3f getRelativeLocation3D(Object object) {
            return TWENTIETH_IN;
        }
    };
    public static IShape3DProvider SMALL_DISC_SHAPE_PROVIDER = new IShape3DProvider(){

        @Override
        public Shape getShape3D(Object object, IFigure3D figure) {
            CylindricFigureShape cylindricFigureShape = new CylindricFigureShape(figure, 30, 1.0f, true);
            cylindricFigureShape.setFill(true);
            return cylindricFigureShape;
        }

        @Override
        public IVector3f getSize3D(Object object) {
            return QUARTER_SIZE;
        }

        @Override
        public IVector3f getRelativeLocation3D(Object object) {
            return THREE_EIGHTS_IN;
        }
    };
    public static IShape3DProvider SPHERE_SHAPE_PROVIDER = new IShape3DProvider(){

        @Override
        public Shape getShape3D(Object object, IFigure3D figure) {
            return new SphereFigureShape(figure, 3);
        }

        @Override
        public IVector3f getSize3D(Object object) {
            return NINETYPCT_SIZE;
        }

        @Override
        public IVector3f getRelativeLocation3D(Object object) {
            return TWENTIETH_IN;
        }
    };
    public static IShape3DProvider TILE_SHAPE_PROVIDER = new IShape3DProvider(){

        @Override
        public Shape getShape3D(Object object, IFigure3D figure) {
            return new CuboidFigureShape(figure);
        }

        @Override
        public IVector3f getSize3D(Object object) {
            return FLAT_SIZE;
        }

        @Override
        public IVector3f getRelativeLocation3D(Object object) {
            return ORIGIN;
        }
    };
    public static IShape3DProvider HUMAN_SHAPE_PROVIDER = new IShape3DProvider(){

        @Override
        public Shape getShape3D(Object object, IFigure3D figure) {
            CompositeRenderShape shape = new CompositeRenderShape(figure, object, null);
            float scale = 1.0f;
            float bodyWidth = 0.4f * scale;
            float bodyDepth = 0.3f * scale;
            float bodyHeight = 0.4f * scale;
            float legWidth = 0.1f * scale;
            float legHeight = 0.6f * scale;
            float headWidth = 0.3f * scale;
            float headHeight = 0.2f * scale;
            shape.addShape(Shapes3D.createCylinder(legHeight, (IVector3f)new Vector3fImpl(legWidth, legWidth, legHeight), (IVector3f)new Vector3fImpl(0.5f - 1.5f * legWidth, 0.5f - 0.5f * legWidth, 0.0f)));
            shape.addShape(Shapes3D.createCylinder(legHeight, (IVector3f)new Vector3fImpl(legWidth, legWidth, legHeight), (IVector3f)new Vector3fImpl(0.5f + 0.5f * legWidth, 0.5f - 0.5f * legWidth, 0.0f)));
            shape.addShape(Shapes3D.createCube(bodyHeight + legHeight, (IVector3f)new Vector3fImpl(bodyWidth, bodyDepth, bodyHeight), (IVector3f)new Vector3fImpl((1.0f - bodyWidth) / 2.0f, (1.0f - bodyDepth) / 2.0f, legHeight)));
            shape.addShape(Shapes3D.createCylinder(headHeight, (IVector3f)new Vector3fImpl(headWidth, headWidth, headHeight), (IVector3f)new Vector3fImpl(0.5f - 0.5f * headWidth, 0.5f - 0.5f * headWidth, legHeight + bodyHeight)));
            return shape;
        }

        @Override
        public IVector3f getSize3D(Object object) {
            return FULL_SIZE;
        }

        @Override
        public IVector3f getRelativeLocation3D(Object object) {
            return ORIGIN;
        }
    };

    protected static PositionableShape createCylinder(float headHeight, IVector3f size, IVector3f location) {
        Position3D p3 = Position3DUtil.createAbsolutePosition();
        p3.setCenter3D((IVector3f)new Vector3fImpl(location.getX(), location.getY(), location.getZ()));
        p3.setSize3D(size);
        CylinderShape shape = new CylinderShape((IPosition3D)p3, 30, 1.0f, true);
        shape.setFill(true);
        shape.setOutline(true);
        return shape;
    }

    protected static PositionableShape createCube(float headHeight, IVector3f size, IVector3f location) {
        Position3D p3 = Position3DUtil.createAbsolutePosition();
        p3.setCenter3D((IVector3f)new Vector3fImpl(location.getX(), location.getY(), location.getZ()));
        p3.setSize3D(size);
        CuboidShape shape = new CuboidShape((IPosition3D)p3, true);
        shape.setFill(true);
        shape.setOutline(true);
        return shape;
    }

    public static enum ShapeType {
        CUBE,
        TILE,
        SPHERE,
        CYLINDER;

    }
}

