/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.camera;

import java.util.logging.Logger;
import org.eclipse.draw3d.camera.FirstPersonCamera;
import org.eclipse.draw3d.geometry.IMatrix4f;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Math3DCache;
import org.eclipse.draw3d.geometry.Matrix4f;
import org.eclipse.draw3d.geometry.Vector3f;

public class RestrictedFirstPersonCamera
extends FirstPersonCamera {
    private static final float HALF_PI = 1.5707964f;
    private static Logger log = Logger.getLogger(RestrictedFirstPersonCamera.class.getName());

    public void lookAt(IVector3f i_to, IVector3f i_upvector) {
        Math3D.sub((IVector3f)i_to, (IVector3f)this.m_position, (Vector3f)this.m_viewDir);
        Math3D.normalise((IVector3f)this.m_viewDir, (Vector3f)this.m_viewDir);
        Math3D.cross((IVector3f)this.m_up, (IVector3f)this.m_viewDir, (Vector3f)this.m_right);
        Math3D.normalise((IVector3f)this.m_right, (Vector3f)this.m_right);
        this.fireCameraChanged();
    }

    public void orbit(IVector3f i_center, float i_hAngle, float i_vAngle) {
        float currentPitch = 1.5707964f - Math3D.angle((IVector3f)this.m_viewDir, (IVector3f)UP_REF);
        boolean allowPitch = Math.abs(currentPitch + i_vAngle) < 1.5707964f;
        Matrix4f rot = Math3DCache.getMatrix4f();
        try {
            rot.setIdentity();
            if (i_hAngle != 0.0f) {
                Math3D.rotate((float)i_hAngle, (IVector3f)UP_REF, (IMatrix4f)rot, (Matrix4f)rot);
            }
            if (i_vAngle != 0.0f && allowPitch) {
                Math3D.rotate((float)i_vAngle, (IVector3f)this.m_right, (IMatrix4f)rot, (Matrix4f)rot);
            }
            Math3D.sub((IVector3f)this.m_position, (IVector3f)i_center, (Vector3f)this.m_position);
            this.m_position.transform((IMatrix4f)rot);
            Math3D.add((IVector3f)this.m_position, (IVector3f)i_center, (Vector3f)this.m_position);
            this.m_viewDir.transform((IMatrix4f)rot);
            Math3D.cross((IVector3f)this.m_viewDir, (IVector3f)UP_REF, (Vector3f)this.m_right);
            Math3D.normalise((IVector3f)this.m_right, (Vector3f)this.m_right);
            Math3D.cross((IVector3f)this.m_right, (IVector3f)this.m_viewDir, (Vector3f)this.m_up);
            Math3D.normalise((IVector3f)this.m_up, (Vector3f)this.m_up);
            this.fireCameraChanged();
        }
        catch (Throwable throwable) {
            Math3DCache.returnMatrix4f((Matrix4f[])new Matrix4f[]{rot});
            throw throwable;
        }
        Math3DCache.returnMatrix4f((Matrix4f[])new Matrix4f[]{rot});
    }

    public void rotate(float i_roll, float i_pitch, float i_yaw) {
        Matrix4f rot = Math3DCache.getMatrix4f();
        try {
            boolean allowPitch;
            rot.setIdentity();
            float currentPitch = 1.5707964f - Math3D.angle((IVector3f)this.m_viewDir, (IVector3f)UP_REF);
            boolean bl = allowPitch = Math.abs(currentPitch + i_pitch) < 1.5707964f;
            if (i_pitch != 0.0f && allowPitch) {
                Math3D.rotate((float)i_pitch, (IVector3f)this.m_right, (IMatrix4f)rot, (Matrix4f)rot);
            }
            if (i_yaw != 0.0f) {
                Math3D.rotate((float)i_yaw, (IVector3f)UP_REF, (IMatrix4f)rot, (Matrix4f)rot);
            }
            this.m_viewDir.transform((IMatrix4f)rot);
            Math3D.cross((IVector3f)this.m_viewDir, (IVector3f)UP_REF, (Vector3f)this.m_right);
            Math3D.normalise((IVector3f)this.m_right, (Vector3f)this.m_right);
            Math3D.cross((IVector3f)this.m_right, (IVector3f)this.m_viewDir, (Vector3f)this.m_up);
            Math3D.normalise((IVector3f)this.m_up, (Vector3f)this.m_up);
            this.fireCameraChanged();
        }
        catch (Throwable throwable) {
            Math3DCache.returnMatrix4f((Matrix4f[])new Matrix4f[]{rot});
            throw throwable;
        }
        Math3DCache.returnMatrix4f((Matrix4f[])new Matrix4f[]{rot});
    }
}

