/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import junit.textui.TestRunner;
import org.metaabm.IID;
import org.metaabm.MetaABMFactory;
import org.metaabm.SAgent;
import org.metaabm.SContext;
import org.metaabm.tests.SAgentTest;

public class SContextTest
extends SAgentTest {
    public static void main(String[] args) {
        TestRunner.run(SContextTest.class);
    }

    public SContextTest(String name) {
        super(name);
    }

    protected SContext getFixture() {
        return (SContext)this.fixture;
    }

    @Override
    protected void setUp() throws Exception {
        this.setFixture((IID)MetaABMFactory.eINSTANCE.createSContext());
        super.setUp();
    }

    public void testGetContext() {
        SContext ctxA1 = MetaABMFactory.eINSTANCE.createSContext();
        ctxA1.setLabel("ctxA1");
        SContext ctxB1 = MetaABMFactory.eINSTANCE.createSContext();
        ctxB1.setLabel("ctxB1");
        SContext ctxB2 = MetaABMFactory.eINSTANCE.createSContext();
        ctxB2.setLabel("ctxB2");
        SContext ctxC1 = MetaABMFactory.eINSTANCE.createSContext();
        ctxC1.setLabel("ctxC1");
        SAgent agtB1 = MetaABMFactory.eINSTANCE.createSAgent();
        agtB1.setLabel("agtB1");
        SAgent agtB2 = MetaABMFactory.eINSTANCE.createSAgent();
        agtB2.setLabel("agtB2");
        SAgent agtC1 = MetaABMFactory.eINSTANCE.createSAgent();
        agtC1.setLabel("agtC1");
        SAgent agtC2 = MetaABMFactory.eINSTANCE.createSAgent();
        agtC2.setLabel("agtC2");
        ctxA1.getAgents().add((Object)ctxB1);
        ctxA1.getAgents().add((Object)ctxB2);
        ctxA1.getAgents().add((Object)agtB1);
        ctxA1.getAgents().add((Object)agtB2);
        ctxB1.getAgents().add((Object)ctxC1);
        ctxB1.getAgents().add((Object)agtC1);
        ctxB1.getAgents().add((Object)agtC2);
        this.helpContains((Collection)ctxA1.getAgents(), new SAgent[]{agtB2, ctxB1, ctxB2, agtB1});
        this.helpContains((Collection)ctxB1.getAgents(), new SAgent[]{agtC1, agtC2, ctxC1});
        this.helpContains(ctxA1.getSubContexts(), new SAgent[]{ctxB1, ctxB2});
        this.helpContains(ctxB1.getSubContexts(), new SAgent[]{ctxC1});
        this.helpContains((Collection)ctxA1.getAllAgents(), new SAgent[]{ctxA1, agtB1, agtB2, ctxB1, ctxB2, ctxC1, agtC1, agtC2});
        this.helpContains(ctxA1.getAllSubAgents(), new SAgent[]{agtB1, agtB2, ctxB1, ctxB2, ctxC1, agtC1, agtC2});
        this.helpContains((Collection)ctxA1.getAllContexts(), new SAgent[]{ctxA1, ctxB1, ctxB2, ctxC1});
        this.helpContains((Collection)ctxA1.getAllContexts(), new SAgent[]{ctxA1, ctxB1, ctxB2, ctxC1});
    }

    private void helpContains(Collection parent, SAgent ... agents) {
        ArrayList<SAgent> expAgents = new ArrayList<SAgent>(Arrays.asList(agents));
        for (Object a : parent) {
            SContextTest.assertTrue((String)("Shouldn't Exclude: " + a + "   in:" + parent), (boolean)expAgents.remove(a));
        }
        SContextTest.assertTrue((String)("Shouldn't Include: " + expAgents), (boolean)expAgents.isEmpty());
    }

    @Override
    protected void tearDown() throws Exception {
        this.setFixture(null);
    }
}

