/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import java.util.EventObject;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw3d.ISurface;
import org.eclipse.draw3d.camera.ICamera;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.util.Draw3DCache;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class MouseEvent3D
extends MouseEvent {
    private static final Event DUMMY = new Event();
    private static final long serialVersionUID = -7581719169381368361L;
    protected Point screenLocation;
    protected Vector3f worldLocation;
    protected ICamera camera;
    protected ISurface surface;

    private static Event getEvent(Object i_object) {
        if (i_object instanceof Event) {
            return (Event)i_object;
        }
        EventObject eventObject = (EventObject)i_object;
        MouseEvent3D.DUMMY.widget = (Widget)eventObject.getSource();
        return DUMMY;
    }

    public MouseEvent3D(MouseEvent i_me, ISurface surface, ICamera camera) {
        super(MouseEvent3D.getEvent(i_me));
        this.surface = surface;
        this.camera = camera;
        this.screenLocation = new Point(i_me.x, i_me.y);
        this.worldLocation = new Vector3fImpl();
        Point surfaceLocation = Draw3DCache.getPoint();
        try {
            MouseEvent3D.screenToWorld(camera, surface, this.getScreenLocation(), surfaceLocation, this.worldLocation);
            this.x = surfaceLocation.x;
            this.y = surfaceLocation.y;
        }
        catch (Throwable throwable) {
            Draw3DCache.returnPoint(surfaceLocation);
            throw throwable;
        }
        Draw3DCache.returnPoint(surfaceLocation);
        this.button = i_me.button;
        this.stateMask = i_me.stateMask;
        this.count = i_me.count;
        this.display = i_me.display;
        this.widget = i_me.widget;
        this.time = i_me.time;
        this.data = i_me.data;
        this.source = i_me.widget;
    }

    public ICamera getCamera() {
        return this.camera;
    }

    public ISurface getSurface() {
        return this.surface;
    }

    public Point getScreenLocation() {
        return this.screenLocation;
    }

    public IVector3f getWorldLocation() {
        return this.worldLocation;
    }

    public Vector3f computeWorldLocation(Point screenLocation, ISurface surface) {
        return MouseEvent3D.screenToWorld(this.camera, surface == null ? this.getSurface() : surface, screenLocation, null, null);
    }

    public static Vector3f screenToWorld(ICamera camera, ISurface surface, Point i_screenLocation, Point o_surfaceLocation, Vector3f o_result) {
        Vector3f vector3f;
        Vector3f eye = Draw3DCache.getVector3f();
        Vector3f direction = Draw3DCache.getVector3f();
        Vector3f pointVector = Draw3DCache.getVector3f();
        Point sLocation = o_surfaceLocation == null ? Draw3DCache.getPoint() : o_surfaceLocation;
        try {
            camera.getPosition(eye);
            camera.unProject(i_screenLocation.x, i_screenLocation.y, 0.0f, null, pointVector);
            Math3D.getRayDirection((IVector3f)eye, (IVector3f)pointVector, (Vector3f)direction);
            surface.getSurfaceLocation2D((IVector3f)eye, (IVector3f)direction, sLocation);
            vector3f = surface.getWorldLocation(sLocation, o_result);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{eye, pointVector, direction});
            if (o_surfaceLocation == null) {
                Draw3DCache.returnPoint(sLocation);
            }
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{eye, pointVector, direction});
        if (o_surfaceLocation == null) {
            Draw3DCache.returnPoint(sLocation);
        }
        return vector3f;
    }
}

