/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model;

import java.util.List;
import org.ascape.model.Agent;
import org.ascape.model.Cell;
import org.ascape.model.HostCell;
import org.ascape.model.LocatedAgent;
import org.ascape.model.Scape;
import org.ascape.model.rule.Rule;
import org.ascape.model.space.Coordinate;
import org.ascape.model.space.Discrete;
import org.ascape.model.space.Node;
import org.ascape.util.Conditional;

public class CellOccupant
extends Cell {
    private static final long serialVersionUID = 1L;
    public static final Rule PLAY_HOST_RULE = new Rule("Play Host"){
        private static final long serialVersionUID = 1L;

        @Override
        public void execute(Agent agent) {
            HostCell host = ((CellOccupant)agent).getHostCell();
            agent.play(host);
        }

        @Override
        public boolean isRandomExecution() {
            return true;
        }

        @Override
        public boolean isCauseRemoval() {
            return false;
        }
    };
    public static final Rule RANDOM_WALK_AVAILABLE_RULE = new Rule("Random Walk Available"){
        private static final long serialVersionUID = 1L;

        @Override
        public void execute(Agent agent) {
            ((CellOccupant)agent).randomWalkAvailable();
        }

        @Override
        public boolean isCauseRemoval() {
            return false;
        }
    };
    private Scape hostScape;
    private HostCell hostCell;

    public void leave() {
        if (this.hostCell != null) {
            this.hostCell.removeOccupant();
        }
        this.hostCell = null;
        this.coordinate = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void moveTo(HostCell hostCell) {
        if (hostCell == null) throw new RuntimeException("HostCell cannot be set null.");
        if (!hostCell.isAvailable()) throw new RuntimeException("HostCell not available: " + hostCell);
        if (this.hostCell != null) {
            this.hostCell.removeOccupant();
        }
        this.hostCell = hostCell;
        hostCell.setOccupant(this);
        this.coordinate = hostCell.getCoordinate();
    }

    @Override
    public void moveToward(LocatedAgent targetCell) {
        HostCell dCell = (HostCell)((Discrete)this.getHostScape().getSpace()).findCellToward(this.getHostCell(), (HostCell)targetCell);
        if (dCell.isAvailable()) {
            this.moveTo(dCell);
        }
    }

    @Override
    public void moveAway(LocatedAgent targetCell) {
        HostCell dCell = (HostCell)((Discrete)this.getHostScape().getSpace()).findCellAway(this.getHostCell(), (HostCell)targetCell);
        if (dCell.isAvailable()) {
            this.moveTo(dCell);
        }
    }

    @Override
    public Coordinate getCoordinate() {
        if (this.hostCell != null) {
            return this.hostCell.getCoordinate();
        }
        return super.getCoordinate();
    }

    @Override
    public void moveToRandomLocation() {
        HostCell cell = (HostCell)((Discrete)this.getHostScape().getSpace()).findRandomUnoccupiedCell();
        if (cell != null) {
            this.moveTo(cell);
        } else {
            System.out.println("Warning: no location to move to. Killing agent.");
            this.die();
        }
    }

    @Override
    public void die() {
        this.leave();
        if (!this.scape.remove(this)) {
            throw new RuntimeException("Agent Couldn't be deleted");
        }
    }

    public HostCell getHostCell() {
        return this.hostCell;
    }

    public void setHostCell(HostCell hostCell) {
        this.hostCell = hostCell;
    }

    public Scape getHostScape() {
        return this.hostScape;
    }

    public void setHostScape(Scape hostScape) {
        this.hostScape = hostScape;
    }

    public Cell findRandomNeighborOnHost() {
        List nh = this.findNeighborsOnHost();
        if (nh.size() > 0) {
            return (Cell)nh.get(this.randomToLimit(nh.size()));
        }
        return null;
    }

    @Override
    public Node findRandomAvailableNeighbor() {
        return this.getHostCell().findRandomAvailableNeighbor();
    }

    @Override
    public Node findRandomNeighbor() {
        return this.findRandomNeighborOnHost();
    }

    @Override
    public List findNeighbors() {
        return this.findNeighborsOnHost();
    }

    public List findNeighborsOnHost() {
        return this.hostCell.findNeighboringOccupants();
    }

    @Override
    public List findWithin(Conditional condition, double distance) {
        return this.findWithin(condition, false, distance);
    }

    @Override
    public List findWithin(double distance) {
        return this.findWithin(null, false, distance);
    }

    @Override
    public List findWithin(Conditional condition, boolean includeSelf, double distance) {
        Conditional hostedCondition = CellOccupant.hostedCondition(condition);
        return CellOccupant.findOccupants(this.getHostCell().findWithin(hostedCondition, includeSelf, distance));
    }

    @Override
    public LocatedAgent findNearest() {
        return this.findNearest(null, false, Double.MAX_VALUE);
    }

    @Override
    public LocatedAgent findNearest(double distance) {
        return this.findNearest(null, false, distance);
    }

    @Override
    public LocatedAgent findNearest(Conditional condition) {
        return this.findNearest(condition, false, Double.MAX_VALUE);
    }

    @Override
    public LocatedAgent findNearest(Conditional condition, double distance) {
        return this.findNearest(condition, false, distance);
    }

    @Override
    public LocatedAgent findNearest(Conditional condition, boolean includeSelf, double distance) {
        Conditional hostedCondition = CellOccupant.hostedCondition(condition);
        LocatedAgent nearest = this.getHostCell().findNearest(hostedCondition, includeSelf, distance);
        if (nearest != null) {
            return (LocatedAgent)((Object)((HostCell)nearest).getOccupant());
        }
        return null;
    }

    public List findAvailableNeighbors() {
        return this.hostCell.findAvailableNeighbors();
    }

    @Override
    public void playRandomNeighbor() {
        Cell n = this.findRandomNeighborOnHost();
        if (n != null) {
            this.play(n);
        }
    }

    @Override
    public void playNeighbors() {
        List neighbors = this.findNeighborsOnHost();
        for (Agent neighbor : neighbors) {
            this.play(neighbor);
        }
    }

    @Override
    public void randomWalk() {
        if (this.getHostCell() != null) {
            Cell candidate = (Cell)this.getHostCell().findRandomNeighbor();
            if (candidate.isAvailable()) {
                this.moveTo((HostCell)candidate);
            }
        } else {
            throw new RuntimeException("Called Random Walk on Agent (" + this + ") that has no current location.");
        }
    }

    public void randomWalkAvailable() {
        HostCell candidate;
        if (this.getHostCell() != null && (candidate = this.getHostCell().findRandomAvailableNeighbor()) != null) {
            this.moveTo(candidate);
        }
    }

    @Override
    public Object clone() {
        CellOccupant clone = (CellOccupant)super.clone();
        clone.hostCell = null;
        return clone;
    }
}

