/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometry;

import java.util.Comparator;
import org.eclipse.draw3d.geometry.Math3D;

public class Math2D {
    private static void checkPoints(int[] i_p, String i_name) {
        if (i_p == null) {
            throw new NullPointerException(String.valueOf(i_name) + " must not be null");
        }
        if (i_p.length % 2 != 0) {
            throw new IllegalArgumentException(String.valueOf(i_name) + " must contain an even number of coordinates");
        }
        if (i_p.length < 2) {
            throw new IllegalArgumentException(String.valueOf(i_name) + " must contain at least one point");
        }
    }

    private static void checkPolygon(int[] i_p, String i_name) {
        if (i_p == null) {
            throw new NullPointerException(String.valueOf(i_name) + " must not be null");
        }
        if (i_p.length % 2 != 0) {
            throw new IllegalArgumentException(String.valueOf(i_name) + " must contain an even number of coordinates");
        }
        if (i_p.length < 6) {
            throw new IllegalArgumentException(String.valueOf(i_name) + " must contain at least three vertices");
        }
    }

    public static int[] getSortedIndices(int[] points) {
        Math2D.checkPoints(points, "points");
        int n = points.length / 2;
        if (n > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("array contains too many points");
        }
        int[] sorted = new int[n];
        int i = 0;
        while (i < n) {
            sorted[i] = i;
            ++i;
        }
        Math2D.quicksort(sorted, points, 0, n - 1);
        return sorted;
    }

    private static boolean hasSeparator(int[] i_p0, int[] i_p1) {
        int n0 = i_p0.length / 2;
        int i0 = 0;
        int i1 = n0 - 1;
        while (i0 < n0) {
            int locx = i_p0[2 * i0];
            int locy = i_p0[2 * i0 + 1];
            int dirx = -(locy - i_p0[2 * i1 + 1]);
            int diry = locx - i_p0[2 * i1];
            if (Math2D.whichSide(i_p1, locx, locy, dirx, diry) > 0) {
                return true;
            }
            i1 = i0++;
        }
        return false;
    }

    public static int pointsInPolygon(int[] polygon, int[] points, int max) {
        return Math2D.sortedPointsInPolygon(polygon, points, Math2D.getSortedIndices(points), max);
    }

    /*
     * Unable to fully structure code
     */
    public static int sortedPointsInPolygon(int[] polygon, int[] points, int[] sorted, int max) {
        Math2D.checkPolygon(polygon, "polygon");
        Math2D.checkPoints(points, "points");
        numVertices = polygon.length / 2;
        numPoints = points.length / 2;
        l = 0;
        r = 0;
        i = 1;
        while (i < numVertices) {
            if (polygon[2 * i] < polygon[2 * l]) {
                l = i;
            }
            if (polygon[2 * i] > polygon[2 * r]) {
                r = i;
            }
            ++i;
        }
        pIdx = 0;
        px = points[2 * sorted[pIdx]];
        while (pIdx < numPoints && px < polygon[2 * l]) {
            px = points[2 * sorted[pIdx++]];
        }
        if (pIdx >= numPoints) {
            return 0;
        }
        us = l;
        ue = Math2D.wrapIndex(us, numVertices, true);
        ls = l;
        le = Math2D.wrapIndex(ls, numVertices, false);
        num = 0;
        py = points[2 * sorted[pIdx] + 1];
        ** GOTO lbl60
        {
            us = ue;
            ue = Math2D.wrapIndex(us, numVertices, true);
            do {
                if (px >= polygon[2 * ue]) continue block2;
                while (px >= polygon[le]) {
                    ls = le;
                    le = Math2D.wrapIndex(ls, numVertices, false);
                }
                usx = polygon[2 * us];
                usy = polygon[2 * us + 1];
                uex = polygon[2 * ue];
                uey = polygon[2 * ue + 1];
                lsx = polygon[2 * ls];
                lsy = polygon[2 * ls + 1];
                lex = polygon[2 * le];
                ley = polygon[2 * le + 1];
                if (py <= Math.max(usy, uey) && py >= Math.min(lsy, ley)) {
                    ldy = ley - lsy;
                    ldx = lex - lsx;
                    lg = (float)ldy / (float)ldx;
                    ly = lg * (float)(px - lsx);
                    udy = uey - usy;
                    udx = uex - usx;
                    ug = (float)udy / (float)udx;
                    uy = ug * (float)(px - usx);
                    if (Math3D.in(ly, uy, px)) {
                        ++num;
                    }
                    if (num >= max) {
                        return num;
                    }
                }
                px = points[2 * sorted[++pIdx]];
                py = points[2 * sorted[pIdx] + 1];
lbl60:
                // 2 sources

            } while (pIdx < numPoints && px < polygon[2 * r]);
        }
        return num;
    }

    public static boolean polygonIntersectsPolygon(int[] i_p0, int[] i_p1) {
        Math2D.checkPolygon(i_p0, "i_p0");
        Math2D.checkPolygon(i_p1, "i_p1");
        if (Math2D.hasSeparator(i_p0, i_p1)) {
            return false;
        }
        return !Math2D.hasSeparator(i_p1, i_p0);
    }

    /*
     * Unable to fully structure code
     */
    private static void quicksort(int[] indices, int[] points, int low, int high) {
        i = low;
        j = high;
        x = points[2 * indices[low + high >>> 1]];
        ** GOTO lbl17
        {
            ++i;
            do {
                if (points[2 * indices[i]] < x) continue block0;
                while (points[2 * indices[j]] > x) {
                    --j;
                }
                if (i > j) continue;
                t = indices[i];
                indices[i] = indices[j];
                indices[j] = t;
                ++i;
                --j;
lbl17:
                // 3 sources

            } while (i <= j);
        }
        if (low < j) {
            Math2D.quicksort(indices, points, low, j);
        }
        if (i < high) {
            Math2D.quicksort(indices, points, i, high);
        }
    }

    private static int whichSide(int[] polygon, int locx, int locy, int dirx, int diry) {
        int n = polygon.length / 2;
        int pos = 0;
        int neg = 0;
        int i = 0;
        while (i < n) {
            int t = locx * dirx + locy * diry;
            if (t > 0) {
                ++pos;
            } else if (t < 0) {
                ++neg;
            }
            if (pos > 0 && neg > 0) {
                return 0;
            }
            ++i;
        }
        if (pos > 0) {
            return 1;
        }
        return -1;
    }

    private static int wrapIndex(int index, int length, boolean direction) {
        if (direction) {
            if (index == length - 1) {
                return 0;
            }
            return index + 1;
        }
        if (index == 0) {
            return length - 1;
        }
        return index - 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VertexComparator
    implements Comparator<Integer> {
        private int[] m_vertices;

        public VertexComparator(int[] i_vertices) {
            this.m_vertices = i_vertices;
        }

        @Override
        public int compare(Integer index1, Integer index2) {
            int x1 = this.m_vertices[2 * index1];
            int x2 = this.m_vertices[2 * index2];
            return x1 - x2;
        }
    }
}

