/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometry;

import java.io.Serializable;
import java.nio.FloatBuffer;
import java.util.Arrays;
import org.eclipse.draw3d.geometry.IMatrix3f;
import org.eclipse.draw3d.geometry.Matrix3f;

public class Matrix3fImpl
implements Matrix3f,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public float a11;
    public float a12;
    public float a13;
    public float a21;
    public float a22;
    public float a23;
    public float a31;
    public float a32;
    public float a33;

    static Matrix3fImpl cast(IMatrix3f i_sourceMatrix3f) {
        if (i_sourceMatrix3f instanceof Matrix3fImpl) {
            return (Matrix3fImpl)i_sourceMatrix3f;
        }
        return new Matrix3fImpl(i_sourceMatrix3f);
    }

    public Matrix3fImpl() {
        this.a11 = 1.0f;
        this.a22 = 1.0f;
        this.a33 = 1.0f;
    }

    public Matrix3fImpl(float[] i_floats, boolean i_bColumnMajor) {
        if (!i_bColumnMajor) {
            this.a11 = i_floats[0];
            this.a12 = i_floats[1];
            this.a13 = i_floats[2];
            this.a21 = i_floats[3];
            this.a22 = i_floats[4];
            this.a23 = i_floats[5];
            this.a31 = i_floats[6];
            this.a32 = i_floats[7];
            this.a33 = i_floats[8];
        } else {
            this.a11 = i_floats[0];
            this.a21 = i_floats[1];
            this.a31 = i_floats[2];
            this.a12 = i_floats[3];
            this.a22 = i_floats[4];
            this.a32 = i_floats[5];
            this.a13 = i_floats[6];
            this.a23 = i_floats[7];
            this.a33 = i_floats[8];
        }
    }

    public Matrix3fImpl(float[] i_floats, boolean i_bColumnMajor, int i_iOffset) {
        if (!i_bColumnMajor) {
            this.a11 = i_floats[i_iOffset++];
            this.a12 = i_floats[i_iOffset++];
            this.a13 = i_floats[i_iOffset++];
            this.a21 = i_floats[i_iOffset++];
            this.a22 = i_floats[i_iOffset++];
            this.a23 = i_floats[i_iOffset++];
            this.a31 = i_floats[i_iOffset++];
            this.a32 = i_floats[i_iOffset++];
            this.a33 = i_floats[i_iOffset];
        } else {
            this.a11 = i_floats[i_iOffset++];
            this.a21 = i_floats[i_iOffset++];
            this.a31 = i_floats[i_iOffset++];
            this.a12 = i_floats[i_iOffset++];
            this.a22 = i_floats[i_iOffset++];
            this.a32 = i_floats[i_iOffset++];
            this.a13 = i_floats[i_iOffset++];
            this.a23 = i_floats[i_iOffset++];
            this.a33 = i_floats[i_iOffset];
        }
    }

    public Matrix3fImpl(FloatBuffer i_buffer, boolean i_bColumnMajor) {
        if (!i_bColumnMajor) {
            this.setRowMajor(i_buffer);
        } else {
            this.setColumnMajor(i_buffer);
        }
    }

    public Matrix3fImpl(IMatrix3f src) {
        if (src instanceof Matrix3fImpl) {
            Matrix3fImpl sm = (Matrix3fImpl)src;
            this.a11 = sm.a11;
            this.a12 = sm.a12;
            this.a13 = sm.a13;
            this.a21 = sm.a21;
            this.a22 = sm.a22;
            this.a23 = sm.a23;
            this.a31 = sm.a31;
            this.a32 = sm.a32;
            this.a33 = sm.a33;
        } else {
            float[] af = new float[9];
            src.toArrayRowMajor(af);
            this.setRowMajor(af);
        }
    }

    public Matrix3fImpl(float a11, float a12, float a13, float a21, float a22, float a23, float a31, float a32, float a33) {
        this.a11 = a11;
        this.a12 = a12;
        this.a13 = a13;
        this.a21 = a21;
        this.a22 = a22;
        this.a23 = a23;
        this.a31 = a31;
        this.a32 = a32;
        this.a33 = a33;
    }

    public Object clone() throws CloneNotSupportedException {
        return new Matrix3fImpl(this);
    }

    public boolean equals(IMatrix3f i_anotherMatrix3f) {
        if (this == i_anotherMatrix3f) {
            return true;
        }
        if (i_anotherMatrix3f == null) {
            return false;
        }
        Matrix3fImpl sm = Matrix3fImpl.cast(i_anotherMatrix3f);
        return this.a11 == sm.a11 && this.a12 == sm.a12 && this.a13 == sm.a13 && this.a21 == sm.a21 && this.a22 == sm.a22 && this.a23 == sm.a23 && this.a31 == sm.a31 && this.a32 == sm.a32 && this.a33 == sm.a33;
    }

    public float get(int i_row, int i_column) {
        if (i_row < 0 || i_row >= 3) {
            throw new IllegalArgumentException("row index out of bounds: " + i_row);
        }
        if (i_column < 0 || i_column >= 3) {
            throw new IllegalArgumentException("column index out of bounds: " + i_column);
        }
        if (i_row == 0) {
            if (i_column == 0) {
                return this.a11;
            }
            if (i_column == 1) {
                return this.a12;
            }
            return this.a13;
        }
        if (i_row == 1) {
            if (i_column == 0) {
                return this.a21;
            }
            if (i_column == 1) {
                return this.a22;
            }
            return this.a23;
        }
        if (i_column == 0) {
            return this.a31;
        }
        if (i_column == 1) {
            return this.a32;
        }
        return this.a33;
    }

    public int hashCode() {
        float[] af = new float[9];
        this.toArrayRowMajor(af);
        return Arrays.hashCode(af);
    }

    public void set(IMatrix3f i_sourceMatrix3f) {
        Matrix3fImpl sm = Matrix3fImpl.cast(i_sourceMatrix3f);
        this.a11 = sm.a11;
        this.a12 = sm.a12;
        this.a13 = sm.a13;
        this.a21 = sm.a21;
        this.a22 = sm.a22;
        this.a23 = sm.a23;
        this.a31 = sm.a31;
        this.a32 = sm.a32;
        this.a33 = sm.a33;
    }

    public void set(int i_row, int i_column, float i_value) {
        if (i_row < 0 || i_row >= 3) {
            throw new IllegalArgumentException("row index out of bounds: " + i_row);
        }
        if (i_column < 0 || i_column >= 3) {
            throw new IllegalArgumentException("column index out of bounds: " + i_column);
        }
        if (i_row == 0) {
            if (i_column == 0) {
                this.a11 = i_value;
            } else if (i_column == 1) {
                this.a12 = i_value;
            } else {
                this.a13 = i_value;
            }
        } else if (i_row == 1) {
            if (i_column == 0) {
                this.a21 = i_value;
            } else if (i_column == 1) {
                this.a22 = i_value;
            } else {
                this.a23 = i_value;
            }
        } else if (i_column == 0) {
            this.a31 = i_value;
        } else if (i_column == 1) {
            this.a32 = i_value;
        } else {
            this.a33 = i_value;
        }
    }

    public void setColumnMajor(float[] i_arrayOfFloat) {
        this.a11 = i_arrayOfFloat[0];
        this.a21 = i_arrayOfFloat[1];
        this.a31 = i_arrayOfFloat[2];
        this.a12 = i_arrayOfFloat[3];
        this.a22 = i_arrayOfFloat[4];
        this.a32 = i_arrayOfFloat[5];
        this.a13 = i_arrayOfFloat[6];
        this.a23 = i_arrayOfFloat[7];
        this.a33 = i_arrayOfFloat[8];
    }

    public void setColumnMajor(FloatBuffer i_floatBuffer) {
        this.a11 = i_floatBuffer.get();
        this.a21 = i_floatBuffer.get();
        this.a31 = i_floatBuffer.get();
        this.a12 = i_floatBuffer.get();
        this.a22 = i_floatBuffer.get();
        this.a32 = i_floatBuffer.get();
        this.a13 = i_floatBuffer.get();
        this.a23 = i_floatBuffer.get();
        this.a33 = i_floatBuffer.get();
    }

    public void setIdentity() {
        this.a11 = 1.0f;
        this.a12 = 0.0f;
        this.a13 = 0.0f;
        this.a21 = 0.0f;
        this.a22 = 1.0f;
        this.a23 = 0.0f;
        this.a31 = 0.0f;
        this.a32 = 0.0f;
        this.a33 = 1.0f;
    }

    public void setRowMajor(float[] i_arrayOfFloat) {
        this.a11 = i_arrayOfFloat[0];
        this.a12 = i_arrayOfFloat[1];
        this.a13 = i_arrayOfFloat[2];
        this.a21 = i_arrayOfFloat[3];
        this.a22 = i_arrayOfFloat[4];
        this.a23 = i_arrayOfFloat[5];
        this.a31 = i_arrayOfFloat[6];
        this.a32 = i_arrayOfFloat[7];
        this.a33 = i_arrayOfFloat[8];
    }

    public void setRowMajor(FloatBuffer i_floatBuffer) {
        this.a11 = i_floatBuffer.get();
        this.a12 = i_floatBuffer.get();
        this.a13 = i_floatBuffer.get();
        this.a21 = i_floatBuffer.get();
        this.a22 = i_floatBuffer.get();
        this.a23 = i_floatBuffer.get();
        this.a31 = i_floatBuffer.get();
        this.a32 = i_floatBuffer.get();
        this.a33 = i_floatBuffer.get();
    }

    public void setZero() {
        this.a11 = 0.0f;
        this.a12 = 0.0f;
        this.a13 = 0.0f;
        this.a21 = 0.0f;
        this.a22 = 0.0f;
        this.a23 = 0.0f;
        this.a31 = 0.0f;
        this.a32 = 0.0f;
        this.a33 = 0.0f;
    }

    public int size() {
        return 9;
    }

    public void toArrayColumnMajor(float[] o_arrayOfFloat) {
        o_arrayOfFloat[0] = this.a11;
        o_arrayOfFloat[1] = this.a21;
        o_arrayOfFloat[2] = this.a31;
        o_arrayOfFloat[3] = this.a12;
        o_arrayOfFloat[4] = this.a22;
        o_arrayOfFloat[5] = this.a32;
        o_arrayOfFloat[6] = this.a13;
        o_arrayOfFloat[7] = this.a23;
        o_arrayOfFloat[8] = this.a33;
    }

    public void toArrayColumnMajor(float[] o_arrayOfFloat, int i_iOffset) {
        o_arrayOfFloat[i_iOffset++] = this.a11;
        o_arrayOfFloat[i_iOffset++] = this.a21;
        o_arrayOfFloat[i_iOffset++] = this.a31;
        o_arrayOfFloat[i_iOffset++] = this.a12;
        o_arrayOfFloat[i_iOffset++] = this.a22;
        o_arrayOfFloat[i_iOffset++] = this.a32;
        o_arrayOfFloat[i_iOffset++] = this.a13;
        o_arrayOfFloat[i_iOffset++] = this.a23;
        o_arrayOfFloat[i_iOffset] = this.a33;
    }

    public void toArrayRowMajor(float[] o_arrayOfFloat) {
        o_arrayOfFloat[0] = this.a11;
        o_arrayOfFloat[1] = this.a12;
        o_arrayOfFloat[2] = this.a13;
        o_arrayOfFloat[3] = this.a21;
        o_arrayOfFloat[4] = this.a22;
        o_arrayOfFloat[5] = this.a23;
        o_arrayOfFloat[6] = this.a31;
        o_arrayOfFloat[7] = this.a32;
        o_arrayOfFloat[8] = this.a33;
    }

    public void toArrayRowMajor(float[] o_arrayOfFloat, int i_iOffset) {
        o_arrayOfFloat[i_iOffset++] = this.a11;
        o_arrayOfFloat[i_iOffset++] = this.a12;
        o_arrayOfFloat[i_iOffset++] = this.a13;
        o_arrayOfFloat[i_iOffset++] = this.a21;
        o_arrayOfFloat[i_iOffset++] = this.a22;
        o_arrayOfFloat[i_iOffset++] = this.a23;
        o_arrayOfFloat[i_iOffset++] = this.a31;
        o_arrayOfFloat[i_iOffset++] = this.a32;
        o_arrayOfFloat[i_iOffset] = this.a33;
    }

    public void toBufferColumnMajor(FloatBuffer o_buffer) {
        o_buffer.put(this.a11);
        o_buffer.put(this.a21);
        o_buffer.put(this.a31);
        o_buffer.put(this.a12);
        o_buffer.put(this.a22);
        o_buffer.put(this.a32);
        o_buffer.put(this.a13);
        o_buffer.put(this.a23);
        o_buffer.put(this.a33);
    }

    public void toBufferRowMajor(FloatBuffer o_buffer) {
        o_buffer.put(this.a11);
        o_buffer.put(this.a12);
        o_buffer.put(this.a13);
        o_buffer.put(this.a21);
        o_buffer.put(this.a22);
        o_buffer.put(this.a23);
        o_buffer.put(this.a31);
        o_buffer.put(this.a32);
        o_buffer.put(this.a33);
    }

    public String toString() {
        return String.format("%n(%s, %s, %s%n %s, %s, %s%n %s, %s, %s)%n", String.valueOf(this.a11), String.valueOf(this.a12), String.valueOf(this.a13), String.valueOf(this.a21), String.valueOf(this.a22), String.valueOf(this.a23), String.valueOf(this.a31), String.valueOf(this.a32), String.valueOf(this.a33));
    }
}

