/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometry.intersection;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.draw3d.geometry.intersection.AVLTree;
import org.eclipse.draw3d.geometry.intersection.PointList;

public class PointQueue {
    private int m_next = -1;
    private List<IndexedList> m_readable = new ArrayList<IndexedList>();
    private AVLTree<Point> m_writable = new AVLTree();

    public PointQueue(PointList ... i_lists) {
        PointList[] pointListArray = i_lists;
        int n = i_lists.length;
        int n2 = 0;
        while (n2 < n) {
            PointList list = pointListArray[n2];
            this.m_readable.add(new IndexedList(list));
            ++n2;
        }
    }

    private void findNext() {
        int x;
        if (this.m_next != -2) {
            return;
        }
        if (this.m_writable.size() > 0) {
            this.m_next = -1;
            x = this.m_writable.getFirst().getX();
        } else {
            this.m_next = -2;
            x = Integer.MIN_VALUE;
        }
        int i = 0;
        while (i < this.m_readable.size()) {
            IndexedList list = this.m_readable.get(i);
            if (list.hasNext()) {
                list.inc();
                int listX = list.getX();
                if (listX < x) {
                    x = listX;
                    this.m_next = i;
                }
                list.dec();
            }
            ++i;
        }
    }

    public int getX() {
        if (this.m_next == -2) {
            throw new NoSuchElementException();
        }
        if (this.m_next == -1) {
            return this.m_writable.getFirst().getX();
        }
        return this.m_readable.get(this.m_next).getX();
    }

    public int getY() {
        if (this.m_next == -2) {
            throw new NoSuchElementException();
        }
        if (this.m_next == -1) {
            return this.m_writable.getFirst().getY();
        }
        return this.m_readable.get(this.m_next).getY();
    }

    public boolean isEmpty() {
        this.findNext();
        return this.m_next == -2;
    }

    public void pop() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        if (this.m_next == -1) {
            this.m_writable.remove(this.m_writable.getFirst());
        } else {
            this.m_readable.get(this.m_next).inc();
        }
        this.m_next = -2;
    }

    public void push(int i_x, int i_y) {
        this.m_writable.insert(new Point(i_x, i_y));
    }

    private static class IndexedList {
        private int m_index = -1;
        private PointList m_list;

        public IndexedList(PointList i_list) {
            this.m_list = i_list;
        }

        public void dec() {
            if (this.m_index <= -1) {
                throw new NoSuchElementException();
            }
        }

        public int getX() {
            return this.m_list.getX(this.m_index);
        }

        public int getY() {
            return this.m_list.getY(this.m_index);
        }

        public boolean hasNext() {
            return this.m_index < this.m_list.getSize() - 1;
        }

        public void inc() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.m_index;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Point
    implements Comparable<Point> {
        private int m_x;
        private int m_y;

        public Point(int i_x, int i_y) {
            this.m_x = i_x;
            this.m_y = i_y;
        }

        @Override
        public int compareTo(Point i_o) {
            return this.getX() - i_o.getX();
        }

        public int getX() {
            return this.m_x;
        }

        public int getY() {
            return this.m_y;
        }
    }
}

