/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3d.factories;

import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef3d.factories.DisplayMode;
import org.eclipse.gef3d.factories.IFigureFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedFigureFactory
implements IFigureFactory {
    protected Map<Class<? extends GraphicalEditPart>, Class<? extends IFigure>> editPart2FigureClass;
    protected DisplayMode mode;

    public MappedFigureFactory(DisplayMode mode) {
        this.mode = mode;
    }

    public void setMap(Map<Class<? extends GraphicalEditPart>, Class<? extends IFigure>> map) {
        if (map == null) {
            throw new NullPointerException("map must not be null");
        }
        this.editPart2FigureClass = map;
    }

    @Override
    public IFigure createFigure(GraphicalEditPart i_controller, Object i_hint) {
        IFigure fig;
        if (this.editPart2FigureClass == null) {
            throw new IllegalStateException("map, mapping edit part classes to figure classes, was not set.");
        }
        Class<? extends IFigure> _class = this.editPart2FigureClass.get(i_controller.getClass());
        if (_class == null) {
            throw new IllegalStateException("No class set for type " + i_controller.getClass());
        }
        try {
            fig = _class.newInstance();
        }
        catch (InstantiationException ex) {
            throw new IllegalStateException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException(ex);
        }
        return fig;
    }

    @Override
    public DisplayMode getMode() {
        return this.mode;
    }
}

