/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometry;

import org.eclipse.draw3d.geometry.IMatrix2f;
import org.eclipse.draw3d.geometry.Math3DVector4f;
import org.eclipse.draw3d.geometry.Matrix2f;
import org.eclipse.draw3d.geometry.Matrix2fImpl;

public class Math3DMatrix2f
extends Math3DVector4f {
    public static Matrix2f add(IMatrix2f i_left, IMatrix2f i_right, Matrix2f o_result) {
        Matrix2fImpl result;
        Matrix2fImpl left = Matrix2fImpl.cast(i_left);
        Matrix2fImpl right = Matrix2fImpl.cast(i_right);
        if (o_result == null) {
            result = new Matrix2fImpl();
            o_result = result;
        } else {
            result = Matrix2fImpl.cast(o_result);
        }
        result.a11 = left.a11 + right.a11;
        result.a12 = left.a12 + right.a12;
        result.a21 = left.a21 + right.a21;
        result.a22 = left.a22 + right.a22;
        if (o_result != result) {
            o_result.set(result);
        }
        return o_result;
    }

    public static Matrix2f sub(IMatrix2f i_left, IMatrix2f i_right, Matrix2f o_result) {
        Matrix2fImpl result;
        Matrix2fImpl left = Matrix2fImpl.cast(i_left);
        Matrix2fImpl right = Matrix2fImpl.cast(i_right);
        if (o_result == null) {
            result = new Matrix2fImpl();
            o_result = result;
        } else {
            result = Matrix2fImpl.cast(o_result);
        }
        result.a11 = left.a11 - right.a11;
        result.a12 = left.a12 - right.a12;
        result.a21 = left.a21 - right.a21;
        result.a22 = left.a22 - right.a22;
        if (o_result != result) {
            o_result.set(result);
        }
        return o_result;
    }

    public static Matrix2f mul(IMatrix2f i_left, IMatrix2f i_right, Matrix2f o_result) {
        Matrix2fImpl result;
        Matrix2fImpl left = Matrix2fImpl.cast(i_left);
        Matrix2fImpl right = Matrix2fImpl.cast(i_right);
        if (o_result == null) {
            result = new Matrix2fImpl();
            o_result = result;
        } else {
            result = Matrix2fImpl.cast(o_result);
        }
        if (result == left && result == right) {
            float t = result.a11;
            result.a11 = t * result.a11 + result.a12 * result.a21;
            float s = result.a12;
            result.a12 = t * s + s * result.a22;
            float u = result.a21;
            result.a21 = u * result.a11 + result.a22 * u;
            result.a22 = u * s + result.a22 * result.a22;
        } else if (result == left) {
            float t = result.a11;
            result.a11 = t * right.a11 + result.a12 * right.a21;
            result.a12 = t * right.a12 + left.a12 * right.a22;
            t = result.a21;
            result.a21 = t * right.a11 + result.a22 * right.a21;
            result.a22 = t * right.a12 + result.a22 * right.a22;
        } else if (result == right) {
            float t = result.a11;
            result.a11 = left.a11 * t + left.a12 * result.a21;
            result.a21 = left.a21 * t + left.a22 * result.a21;
            t = result.a22;
            result.a12 = left.a11 * result.a12 + left.a12 * t;
            result.a22 = left.a21 * result.a12 + left.a22 * t;
        } else {
            result.a11 = left.a11 * right.a11 + left.a12 * right.a21;
            result.a12 = left.a11 * right.a12 + left.a12 * right.a22;
            result.a21 = left.a21 * right.a11 + left.a22 * right.a21;
            result.a22 = left.a21 * right.a12 + left.a22 * right.a22;
        }
        if (o_result != result) {
            o_result.set(result);
        }
        return o_result;
    }

    public static Matrix2f transpose(IMatrix2f i_source, Matrix2f o_result) {
        Matrix2fImpl result;
        Matrix2fImpl m = Matrix2fImpl.cast(i_source);
        if (o_result == null) {
            result = new Matrix2fImpl();
            o_result = result;
        } else {
            result = Matrix2fImpl.cast(o_result);
        }
        if (result == m) {
            float t = result.a12;
            result.a12 = m.a21;
            result.a21 = t;
        } else {
            result.a11 = m.a11;
            result.a22 = m.a22;
            result.a12 = m.a21;
            result.a21 = m.a12;
        }
        if (o_result != result) {
            o_result.set(result);
        }
        return o_result;
    }

    public static float determinant(IMatrix2f i_matrix) {
        Matrix2fImpl m = Matrix2fImpl.cast(i_matrix);
        return Math3DMatrix2f.det(m.a11, m.a12, m.a21, m.a22);
    }

    public static float det(float a, float b, float c, float d) {
        return a * d - b * c;
    }

    public static float negdet(float a, float b, float c, float d) {
        return b * c - a * d;
    }

    public static Matrix2f invert(IMatrix2f i_source, Matrix2f o_result) {
        float det = Math3DMatrix2f.determinant(i_source);
        if (det != 0.0f) {
            o_result = Math3DMatrix2f.adjugate(i_source, o_result);
            return Math3DMatrix2f.mul(1.0f / det, (IMatrix2f)o_result, o_result);
        }
        return null;
    }

    public static Matrix2f adjugate(IMatrix2f i_source, Matrix2f o_result) {
        Matrix2fImpl result;
        Matrix2fImpl m = Matrix2fImpl.cast(i_source);
        if (o_result == null) {
            result = new Matrix2fImpl();
            o_result = result;
        } else {
            result = Matrix2fImpl.cast(o_result);
        }
        float t = m.a11;
        result.a11 = m.a22;
        result.a12 = -m.a12;
        result.a21 = -m.a21;
        result.a22 = t;
        if (o_result != result) {
            o_result.set(result);
        }
        return o_result;
    }

    public static Matrix2f mul(float f, IMatrix2f i_source, Matrix2f o_result) {
        Matrix2fImpl result;
        Matrix2fImpl m = Matrix2fImpl.cast(i_source);
        if (o_result == null) {
            result = new Matrix2fImpl(m);
            o_result = result;
        } else {
            result = Matrix2fImpl.cast(o_result);
            result.set(m);
        }
        result.a11 *= f;
        result.a12 *= f;
        result.a21 *= f;
        result.a22 *= f;
        if (o_result != result) {
            o_result.set(result);
        }
        return o_result;
    }

    public static Matrix2f negate(IMatrix2f i_source, Matrix2f o_result) {
        Matrix2fImpl result;
        Matrix2fImpl m = Matrix2fImpl.cast(i_source);
        if (o_result == null) {
            result = new Matrix2fImpl();
            o_result = result;
        } else {
            result = Matrix2fImpl.cast(o_result);
        }
        result.a11 = -m.a11;
        result.a12 = -m.a12;
        result.a21 = -m.a21;
        result.a22 = -m.a22;
        if (o_result != result) {
            o_result.set(result);
        }
        return o_result;
    }
}

