/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf.chart;

import java.util.List;
import org.eclipse.amp.agf.chart.CachedColorProvider;
import org.eclipse.amp.agf.chart.ChartType;
import org.eclipse.amp.agf.chart.IChartDesignStrategy;
import org.eclipse.amp.agf.chart.IDataProvider;
import org.eclipse.amp.agf.chart.IDataSelectionListener;
import org.eclipse.amp.axf.core.ILifeCycleListener;
import org.eclipse.amp.axf.core.IModel;
import org.eclipse.amp.axf.core.IObservationProvider;
import org.eclipse.amp.axf.view.SWTAsyncModelListener;
import org.eclipse.birt.chart.api.ChartEngine;
import org.eclipse.birt.chart.device.ICallBackNotifier;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.CallBackValue;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Palette;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.PaletteImpl;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.statushandlers.StatusManager;

public class ChartEditPart
extends AbstractGraphicalEditPart
implements ICallBackNotifier {
    private Chart chart;
    private final ResourceManager resourceManager = new ResourceManager();
    private IDeviceRenderer renderer;
    private GeneratedChartState chartState;
    private IDataProvider dataProvider;
    private IColorProvider seriesColorProvider;
    private Palette genericPalette;
    private Object dataSource;
    private ChartModelListener chartListener;
    private IDataSelectionListener dataListener;
    private int nextOpenPaletteIndex;
    private IChartDesignStrategy chartStrategy;

    public ChartEditPart() {
        PlatformConfig config = new PlatformConfig();
        try {
            config.setProperty("device.component", (Object)this);
            this.renderer = ChartEngine.instance((PlatformConfig)config).getRenderer("dv.SWT");
        }
        catch (ChartException e) {
            throw new RuntimeException(e);
        }
        this.genericPalette = PaletteImpl.create((int)0, (boolean)true);
        this.genericPalette.shift(0);
    }

    private void updateValueSetColor(Object valueSet) {
        String seriesLabel = this.dataProvider.getText(valueSet);
        Color swtColor = this.seriesColorProvider.getForeground((Object)seriesLabel);
        EList entries = this.chartStrategy.getValueSetsDefinition().getSeriesPalette().getEntries();
        ColorDefinition cd = null;
        if (swtColor == null) {
            if (this.seriesColorProvider instanceof CachedColorProvider) {
                cd = (ColorDefinition)this.genericPalette.getEntries().get(this.nextOpenPaletteIndex++);
                if (this.nextOpenPaletteIndex > this.genericPalette.getEntries().size() - 1) {
                    this.nextOpenPaletteIndex = 0;
                }
                swtColor = new Color((Device)Display.getCurrent(), cd.getRed(), cd.getGreen(), cd.getBlue());
                ((CachedColorProvider)this.seriesColorProvider).putForegroundColor(seriesLabel, swtColor);
            }
        } else {
            cd = ColorDefinitionImpl.create((int)swtColor.getRed(), (int)swtColor.getGreen(), (int)swtColor.getBlue());
        }
        entries.add(cd);
    }

    protected IFigure createFigure() {
        this.chartListener.setWidget(this.getViewer().getControl());
        final Figure newFigure = new Figure(){

            public void paintFigure(Graphics graphics) {
                if (ChartEditPart.this.getResourceManager().getImage() != null) {
                    graphics.drawImage(ChartEditPart.this.getResourceManager().getImage(), 0, 0);
                    if (ChartEditPart.this.getChartListener() != null) {
                        ChartEditPart.this.getChartListener().endPainting();
                    }
                }
            }
        };
        newFigure.setLayoutManager((LayoutManager)new AbstractLayout(){

            public Dimension getMinimumSize(IFigure container, int hintWidth, int hintHeight) {
                return new Dimension(hintWidth < 1 ? 1 : hintWidth, hintHeight < 1 ? 1 : hintHeight);
            }

            protected Dimension calculatePreferredSize(IFigure container, int hintWidth, int hintHeight) {
                return new Dimension(hintWidth < 1 ? 100 : hintWidth, hintHeight < 1 ? 100 : hintHeight);
            }

            public void layout(IFigure container) {
                newFigure.setLocation(new Point(0, 0));
            }
        });
        newFigure.addFigureListener(new FigureListener(){

            public void figureMoved(IFigure source) {
                ChartEditPart.this.regenerateChart();
            }
        });
        return newFigure;
    }

    protected void createEditPolicies() {
    }

    public void refresh() {
        new Thread(){

            @Override
            public void run() {
                ChartEditPart.this.regenerateChart(true);
            }
        }.run();
    }

    public void setModel(Object model) {
        super.setModel(model);
        this.chartListener = new ChartModelListener();
        ((IModel)model).addModelListener((ILifeCycleListener)this.chartListener);
        IAdapterManager adapterManager = Platform.getAdapterManager();
        Object provider = adapterManager.loadAdapter(this.getModel(), "org.eclipse.amp.agf.chart.IDataProvider");
        if (!(provider instanceof IDataProvider)) {
            throw new RuntimeException("Couldn't find data provider for chart model. Please ensure that a data provider adapter has been defined for the class: " + this.getModel().getClass());
        }
        this.setDataProvider((IDataProvider)provider);
    }

    public void regenerateChart() {
        this.regenerateChart(true);
    }

    public synchronized void regenerateChart(boolean forceNewImage) {
        if (forceNewImage) {
            this.getResourceManager().setImage(null);
        }
        try {
            if (this.chart != null && this.chartStrategy.isInitialized() && this.getFigure() != null && !this.getFigure().getSize().isEmpty()) {
                this.createImage();
                Dimension area = this.getFigure().getSize();
                Bounds chartBounds = BoundsImpl.create((double)0.0, (double)0.0, (double)area.width, (double)area.height);
                chartBounds.scale(72.0 / (double)this.renderer.getDisplayServer().getDpiResolution());
                Generator gr = Generator.instance();
                RunTimeContext rtc = new RunTimeContext();
                rtc.setScriptingEnabled(false);
                this.chartState = gr.build(this.renderer.getDisplayServer(), this.chart, chartBounds, rtc);
                gr.render(this.renderer, this.chartState);
                this.getFigure().repaint();
            } else {
                this.chartListener.endPainting();
            }
        }
        catch (ChartException ce) {
            StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.amp.agf.charts", "Couldn't generate chart.", (Throwable)ce));
            this.chartListener.endPainting();
        }
    }

    public void createImage() {
        Dimension area = this.getFigure().getSize();
        Rectangle swtBounds = new Rectangle(0, 0, Math.max(area.width, 10), Math.max(area.height, 10));
        if (this.resourceManager.getImage() == null || !this.resourceManager.getImage().getBounds().equals((Object)swtBounds)) {
            this.resourceManager.setImage(new Image((Device)this.getViewer().getControl().getDisplay(), swtBounds));
            this.resourceManager.setGc(new GC((Drawable)this.resourceManager.getImage()));
            this.renderer.setProperty("device.output.context", (Object)this.resourceManager.getGc());
        }
    }

    public synchronized void createChart() {
        this.chart = this.chartStrategy.createChart(this.dataProvider, this.dataSource);
        this.chart.getTitle().getLabel().setVisible(false);
    }

    public synchronized void updateChartSelection() {
        this.chartStrategy.updateSelection();
        List valueSets = this.dataProvider.getValueSets(this.dataSource);
        this.chartStrategy.getValueSetsDefinition().getSeriesPalette().getEntries().clear();
        for (Object valueSet : valueSets) {
            this.updateValueSetColor(valueSet);
        }
    }

    public Chart getDesignTimeModel() {
        return this.chart;
    }

    public Chart getRunTimeModel() {
        return this.chartState.getChartModel();
    }

    ChartModelListener getChartListener() {
        return this.chartListener;
    }

    IChartDesignStrategy getChartStrategy() {
        return this.chartStrategy;
    }

    Object getDataSource() {
        return this.dataSource;
    }

    IDataSelectionListener getDataListener() {
        return this.dataListener;
    }

    public Object peerInstance() {
        return this;
    }

    public void callback(Object arg0, Object arg1, CallBackValue arg2) {
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setSeriesColorProvider(IColorProvider seriesColorProvider) {
        this.seriesColorProvider = seriesColorProvider;
    }

    public void repaintChart() {
        this.refresh();
    }

    public void deactivate() {
        super.deactivate();
        this.dataProvider.removeListener(this.dataSource, this.dataListener);
    }

    public IDataProvider getDataProvider() {
        return this.dataProvider;
    }

    public synchronized void setDataProvider(IDataProvider dataProvider) {
        this.dataProvider = dataProvider;
        this.dataSource = dataProvider.getDataSource(this.getModel());
        this.dataListener = new IDataSelectionListener(){

            @Override
            public void selectionChanged(Object dataSet) {
                if (ChartEditPart.this.getParent() != null && ChartEditPart.this.getRoot() != null && ChartEditPart.this.getViewer() != null && ChartEditPart.this.getChart() != null) {
                    ChartEditPart.this.updateChartSelection();
                    ChartEditPart.this.getViewer().getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ChartEditPart.this.regenerateChart(true);
                        }
                    });
                }
            }
        };
        dataProvider.addListener(this.dataSource, this.dataListener);
    }

    public void setChartStrategy(IChartDesignStrategy chartStrategy) {
        this.chartStrategy = chartStrategy;
        this.createChart();
        this.updateChartSelection();
        if (this.getViewer().getControl().getDisplay() != null) {
            this.getViewer().getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ChartEditPart.this.repaintChart();
                }
            });
        }
    }

    public IColorProvider getSeriesColorProvider() {
        return this.seriesColorProvider;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    class ChartModelListener
    extends SWTAsyncModelListener {
        public ChartModelListener() {
            super(null, "Chart Updated View", 10000L);
        }

        public void observing(IObservationProvider observed) {
            while (ChartEditPart.this.getDataProvider() == null) {
                try {
                    Thread.sleep(25L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ChartEditPart.this.setChartStrategy(ChartType.TIME_SERIES.createStrategy());
        }

        public void observeStart(IObservationProvider observed) {
            ChartEditPart.this.updateChartSelection();
            this.endPainting();
        }

        public void observeInitialize(IObservationProvider model) {
            ChartEditPart.this.getResourceManager().setImage(null);
        }

        public void update(IModel model) {
            this.beginPainting();
            ChartEditPart.this.getChartStrategy().update();
            ChartEditPart.this.refresh();
        }

        public void observationEnd(IObservationProvider model) {
            ChartEditPart.this.getDataProvider().removeListener(ChartEditPart.this.getDataSource(), ChartEditPart.this.getDataListener());
            model = null;
        }
    }

    public class ResourceManager
    implements DisposeListener {
        private GC gc;
        private Image image;
        private Control disposeEventProvider;

        public void setGc(GC gc) {
            if (this.gc != null && !this.gc.isDisposed()) {
                this.gc.dispose();
            }
            this.gc = gc;
            this.addDisposeListener();
        }

        GC getGc() {
            return this.gc;
        }

        private void removeDisposeListener() {
            if (this.disposeEventProvider != null) {
                if (!this.disposeEventProvider.isDisposed()) {
                    if (ChartEditPart.this.getViewer() != null && this.disposeEventProvider.equals(ChartEditPart.this.getViewer().getControl())) {
                        return;
                    }
                    this.disposeEventProvider.removeDisposeListener((DisposeListener)this);
                }
                this.disposeEventProvider = null;
            }
        }

        private void addDisposeListener() {
            this.removeDisposeListener();
            if (this.disposeEventProvider == null && ChartEditPart.this.getViewer() != null && ChartEditPart.this.getViewer().getControl() != null && !ChartEditPart.this.getViewer().getControl().isDisposed()) {
                this.disposeEventProvider = ChartEditPart.this.getViewer().getControl();
                this.disposeEventProvider.addDisposeListener((DisposeListener)this);
            }
        }

        Image getImage() {
            return this.image;
        }

        public void setImage(Image image) {
            if (this.image != null && !this.image.isDisposed()) {
                this.image.dispose();
            }
            this.image = image;
            this.addDisposeListener();
        }

        public void widgetDisposed(DisposeEvent arg0) {
            this.setImage(null);
            this.setGc(null);
            this.removeDisposeListener();
        }
    }
}

