/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics.optimizer;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw3d.graphics.StatefulGraphics;
import org.eclipse.draw3d.graphics.optimizer.PrimitiveSet;
import org.eclipse.draw3d.graphics.optimizer.classification.PrimitiveClass;
import org.eclipse.draw3d.graphics.optimizer.classification.PrimitiveClassifier;
import org.eclipse.draw3d.graphics.optimizer.primitive.ImagePrimitive;
import org.eclipse.draw3d.graphics.optimizer.primitive.LinePrimitive;
import org.eclipse.draw3d.graphics.optimizer.primitive.PolygonPrimitive;
import org.eclipse.draw3d.graphics.optimizer.primitive.PolylinePrimitive;
import org.eclipse.draw3d.graphics.optimizer.primitive.Primitive;
import org.eclipse.draw3d.graphics.optimizer.primitive.QuadPrimitive;
import org.eclipse.draw3d.graphics.optimizer.primitive.TextPrimitive;
import org.eclipse.draw3d.util.ArcHelper;
import org.eclipse.draw3d.util.Draw3DCache;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordingGraphics
extends StatefulGraphics {
    private static final float ARC_PREC = 0.5f;
    private static final float PI = (float)Math.PI;
    private static final float PI_2 = 1.5707964f;
    private static final float PI_32 = 4.712389f;
    private PrimitiveClassifier m_classifier;
    private GC m_fontGC;
    private Image m_fontImage;
    private PrimitiveSet m_primitives;

    public RecordingGraphics(PrimitiveClassifier i_classifier) {
        if (i_classifier == null) {
            throw new NullPointerException("i_classifier must not be null");
        }
        this.m_classifier = i_classifier;
    }

    private void addPrimitive(Primitive i_primitive) {
        PrimitiveClass primitiveClass;
        if (this.m_primitives == null) {
            primitiveClass = this.m_classifier.classify(i_primitive);
            this.m_primitives = new PrimitiveSet(primitiveClass);
        }
        if (!this.m_primitives.add(i_primitive)) {
            primitiveClass = this.m_classifier.classify(i_primitive);
            this.m_primitives = new PrimitiveSet(this.m_primitives, primitiveClass);
            if (!this.m_primitives.add(i_primitive)) {
                throw new AssertionError((Object)("cannot add primitive " + i_primitive));
            }
        }
    }

    @Override
    public void dispose() {
        if (this.m_fontGC != null) {
            this.m_fontGC.dispose();
            this.m_fontGC = null;
        }
        if (this.m_fontImage != null) {
            this.m_fontImage.dispose();
            this.m_fontImage = null;
        }
        super.dispose();
    }

    public void drawArc(int i_x, int i_y, int i_w, int i_h, int i_offset, int i_length) {
        float rOffset = (float)Math.toRadians(i_offset + i_length);
        float rLength = (float)Math.toRadians(-i_length);
        ArcHelper helper = new ArcHelper(0.5f, i_x, i_y, i_w, i_h, rOffset, rLength, false);
        float[] vertices = helper.getArray();
        this.addPrimitive(new PolylinePrimitive(this.getState(), vertices));
    }

    public void drawFocus(int i_x, int i_y, int i_w, int i_h) {
        this.pushState();
        try {
            Display dev = Display.getCurrent();
            Color c = dev.getSystemColor(26);
            this.setForegroundColor(c);
            this.setLineStyle(1);
            this.setLineWidth(2);
            this.drawRectangle(i_x, i_y, i_w, i_h);
        }
        finally {
            this.popState();
        }
    }

    public void drawImage(Image i_image, int i_x, int i_y) {
        int w = i_image.getBounds().width;
        int h = i_image.getBounds().height;
        this.drawImage(i_image, 0, 0, w, h, i_x, i_y, w, h);
    }

    public void drawImage(Image i_image, int i_x1, int i_y1, int i_w1, int i_h1, int i_x2, int i_y2, int i_w2, int i_h2) {
        Rectangle source = new Rectangle(i_x1, i_y1, i_w1, i_h1);
        Rectangle target = new Rectangle(i_x2, i_y2, i_w2, i_h2);
        this.addPrimitive(new ImagePrimitive(this.getState(), i_image, source, target));
    }

    public void drawLine(int i_x1, int i_y1, int i_x2, int i_y2) {
        this.addPrimitive(new LinePrimitive(this.getState(), i_x1, i_y1, i_x2, i_y2));
    }

    public void drawOval(int i_x, int i_y, int i_w, int i_h) {
        this.drawArc(i_x, i_y, i_w, i_h, 0, 360);
    }

    public void drawPolygon(PointList i_points) {
        this.addPrimitive(new PolygonPrimitive(this.getState(), i_points, false));
    }

    public void drawPolyline(PointList i_points) {
        if (i_points.size() == 2) {
            Point p = Draw3DCache.getPoint();
            try {
                i_points.getPoint(p, 0);
                int x1 = p.x;
                int y1 = p.y;
                i_points.getPoint(p, 1);
                int x2 = p.x;
                int y2 = p.y;
                this.drawLine(x1, y1, x2, y2);
            }
            catch (Throwable throwable) {
                Draw3DCache.returnPoint(p);
                throw throwable;
            }
            Draw3DCache.returnPoint(p);
        } else {
            this.addPrimitive(new PolylinePrimitive(this.getState(), i_points));
        }
    }

    public void drawRectangle(int i_x, int i_y, int i_width, int i_height) {
        this.addPrimitive(QuadPrimitive.createOutlineQuad(this.getState(), i_x, i_y, i_width, i_height));
    }

    public void drawRoundRectangle(Rectangle i_r, int i_arcWidth, int i_arcHeight) {
        this.roundRectangle(i_r, i_arcWidth, i_arcHeight, false);
    }

    public void drawString(String i_s, int i_x, int i_y) {
        this.addPrimitive(new TextPrimitive(this.getState(), i_s, false, new Point(i_x, i_y)));
    }

    public void drawText(String i_s, int i_x, int i_y) {
        this.addPrimitive(new TextPrimitive(this.getState(), i_s, true, new Point(i_x, i_y)));
    }

    public void fillArc(int i_x, int i_y, int i_w, int i_h, int i_offset, int i_length) {
        ArcHelper helper = new ArcHelper(0.5f, i_x, i_y, i_w, i_h, i_offset + i_length, -i_length, false);
        float[] vertices = new float[2 * (helper.getNumVertices() + 1)];
        helper.getArray(vertices);
        vertices[vertices.length - 2] = i_x + i_w;
        vertices[vertices.length - 1] = i_y + i_h;
        this.addPrimitive(new PolygonPrimitive(this.getState(), vertices, true));
    }

    public void fillGradient(int i_x, int i_y, int i_w, int i_h, boolean i_vertical) {
        this.addPrimitive(QuadPrimitive.createGradientQuad(this.getState(), i_x, i_y, i_w, i_h, i_vertical));
    }

    public void fillOval(int i_x, int i_y, int i_w, int i_h) {
        ArcHelper helper = new ArcHelper(0.5f, i_x, i_y, i_w, i_h, 0.0f, (float)Math.PI * 2, true);
        float[] vertices = helper.getArray();
        this.addPrimitive(new PolygonPrimitive(this.getState(), vertices, true));
    }

    public void fillPolygon(PointList i_points) {
        this.addPrimitive(new PolygonPrimitive(this.getState(), i_points, true));
    }

    public void fillRectangle(int i_x, int i_y, int i_width, int i_height) {
        this.addPrimitive(QuadPrimitive.createSolidQuad(this.getState(), i_x, i_y, i_width, i_height));
    }

    public void fillRoundRectangle(Rectangle i_r, int i_arcWidth, int i_arcHeight) {
        this.roundRectangle(i_r, i_arcWidth, i_arcHeight, true);
    }

    public void fillString(String i_s, int i_x, int i_y) {
        this.fillText(i_s, false, i_x, i_y);
    }

    private void fillText(String i_s, boolean expand, int i_x, int i_y) {
        TextPrimitive textPrimitive = new TextPrimitive(this.getState(), i_s, expand, new Point(i_x, i_y));
        Dimension extent = textPrimitive.getExtent();
        QuadPrimitive quadPrimitive = QuadPrimitive.createSolidQuad(this.getState(), i_x, i_y, extent.width, extent.height);
        this.addPrimitive(quadPrimitive);
        this.addPrimitive(textPrimitive);
    }

    public void fillText(String i_s, int i_x, int i_y) {
        this.fillText(i_s, true, i_x, i_y);
    }

    public List<PrimitiveSet> getPrimiveSets() {
        if (this.m_primitives == null) {
            return Collections.emptyList();
        }
        LinkedList<PrimitiveSet> result = new LinkedList<PrimitiveSet>();
        this.m_primitives.getSets(result);
        return result;
    }

    private void roundRectangle(Rectangle i_r, int i_arcWidth, int i_arcHeight, boolean i_fill) {
        float x1 = i_r.x;
        float y1 = i_r.y;
        float x2 = x1 + (float)i_r.width;
        float y2 = y1 + (float)i_r.height;
        float w = 2 * i_arcWidth;
        float h = 2 * i_arcHeight;
        ArcHelper h1 = new ArcHelper(0.5f, x1, y1, w, h, 1.5707964f, 1.5707964f, false);
        ArcHelper h2 = new ArcHelper(0.5f, x1, y2 - h, w, h, (float)Math.PI, 1.5707964f, false);
        ArcHelper h3 = new ArcHelper(0.5f, x2 - w, y2 - h, w, h, 4.712389f, 1.5707964f, false);
        ArcHelper h4 = new ArcHelper(0.5f, x2 - w, y1, w, h, 0.0f, 1.5707964f, false);
        int n1 = 2 * h1.getNumVertices();
        int n2 = 2 * h2.getNumVertices();
        int n3 = 2 * h3.getNumVertices();
        int n4 = 2 * h4.getNumVertices();
        float[] vertices = new float[n1 + n2 + n3 + n4];
        h1.getArray(vertices, 0);
        h2.getArray(vertices, n1);
        h3.getArray(vertices, n1 + n2);
        h4.getArray(vertices, n1 + n2 + n3);
        this.addPrimitive(new PolygonPrimitive(this.getState(), vertices, i_fill));
    }

    public void fillPath(Path i_path) {
        if (i_path == null) {
            throw new NullPointerException("i_path must not be null");
        }
        PointList pointList = this.pathToPointList(i_path);
        this.fillPolygon(pointList);
    }

    private PointList pathToPointList(Path i_path) {
        float[] points = i_path.getPathData().points;
        PointList pointList = new PointList(points.length / 2);
        int i = 0;
        while (i < points.length - 1) {
            pointList.addPoint(new Point((int)points[i], (int)points[i + 1]));
            i += 2;
        }
        return pointList;
    }

    public void clipPath(Path i_path) {
        if (i_path == null) {
            throw new NullPointerException("i_path must not be null");
        }
        PointList pointList = this.pathToPointList(i_path);
        Rectangle rect = pointList.getBounds();
        this.clipRect(rect);
    }

    public void setClip(Path i_path) {
    }

    public void drawPath(Path i_path) {
        if (i_path == null) {
            throw new NullPointerException("i_path must not be null");
        }
        PointList pointList = this.pathToPointList(i_path);
        this.drawPolygon(pointList);
    }

    public void drawText(String i_s, int i_x, int i_y, int i_style) {
        this.drawText(i_s, i_x, i_y);
    }

    public void drawTextLayout(TextLayout i_layout, int i_x, int i_y, int i_selectionStart, int i_selectionEnd, Color i_selectionForeground, Color i_selectionBackground) {
        String s = i_layout.getText();
        int adjustedX = i_x;
        int adjustedSelectionEnd = Math.min(s.length(), i_selectionEnd);
        if (i_selectionStart > 0) {
            String s0 = s.substring(0, i_selectionStart);
            TextPrimitive p0 = new TextPrimitive(this.getState(), s0, false, new Point(adjustedX, i_y));
            this.addPrimitive(p0);
            adjustedX += p0.getExtent().width;
        }
        if (i_selectionStart < adjustedSelectionEnd) {
            Color background = this.getBackgroundColor();
            Color foreground = this.getForegroundColor();
            this.setBackgroundColor(i_selectionBackground);
            this.setForegroundColor(i_selectionForeground);
            String s1 = s.substring(i_selectionStart, adjustedSelectionEnd);
            TextPrimitive p1 = new TextPrimitive(this.getState(), s1, false, new Point(adjustedX, i_y));
            this.addPrimitive(p1);
            adjustedX += p1.getExtent().width;
            this.setBackgroundColor(background);
            this.setForegroundColor(foreground);
        }
        if (adjustedSelectionEnd < s.length()) {
            String s2 = s.substring(i_selectionStart, adjustedSelectionEnd);
            TextPrimitive p2 = new TextPrimitive(this.getState(), s2, false, new Point(adjustedX, i_y));
            this.addPrimitive(p2);
        }
    }

    public void setForegroundPattern(Pattern i_pattern) {
    }
}

