/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf.gef;

import org.eclipse.amp.agf.EditPartSelectionSynchronizer;
import org.eclipse.amp.axf.ide.ModelViewManager;
import org.eclipse.amp.axf.view.ModelViewPart;
import org.eclipse.amp.axf.view.SelectionSynchronizer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AGFViewPart
extends ModelViewPart {
    private PropertySelectionListener selectionListener;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.createSelectionSynchronizer();
    }

    protected void createSelectionListener(ISelectionProvider provider) {
        super.createSelectionListener(provider);
        this.selectionListener = new PropertySelectionListener();
        provider.addSelectionChangedListener((ISelectionChangedListener)this.selectionListener);
    }

    public void createSelectionSynchronizer() {
        ModelViewManager manager = ModelViewManager.getInstance();
        if (!(manager.getSelectionSynchronizer() instanceof EditPartSelectionSynchronizer)) {
            manager.setSelectionSynchronizer((SelectionSynchronizer)new EditPartSelectionSynchronizer());
        }
        manager.getSelectionSynchronizer().addViewer(this.getSelectionProvider());
        this.getSite().setSelectionProvider(this.getSelectionProvider());
    }

    public Object getAdapter(Class type) {
        if (type == ISelectionProvider.class) {
            return this.getSelectionProvider();
        }
        return super.getAdapter(type);
    }

    public void dispose() {
        super.dispose();
        this.removeSelectionListener(this.getSelectionProvider());
        this.getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this.selectionListener);
    }

    protected abstract ISelectionProvider getSelectionProvider();

    class PropertySelectionListener
    implements ISelectionChangedListener {
        PropertySelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (!event.getSelection().isEmpty() && event.getSelection() instanceof StructuredSelection) {
                StructuredSelection sel = (StructuredSelection)event.getSelection();
                AGFViewPart.this.getPropertySheetPage().selectionChanged((IWorkbenchPart)AGFViewPart.this, (ISelection)new StructuredSelection(sel.getFirstElement()));
            }
        }
    }
}

