/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.space;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.ascape.model.space.Array;
import org.ascape.model.space.Coordinate;
import org.ascape.model.space.Coordinate1DDiscrete;
import org.ascape.model.space.CoordinateDiscrete;
import org.ascape.model.space.Geometry;
import org.ascape.model.space.Location;
import org.ascape.model.space.Node;
import org.ascape.model.space.NodeOccupant;
import org.ascape.util.Conditional;

public abstract class ListBase
extends Array
implements List {
    private static final long serialVersionUID = 1L;
    private boolean coordinateSweepNeeded;

    public ListBase() {
        this.setExtent(new Coordinate1DDiscrete(0));
    }

    public ListBase(CoordinateDiscrete extent) {
        this();
        this.setExtent(extent);
    }

    @Override
    public void populate() {
        super.populate();
        if (this.extent != null) {
            this.coordinateSweepNeeded = true;
        }
    }

    public void add(int index, Object o) {
        this.add(index, o, true);
    }

    public void add(int index, Object o, boolean isParent) {
        if (!(o instanceof Location)) {
            throw new ClassCastException("Spaces expect Locations only.");
        }
        if (isParent) {
            if (!((Location)o).isDelete()) {
                if (index < this.size()) {
                    this.deleteSweep();
                    ((List)this.collection).add(index, o);
                } else {
                    this.collection.add(o);
                }
            } else {
                this.coordinateSweepNeeded = true;
            }
            if (o instanceof Node && index == this.size()) {
                ((Node)o).setCoordinate(new Coordinate1DDiscrete(this.getSize()));
            } else {
                this.coordinateSweepNeeded = true;
            }
        } else if (index < this.size()) {
            this.deleteSweep();
            ((List)this.collection).add(index, o);
        } else {
            this.collection.add(o);
        }
        this.setSize(this.getSize() + 1);
    }

    @Override
    public boolean add(Object o, boolean isParent) {
        if (isParent && o instanceof Node) {
            ((Node)o).setCoordinate(new Coordinate1DDiscrete(this.getSize()));
        }
        return super.add(o, isParent);
    }

    public void add(CoordinateDiscrete coordinate, Object o) {
        this.add(coordinate.getValueAtDimension(1), o, true);
    }

    public boolean addAll(int index, Collection c) {
        boolean addedAll = ((List)this.collection).addAll(index, c);
        this.setSize(this.getSize() + c.size());
        return addedAll;
    }

    public Object remove(CoordinateDiscrete coordinate) {
        return this.remove(coordinate.getValueAtDimension(1));
    }

    public Object remove(int index) {
        this.deleteSweep();
        Object removed = ((List)this.collection).get(index);
        this.remove(removed);
        return removed;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Location && this.getContext().isHome((Location)o)) {
            this.coordinateSweepNeeded = true;
        }
        return super.remove(o);
    }

    public Object set(int index, Object o) {
        return this.set(index, (Node)o, true);
    }

    public Node set(int index, Location o, boolean isParent) {
        if (!(o instanceof Location)) {
            throw new ClassCastException("Spaces expect Locations only.");
        }
        if (isParent) {
            this.coordinateSweepNeeded = true;
        }
        this.deleteSweep();
        return (Node)((List)this.collection).set(index, o);
    }

    @Override
    public void setGeometry(Geometry geometry) {
        super.setGeometry(geometry);
        if (geometry.getDimensionCount() != 1) {
            throw new RuntimeException("Tried to assign an inappropriate geometry.");
        }
    }

    @Override
    public int indexOf(Object o) {
        this.deleteSweep();
        return ((List)this.collection).indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        this.deleteSweep();
        return ((List)this.collection).lastIndexOf(o);
    }

    @Override
    public double calculateDistance(Coordinate origin, Coordinate target) {
        int o = ((Coordinate1DDiscrete)origin).getXValue();
        int t = ((Coordinate1DDiscrete)target).getXValue();
        if (this.getGeometry().isPeriodic()) {
            return ListBase.calculateDistance(o, t, this.getSize());
        }
        if (o > t) {
            return o - t;
        }
        return t - o;
    }

    @Override
    public List findWithinImpl(Coordinate origin, boolean includeSelf, double distance) {
        int x;
        Node[] agentsNear;
        int dist = (int)distance;
        this.deleteSweep();
        int rank = ((Coordinate1DDiscrete)origin).getValue();
        int index = 0;
        int listSize = this.collection.size();
        if (listSize > dist * 2 + 1) {
            agentsNear = new Node[dist * 2 + (includeSelf ? 1 : 0)];
            x = Math.min(listSize, listSize + (rank - dist));
            while (x < listSize) {
                agentsNear[index] = (Node)((List)this.collection).get(x);
                ++index;
                ++x;
            }
            x = Math.max(0, rank - dist);
            while (x < Math.min(listSize, rank + dist + 1)) {
                if (includeSelf || x != rank) {
                    agentsNear[index] = (Node)((List)this.collection).get(x);
                    ++index;
                }
                ++x;
            }
            x = 0;
            while (x < Math.max(0, rank + dist - listSize + 1)) {
                agentsNear[index] = (Node)((List)this.collection).get(x);
                ++index;
                ++x;
            }
        } else {
            agentsNear = new Node[listSize - (includeSelf ? 0 : 1)];
            x = 0;
            while (x < listSize) {
                if (includeSelf || x != rank) {
                    agentsNear[index] = (Node)((List)this.collection).get(x);
                    ++index;
                }
                ++x;
            }
        }
        ArrayList<Node> found = new ArrayList<Node>();
        int i = 0;
        while (i < agentsNear.length) {
            found.add(agentsNear[i]);
            ++i;
        }
        return found;
    }

    @Override
    public Node findCellToward(Node origin, Node target) {
        if (origin == target) {
            return origin;
        }
        int ox = ((Coordinate1DDiscrete)origin.getCoordinate()).getValue();
        int tx = ((Coordinate1DDiscrete)target.getCoordinate()).getValue();
        if (!this.getGeometry().isPeriodic()) {
            if (ox > tx) {
                --ox;
            } else if (ox < tx) {
                ++ox;
            }
        } else {
            int ex = this.getSize();
            if (ox > tx) {
                ox = ox - tx < tx + (ex - ox) ? --ox : ++ox;
            } else if (ox < tx) {
                ox = tx - ox < ox + (ex - tx) ? ++ox : --ox;
            }
            if (ox >= ex) {
                ox = 0;
            } else if (ox < 0) {
                ox = ex - 1;
            }
        }
        return (Node)this.get(ox);
    }

    @Override
    public Node findCellAway(Node origin, Node target) {
        if (origin == target) {
            return origin.findRandomNeighbor();
        }
        int ox = ((Coordinate1DDiscrete)origin.getCoordinate()).getXValue();
        int tx = ((Coordinate1DDiscrete)target.getCoordinate()).getXValue();
        int cx = this.getSize();
        if (!this.getGeometry().isPeriodic()) {
            if (ox < tx) {
                if (--ox < 0) {
                    ox = 0;
                }
            } else if (++ox >= cx) {
                ox = cx - 1;
            }
        } else {
            int rx = cx / 2;
            int dx = tx - ox;
            if (dx > 0) {
                ox = dx < rx - 1 ? (ox > 0 ? --ox : cx - 1) : (ox < cx - 1 ? ++ox : 0);
            } else if (dx < 0) {
                ox = dx > -rx - 1 ? (ox < cx - 1 ? ++ox : 0) : (ox > 0 ? --ox : cx - 1);
            }
        }
        return (Node)this.get(ox);
    }

    public int findNearestMatchRank(Coordinate origin, Conditional condition, boolean includeOrigin) {
        if (this.getGeometry().isPeriodic()) {
            return this.findNearestMatchRank(origin, condition, includeOrigin, this.getSize() / 2);
        }
        int pos = ((Coordinate1DDiscrete)origin).getXValue();
        return this.findNearestMatchRank(origin, condition, includeOrigin, Math.max(pos - 1, this.getSize() - pos - 1));
    }

    @Override
    public int findNearestMatchRank(Coordinate origin, Conditional condition, boolean includeOrigin, double maximumDistance) {
        int i = includeOrigin ? 0 : 1;
        while ((double)i <= maximumDistance) {
            if (this.findFirstMatchInRank(origin, condition, i) != null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int checkDown(int pos, Conditional condition, int rank) {
        if ((pos -= rank) < 0) {
            if (this.getGeometry().isPeriodic()) {
                pos += this.getSize();
            } else {
                return -1;
            }
        }
        if (condition.meetsCondition(this.get(pos))) {
            return pos;
        }
        return -1;
    }

    private int checkUp(int pos, Conditional condition, int rank) {
        if ((pos += rank) >= this.getSize()) {
            if (this.getGeometry().isPeriodic()) {
                pos -= this.getSize();
            } else {
                return -1;
            }
        }
        if (condition.meetsCondition(this.get(pos))) {
            return pos;
        }
        return -1;
    }

    public Node findFirstMatchInRank(Coordinate origin, Conditional condition, int rank) {
        int pos = ((Coordinate1DDiscrete)origin).getXValue();
        if ((pos = this.checkUp(pos, condition, rank)) == -1) {
            pos = this.checkDown(((Coordinate1DDiscrete)origin).getXValue(), condition, rank);
        }
        if (pos != -1) {
            return (Node)this.get(pos);
        }
        return null;
    }

    @Override
    public Location findRandomMatchInRank(Coordinate origin, Conditional condition, int rank) {
        int pos = ((Coordinate1DDiscrete)origin).getXValue();
        if (this.randomIs()) {
            if ((pos = this.checkUp(pos, condition, rank)) == -1) {
                pos = this.checkDown(((Coordinate1DDiscrete)origin).getXValue(), condition, rank);
            }
        } else if ((pos = this.checkDown(pos, condition, rank)) == -1) {
            pos = this.checkUp(((Coordinate1DDiscrete)origin).getXValue(), condition, rank);
        }
        if (pos != -1) {
            return (Node)this.get(pos);
        }
        return null;
    }

    public ListIterator listIterator() {
        this.deleteSweep();
        return ((List)this.collection).listIterator();
    }

    public ListIterator listIterator(int index) {
        this.deleteSweep();
        return ((List)this.collection).listIterator(index);
    }

    public List subList(int fromIndex, int toIndex) {
        this.deleteSweep();
        return ((List)this.collection).subList(fromIndex, toIndex);
    }

    public void coordinateSweep() {
        if (this.coordinateSweepNeeded && (!(this.getContext().getPrototype() instanceof NodeOccupant) || ((NodeOccupant)this.getContext().getPrototype()).getHostSpace() == null)) {
            Iterator i = this.iterator();
            int index = 0;
            while (i.hasNext()) {
                Node candidate = (Node)i.next();
                candidate.setCoordinate(new Coordinate1DDiscrete(index));
                ++index;
            }
        }
        this.coordinateSweepNeeded = false;
    }

    public boolean isCoordinateSweepNeeded() {
        return this.coordinateSweepNeeded;
    }

    public Object get(int index) {
        this.deleteSweep();
        return ((List)this.collection).get(index);
    }

    public Node get(CoordinateDiscrete coordinate) {
        this.deleteSweep();
        return (Node)((List)this.collection).get(((Coordinate1DDiscrete)coordinate).getValue());
    }
}

