/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.axf.ide;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.amp.axf.core.EngineStateAdapter;
import org.eclipse.amp.axf.core.IEngine;
import org.eclipse.amp.axf.core.IEngineObserver;
import org.eclipse.amp.axf.core.IModel;
import org.eclipse.amp.axf.ide.IModelWorkbenchListener;
import org.eclipse.amp.axf.ide.ModelViewManager;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.IWorkbenchPart;

public class EngineStateService
extends AbstractSourceProvider
implements IModelWorkbenchListener,
IEngineObserver {
    public static final String ID = "org.eclipse.amp.axf.ide.engine.state";
    private IModel activeModel = null;
    private EngineStateAdapter.EngineState lastState = EngineStateAdapter.EngineState.IDLE;

    public EngineStateService() {
        ModelViewManager.getInstance().getManagerListeners().addModelManagerListener(this);
    }

    public Map<String, String> getCurrentState() {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put(ID, this.lastState.toString());
        return map;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{ID};
    }

    public void engineStateChanged(IEngine engine, EngineStateAdapter.EngineState state) {
        this.possibleStateChange(state);
    }

    private void possibleStateChange(EngineStateAdapter.EngineState currentState) {
        if (currentState != this.lastState) {
            this.lastState = currentState;
            this.notifyObservers(currentState);
        }
    }

    protected void notifyObservers(EngineStateAdapter.EngineState currentState) {
        this.fireSourceChanged(0, ID, currentState.toString());
    }

    private void unregister() {
        if (this.activeModel != null) {
            assert (this.activeModel.getEngine() != null) : "Engine occurs to be null.";
            this.activeModel.getEngine().removeEngineObserver((IEngineObserver)this);
            this.activeModel = null;
        }
    }

    @Override
    public void modelActivated(IModel newModel) {
        this.unregister();
        IEngine engine = newModel.getEngine();
        assert (engine != null) : "Engine occurs to be null.";
        engine.addEngineObserver((IEngineObserver)this);
        this.activeModel = newModel;
        boolean isStepping = engine.isPaused();
        boolean isEnded = this.activeModel.isEnded();
        this.possibleStateChange(new EngineStateAdapter(engine.isRunning(), isStepping, engine.isPaused(), isEnded).getState());
    }

    @Override
    public void modelAdded(IModel model) {
    }

    @Override
    public void modelRemoved(IModel model) {
        if (model == this.activeModel) {
            this.unregister();
            this.possibleStateChange(EngineStateAdapter.EngineState.IDLE);
        }
    }

    @Override
    public void viewAdded(IWorkbenchPart part) {
    }

    @Override
    public void viewRemoved(IWorkbenchPart part) {
    }

    @Override
    public void viewActivated(IWorkbenchPart part) {
    }

    public void dispose() {
        this.unregister();
    }
}

