/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.escape.amf.ide;

import java.io.File;
import java.io.IOException;
import org.eclipse.amp.escape.command.ExecuteHandler;
import org.eclipse.amp.escape.ide.EclipseEscapeRunner;
import org.eclipse.amp.escape.ide.EscapeIDEPlugin;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.metaabm.SContext;
import org.metaabm.SImplementation;
import org.metaabm.xsd.MetaABMPersist;

public class ExecuteAMFHandler
extends ExecuteHandler {
    protected IResource modelResource;
    private SContext model;

    public ExecuteAMFHandler() {
        super(false);
    }

    public ExecuteAMFHandler(boolean headless) {
        super(headless);
    }

    protected EclipseEscapeRunner executeOpen(Object executed, IProgressMonitor monitor) {
        if (executed instanceof IResource) {
            this.modelResource = (IResource)executed;
            File file = this.modelResource.getLocation().toFile();
            if (this.modelResource.getFileExtension().equals("metaabm")) {
                try {
                    this.model = MetaABMPersist.create((File)file).load();
                    SImplementation impl = this.model.getImplementation();
                    String modelClassName = this.getModelClass(impl);
                    EclipseEscapeRunner eclipseRunner = this.createRunner();
                    eclipseRunner.open(this.modelResource, modelClassName, this.model.getLabel());
                    return eclipseRunner;
                }
                catch (IOException e) {
                    EscapeIDEPlugin.warn((String)"Couldn't load model.", (Throwable)e);
                }
            }
        }
        return null;
    }

    protected String getModelClass(SImplementation impl) {
        String modelClassName = impl.getQualifiedName();
        return modelClassName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean handleSelect(Object sel) {
        if (!(sel instanceof IResource)) return false;
        IResource res = (IResource)sel;
        if (res.getFileExtension() == null) return false;
        if (!res.getFileExtension().equals("metaabm")) return false;
        IProject project = res.getProject();
        try {
            ICommand[] buildSpec;
            ICommand[] iCommandArray = buildSpec = project.getDescription().getBuildSpec();
            int n = buildSpec.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                ICommand cmd = iCommandArray[n2];
                String buildName = "org.eclipse.amp.escape.amf.ide.escapeBuilder";
                if (cmd.getBuilderName().equals(buildName)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            return false;
        }
    }

    public SContext getModel() {
        return this.model;
    }
}

