/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometry;

import java.nio.FloatBuffer;
import java.util.Arrays;
import org.eclipse.draw3d.geometry.IVector2f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Vector2f;

public final class Vector2fImpl
implements Vector2f {
    public float x;
    public float y;
    private static final long serialVersionUID = 1L;

    static Vector2fImpl cast(IVector2f i_sourceVector2f) {
        if (i_sourceVector2f instanceof Vector2fImpl) {
            return (Vector2fImpl)i_sourceVector2f;
        }
        return new Vector2fImpl(i_sourceVector2f);
    }

    public Vector2fImpl() {
    }

    public Vector2fImpl(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vector2fImpl(IVector2f i_sourceVector2f) {
        this(i_sourceVector2f.getX(), i_sourceVector2f.getY());
    }

    public Vector2fImpl(Vector2fImpl i_sourceVector2f) {
        this(i_sourceVector2f.x, i_sourceVector2f.y);
    }

    public Vector2fImpl(FloatBuffer i_floatBuffer) {
        this(i_floatBuffer.get(), i_floatBuffer.get());
    }

    public Vector2fImpl(float[] i_arrayOfFloat) {
        this(i_arrayOfFloat[0], i_arrayOfFloat[1]);
    }

    public Vector2fImpl(float[] i_arrayOfFloat, int i_iOffset) {
        this(i_arrayOfFloat[i_iOffset], i_arrayOfFloat[i_iOffset + 1]);
    }

    public Object clone() throws CloneNotSupportedException {
        return new Vector2fImpl(this);
    }

    public void set(IVector2f i_vector2f) {
        this.x = i_vector2f.getX();
        this.y = i_vector2f.getY();
    }

    public void set(float i_x, float i_y) {
        this.x = i_x;
        this.y = i_y;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public boolean equals(IVector2f v) {
        if (v == this) {
            return true;
        }
        if (v == null) {
            return false;
        }
        return this.x == v.getX() && this.y == v.getY();
    }

    public boolean equals(Object i_obj) {
        if (i_obj instanceof IVector2f) {
            return this.equals((IVector2f)i_obj);
        }
        return false;
    }

    public boolean equals(IVector2f v, float epsilon) {
        if (v == this) {
            return true;
        }
        if (v == null) {
            return false;
        }
        return Math.abs(this.x - v.getX()) <= epsilon && Math.abs(this.y - v.getY()) <= epsilon;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void toArray(float[] o_arrayOfFloat) {
        o_arrayOfFloat[0] = this.x;
        o_arrayOfFloat[1] = this.y;
    }

    public void toArray(float[] o_arrayOfFloat, int i_iOffset) {
        o_arrayOfFloat[i_iOffset] = this.x;
        o_arrayOfFloat[i_iOffset + 1] = this.y;
    }

    public void toBuffer(FloatBuffer o_floatBuffer) {
        o_floatBuffer.put(this.x);
        o_floatBuffer.put(this.y);
    }

    public String toString() {
        return String.format("(%12s, %12s)", String.valueOf(this.x), String.valueOf(this.y));
    }

    public int hashCode() {
        float[] af = new float[2];
        this.toArray(af);
        return Arrays.hashCode(af);
    }

    public void scale(float i_factor) {
        Math3D.scale(i_factor, this, this);
    }
}

