/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3d.ui.parts;

import org.eclipse.draw3d.IScene;
import org.eclipse.draw3d.ISceneListener;
import org.eclipse.draw3d.LightweightSystem3D;
import org.eclipse.draw3d.ui.preferences.ScenePreferenceDistributor;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef3d.ui.parts.FpsStatusLineItem;
import org.eclipse.gef3d.ui.parts.GraphicalViewer3D;
import org.eclipse.gef3d.ui.parts.GraphicalViewer3DImpl;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorSite;

public abstract class GraphicalEditor3D
extends GraphicalEditor {
    protected ScenePreferenceDistributor scenePreferenceDistributor;

    protected void createActionBarContribution() {
    }

    protected void createGraphicalViewer(Composite i_parent) {
        GraphicalViewer3D viewer = this.doCreateGraphicalViewer();
        Control control = viewer.createControl3D(i_parent);
        this.setGraphicalViewer(viewer);
        this.configureGraphicalViewer();
        this.hookGraphicalViewer();
        this.initializeGraphicalViewer();
        this.doAttachFPSCounter(viewer);
        control.addDisposeListener((DisposeListener)viewer.getLightweightSystem3D());
        this.doRegisterToScene((IScene)viewer.getLightweightSystem3D());
        if (this.getEditDomain() != null) {
            this.setEditDomain(this.getEditDomain());
        }
    }

    public void dispose() {
        if (this.scenePreferenceDistributor != null) {
            this.scenePreferenceDistributor.stop();
        }
        super.dispose();
    }

    protected void doAttachFPSCounter(GraphicalViewer3D viewer3D) {
        IEditorSite editorSite = this.getEditorSite();
        IActionBars actionBars = editorSite.getActionBars();
        IStatusLineManager statusLine = actionBars.getStatusLineManager();
        FpsStatusLineItem fpsCounter = new FpsStatusLineItem();
        LightweightSystem3D lightweightSystem3D = viewer3D.getLightweightSystem3D();
        lightweightSystem3D.addSceneListener((ISceneListener)fpsCounter);
        statusLine.add((IContributionItem)fpsCounter);
    }

    protected GraphicalViewer3D doCreateGraphicalViewer() {
        GraphicalViewer3DImpl viewer = new GraphicalViewer3DImpl();
        return viewer;
    }

    protected void doRegisterToScene(IScene scene) {
        this.scenePreferenceDistributor = new ScenePreferenceDistributor(scene);
        this.scenePreferenceDistributor.start();
    }
}

