/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm.commands;

import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.metaabm.MetaABMFactory;
import org.metaabm.MetaABMPackage;
import org.metaabm.SAgent;
import org.metaabm.SAttribute;
import org.metaabm.SAttributeType;
import org.metaabm.SContext;
import org.metaabm.SImplementationMode;
import org.metaabm.act.AAct;
import org.metaabm.act.ABuild;
import org.metaabm.act.ACreateAgents;
import org.metaabm.act.AGroup;
import org.metaabm.act.MetaABMActFactory;
import org.metaabm.act.MetaABMActPackage;
import org.metaabm.commands.SetGenerateCommand;

public class AddAgentsActsCommand
extends AbstractOverrideableCommand {
    protected CompoundCommand command;
    SContext parent;
    Collection<?> agents;

    public AddAgentsActsCommand(EditingDomain domain, SContext parent, Collection<?> agents) {
        super(domain, "Add Agent Acts");
        this.agents = agents;
        this.parent = parent;
    }

    public Collection<?> doGetAffectedObjects() {
        return this.agents;
    }

    public boolean doCanExecute() {
        return this.parent != null && this.parent.getImplementation().getMode() == SImplementationMode.GENERATE_LITERAL;
    }

    public static ABuild findBuilderFor(SAgent agent) {
        return AddAgentsActsCommand.findBuilderOf(agent.getOwner());
    }

    public static ABuild findBuilderOf(SContext agent) {
        AGroup root = (AGroup)agent.getRootActivity();
        if (root != null) {
            return (ABuild)EcoreUtil.getObjectByType((Collection)root.getMembers(), (EClassifier)MetaABMActPackage.Literals.ABUILD);
        }
        return null;
    }

    public static ACreateAgents findCreatorFor(SAgent agent) {
        return AddAgentsActsCommand.findCreatorOf(agent.getOwner(), agent);
    }

    public static ACreateAgents findCreatorOf(SContext context, SAgent agent) {
        AGroup root = (AGroup)context.getRootActivity();
        if (root != null) {
            for (AAct act : root.getMembers()) {
                if (!(act instanceof ACreateAgents) || ((ACreateAgents)act).getAgent() != agent) continue;
                return (ACreateAgents)act;
            }
        }
        return null;
    }

    public void doExecute() {
        this.command = new CompoundCommand("Add Agent Activities and Attributes");
        for (Object object : this.agents) {
            ACreateAgents agentCreator;
            SAgent agent = (SAgent)object;
            this.command.appendAndExecute((Command)new SetGenerateCommand(this.domain, (EObject)agent.getImplementation(), agent.getImplementation().getMode()));
            if (this.parent == null) continue;
            ABuild builder = AddAgentsActsCommand.findBuilderFor(agent);
            if (builder == null) {
                builder = MetaABMActFactory.eINSTANCE.createABuild();
                this.command.appendAndExecute(AddCommand.create((EditingDomain)this.domain, (Object)agent.getOwner().getRootActivity(), (Object)MetaABMActPackage.Literals.AGROUP__MEMBERS, (Object)builder));
            }
            if ((agentCreator = AddAgentsActsCommand.findCreatorFor(agent)) != null) continue;
            this.createAgentConstructor(agent, builder);
        }
    }

    protected void createAgentConstructor(SAgent agent, ABuild builder) {
        ACreateAgents agentCreator = MetaABMActFactory.eINSTANCE.createACreateAgents();
        this.command.appendAndExecute(AddCommand.create((EditingDomain)this.domain, (Object)builder, (Object)MetaABMActPackage.Literals.AACT__TARGETS, (Object)agentCreator));
        this.command.appendAndExecute(SetCommand.create((EditingDomain)this.getDomain(), (Object)agentCreator, (Object)MetaABMActPackage.Literals.ASELECT__AGENT, (Object)agent));
        SAttribute countAttr = MetaABMFactory.eINSTANCE.createSAttribute();
        this.command.appendAndExecute(SetCommand.create((EditingDomain)this.getDomain(), (Object)countAttr, (Object)MetaABMPackage.Literals.ITYPED__STYPE, (Object)SAttributeType.INTEGER_LITERAL));
        this.command.appendAndExecute(AddCommand.create((EditingDomain)this.getDomain(), (Object)agent.getOwner(), (Object)MetaABMPackage.Literals.SATTRIBUTED__ATTRIBUTES, (Object)countAttr));
        this.command.appendAndExecute(SetCommand.create((EditingDomain)this.getDomain(), (Object)agentCreator, (Object)MetaABMActPackage.Literals.ACREATE_AGENTS__AGENT_COUNT, (Object)countAttr));
    }

    public void doRedo() {
        this.command.redo();
    }

    public void doUndo() {
        this.command.undo();
    }
}

