/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.testing.ide;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.time.DateFormatUtils;
import org.eclipse.amp.amf.abase.IInterpreterProvider;
import org.eclipse.amp.amf.parameters.AParFactory;
import org.eclipse.amp.amf.testing.ATestInterpreter;
import org.eclipse.amp.amf.testing.aTest.Model;
import org.eclipse.amp.amf.testing.aTest.TestMember;
import org.eclipse.amp.amf.testing.ares.ResultType;
import org.eclipse.amp.amf.testing.ares.RunSet;
import org.eclipse.amp.amf.testing.ares.impl.AresFactoryImpl;
import org.eclipse.amp.amf.testing.ide.TestRun;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLParserPool;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;

public class TestRunSet {
    private static final int MAX_THREADS = 8;
    String name;
    private Resource aResResource;
    private RunSet runSet;
    public static final IPath RESULTS_FOLDER = new Path("test-results");
    int testRunCount;
    int testInFlightCount;
    int testCompleteCount;
    int testSuccessCount;
    List<IResource> uniqueTests;
    private List lookupTable = new ArrayList();
    private IProgressMonitor monitor;
    private MultiStatus status;
    private IInterpreterProvider aParPool;
    private List<Resource> testsWaiting;
    IProject project;
    int runsPerTest;
    private XMLParserPool parserPool = new XMLParserPoolImpl();
    private Map nameToFeatureMap = new HashMap();
    private ResourceSet resourceSet;
    private final IResource firstResource;

    public TestRunSet(IProject project, IResource res, List<IResource> testResources, int runsPerTest) {
        this.firstResource = res;
        this.uniqueTests = testResources;
        this.project = project;
        this.runsPerTest = runsPerTest;
        this.name = this.getName();
    }

    private String getName() {
        String name = "";
        if (this.firstResource instanceof IFolder) {
            name = String.valueOf(name) + ((IFolder)this.firstResource).getName();
        } else if (this.uniqueTests.size() < 3) {
            for (IResource res : this.uniqueTests) {
                name = String.valueOf(name) + res.getProjectRelativePath().removeFileExtension().lastSegment() + "_";
            }
        } else {
            for (IResource res : this.uniqueTests) {
                name = String.valueOf(name) + res.getName().substring(0, Math.max(5, res.getName().length() - 1)) + "_";
            }
        }
        name = String.valueOf(name) + DateFormatUtils.format((long)System.currentTimeMillis(), (String)"MM-dd-yy_HH-mm-S");
        return name;
    }

    protected void initialize() {
        this.monitor.subTask("Creating Test Resource");
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getLoadOptions().put("DEFER_ATTACHMENT", Boolean.TRUE);
        this.resourceSet.getLoadOptions().put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        this.resourceSet.getLoadOptions().put("USE_DEPRECATED_METHODS", Boolean.TRUE);
        this.resourceSet.getLoadOptions().put("USE_PARSER_POOL", this.parserPool);
        this.resourceSet.getLoadOptions().put("USE_XML_NAME_TO_FEATURE_MAP", this.nameToFeatureMap);
        this.aParPool = AParFactory.createPooled((ResourceSet)this.resourceSet);
        this.monitor.subTask("Creating Results");
        IResource firstResource = this.uniqueTests.get(0);
        IPath projectPath = RESULTS_FOLDER.append(firstResource.getProjectRelativePath().removeFirstSegments(1).removeLastSegments(1)).append(String.valueOf(this.name) + ".ares");
        URI fileURI = URI.createPlatformResourceURI((String)(String.valueOf(this.project.getName()) + "/" + projectPath), (boolean)true);
        this.aResResource = this.resourceSet.createResource(fileURI);
        this.runSet = AresFactoryImpl.eINSTANCE.createRunSet();
        if (this.runSet == null) {
            throw new RuntimeException("Couldn't create resource.");
        }
        this.aResResource.getContents().add((Object)this.runSet);
        if (this.monitor.isCanceled()) {
            return;
        }
        this.saveResults();
    }

    private synchronized void saveResults() {
        HashMap<String, Object> saveOptions = new HashMap<String, Object>();
        saveOptions.put("CONFIGURATION_CACHE", Boolean.TRUE);
        saveOptions.put("USE_CACHED_LOOKUP_TABLE", this.lookupTable);
        this.monitor.subTask("Saving Results");
        try {
            this.aResResource.save(saveOptions);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void runTests(IProgressMonitor monitor, MultiStatus status) {
        this.monitor = monitor;
        this.status = status;
        monitor.beginTask("Executing Escape Tests: " + this.name, this.uniqueTests.size());
        this.initialize();
        monitor.subTask("Preparing Tests");
        this.testsWaiting = Collections.synchronizedList(new ArrayList());
        for (IResource resource : this.uniqueTests) {
            IPath modelPath = ((IFile)resource).getFullPath();
            URI aTestURI = URI.createPlatformResourceURI((String)modelPath.toString(), (boolean)true);
            Resource atestResource = this.resourceSet.getResource(aTestURI, true);
            Model testmodel = (Model)atestResource.getContents().get(0);
            if (testmodel.getContains().size() == 0) {
                int i = 0;
                while (i < this.runsPerTest) {
                    this.testsWaiting.add(atestResource);
                    ++i;
                }
                continue;
            }
            for (TestMember member : testmodel.getContains()) {
                Resource emfResource = this.resourceSet.getResource(URI.createURI((String)ATestInterpreter.convertURI((TestMember)member)), true);
                int i = 0;
                while (i < this.runsPerTest) {
                    this.testsWaiting.add(emfResource);
                    ++i;
                }
            }
        }
        this.uniqueTests = null;
        this.testRunCount = this.testsWaiting.size();
        this.testCompleteCount = 0;
        this.testSuccessCount = 0;
        this.fillThreads();
        while (this.testCompleteCount < this.testRunCount && !monitor.isCanceled()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!monitor.isCanceled()) {
            if (this.testSuccessCount == this.testRunCount) {
                this.runSet.setResult(ResultType.SUCCESS);
            } else {
                this.runSet.setResult(ResultType.FAILURE);
            }
            this.saveResults();
        }
        monitor.done();
    }

    private synchronized void fillThreads() {
        this.monitor.subTask("(Filling Threads)");
        while (this.testsWaiting.size() > 0 && this.testInFlightCount < 8 && !this.monitor.isCanceled()) {
            final Resource nextATest = this.testsWaiting.remove(0);
            ++this.testInFlightCount;
            new Thread(){

                @Override
                public void run() {
                    TestRun nextRun = new TestRun(TestRunSet.this, TestRunSet.this.runSet, TestRunSet.this.project, nextATest, TestRunSet.this.aParPool);
                    nextRun.runTest(TestRunSet.this.monitor, TestRunSet.this.status, false);
                }
            }.start();
            this.updateMonitor();
        }
    }

    public void run() {
        Job escapeRun = new Job("Run " + this.name){

            protected IStatus run(IProgressMonitor monitor) {
                MultiStatus status = new MultiStatus("org.eclipse.amp.amf.testing.ide", 0, "Executing Tests", null);
                TestRunSet.this.runTests(monitor, status);
                return status;
            }
        };
        escapeRun.setPriority(30);
        escapeRun.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComplete(TestRun run, Throwable failureCondition) {
        TestRunSet testRunSet = this;
        synchronized (testRunSet) {
            if (run.getRun() != null && run.getRun().getResult() == ResultType.SUCCESS) {
                ++this.testSuccessCount;
            }
            ++this.testCompleteCount;
            --this.testInFlightCount;
            if (failureCondition == null) {
                this.runSet.getRuns().add((Object)run.getRun());
            }
            this.fillThreads();
        }
        this.saveResults();
        this.updateMonitor();
        this.monitor.worked(1);
    }

    private void updateMonitor() {
        this.monitor.subTask("Completed " + this.testCompleteCount + " of " + this.testRunCount + " (" + (this.testCompleteCount - this.testSuccessCount) + " failures)");
    }

    public RunSet getRunSet() {
        return this.runSet;
    }

    public XMLParserPool getParserPool() {
        return this.parserPool;
    }

    public Map getNameToFeatureMap() {
        return this.nameToFeatureMap;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }
}

