/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;

public enum SAttributeType implements Enumerator
{
    BOOLEAN_LITERAL(100, "Boolean", "BOOLEAN"),
    INTEGER_LITERAL(101, "Integer", "INTEGER"),
    REAL_LITERAL(150, "Real", "REAL"),
    SYMBOL_LITERAL(200, "Symbol", "SYMBOL"),
    UNDEFINED_LITERAL(0, "Undefined", "UNDEFINED"),
    NUMERIC_LITERAL(110, "Numeric", "NUMERIC");

    public static final int BOOLEAN = 100;
    public static final int INTEGER = 101;
    public static final int REAL = 150;
    public static final int SYMBOL = 200;
    public static final int UNDEFINED = 0;
    public static final int NUMERIC = 110;
    private static final SAttributeType[] VALUES_ARRAY;
    public static final EList<SAttributeType> EMPTY_TYPES;
    public static final List<SAttributeType> VALUES;
    public static final EList<SAttributeType> BOOLEAN_ACCEPTS;
    public static final EList<SAttributeType> SYMBOL_ACCEPTS;
    public static final EList<SAttributeType> REAL_ACCEPTS;
    public static final EList<SAttributeType> INT_ACCEPTS;
    public static final EList<SAttributeType> NUMERIC_ACCEPTS;
    public static final EList<SAttributeType> UNDEFINED_ACCEPTS;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SAttributeType[]{BOOLEAN_LITERAL, INTEGER_LITERAL, REAL_LITERAL, SYMBOL_LITERAL, UNDEFINED_LITERAL, NUMERIC_LITERAL};
        EMPTY_TYPES = new BasicEList();
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
        BOOLEAN_ACCEPTS = new BasicEList();
        BOOLEAN_ACCEPTS.add((Object)BOOLEAN_LITERAL);
        SYMBOL_ACCEPTS = new BasicEList();
        SYMBOL_ACCEPTS.add((Object)SYMBOL_LITERAL);
        REAL_ACCEPTS = new BasicEList();
        REAL_ACCEPTS.add((Object)REAL_LITERAL);
        REAL_ACCEPTS.add((Object)NUMERIC_LITERAL);
        INT_ACCEPTS = new BasicEList();
        INT_ACCEPTS.add((Object)INTEGER_LITERAL);
        INT_ACCEPTS.add((Object)REAL_LITERAL);
        INT_ACCEPTS.add((Object)NUMERIC_LITERAL);
        NUMERIC_ACCEPTS = new BasicEList();
        NUMERIC_ACCEPTS.add((Object)INTEGER_LITERAL);
        NUMERIC_ACCEPTS.add((Object)REAL_LITERAL);
        NUMERIC_ACCEPTS.add((Object)NUMERIC_LITERAL);
        UNDEFINED_ACCEPTS = new BasicEList();
        UNDEFINED_ACCEPTS.add((Object)INTEGER_LITERAL);
        UNDEFINED_ACCEPTS.add((Object)REAL_LITERAL);
        UNDEFINED_ACCEPTS.add((Object)NUMERIC_LITERAL);
        UNDEFINED_ACCEPTS.add((Object)BOOLEAN_LITERAL);
        UNDEFINED_ACCEPTS.add((Object)SYMBOL_LITERAL);
    }

    public static EList<SAttributeType> getAvailableTypes(SAttributeType sourceType) {
        switch (sourceType.getValue()) {
            case 100: {
                return BOOLEAN_ACCEPTS;
            }
            case 150: {
                return REAL_ACCEPTS;
            }
            case 101: {
                return INT_ACCEPTS;
            }
            case 110: {
                return NUMERIC_ACCEPTS;
            }
            case 0: {
                return UNDEFINED_ACCEPTS;
            }
            case 200: {
                return SYMBOL_ACCEPTS;
            }
        }
        return EMPTY_TYPES;
    }

    public static SAttributeType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SAttributeType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SAttributeType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SAttributeType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SAttributeType get(int value) {
        switch (value) {
            case 100: {
                return BOOLEAN_LITERAL;
            }
            case 101: {
                return INTEGER_LITERAL;
            }
            case 150: {
                return REAL_LITERAL;
            }
            case 200: {
                return SYMBOL_LITERAL;
            }
            case 0: {
                return UNDEFINED_LITERAL;
            }
            case 110: {
                return NUMERIC_LITERAL;
            }
        }
        return null;
    }

    private SAttributeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

