/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.chart;

import java.util.Collection;
import java.util.List;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.Interactivity;
import org.eclipse.birt.chart.model.attribute.impl.InteractivityImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.ExternalizedTextEditorComposite;
import org.eclipse.birt.chart.ui.swt.composites.FontDefinitionComposite;
import org.eclipse.birt.chart.ui.swt.wizard.format.SubtaskSheetImpl;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.InteractivitySheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart.TitleBlockSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart.TitleTextSheet;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ChartTitleSheetImpl
extends SubtaskSheetImpl
implements SelectionListener,
Listener {
    private ExternalizedTextEditorComposite txtTitle = null;
    private FontDefinitionComposite fdcFont;
    private Button btnVisible;
    private Button btnAuto;

    public void createControl(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FormatChartTitle_ID");
        this.init();
        this.cmpContent = new Composite(parent, 0);
        this.cmpContent.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        this.cmpContent.setLayoutData((Object)gd);
        Composite cmpBasic = new Composite(this.cmpContent, 0);
        cmpBasic.setLayout((Layout)new GridLayout(4, false));
        GridData gd2 = new GridData(1808);
        cmpBasic.setLayoutData((Object)gd2);
        Label lblTitle = new Label(cmpBasic, 0);
        lblTitle.setText(Messages.getString("ChartTitleSheetImpl.Label.ChartTitle"));
        List keys = null;
        if (this.getContext().getUIServiceProvider() != null) {
            keys = this.getContext().getUIServiceProvider().getRegisteredKeys();
        }
        this.txtTitle = new ExternalizedTextEditorComposite(cmpBasic, 2048, -1, -1, keys, this.getContext().getUIServiceProvider(), this.getTitleText());
        GridData gdTXTTitle = new GridData();
        gdTXTTitle.widthHint = 200;
        this.txtTitle.setLayoutData(gdTXTTitle);
        this.txtTitle.setEnabled(this.isTitleEnabled());
        this.txtTitle.addListener(this);
        this.btnVisible = new Button(cmpBasic, 32);
        this.btnVisible.setText(Messages.getString("ChartSheetImpl.Label.Visible"));
        this.btnVisible.setSelection(this.getChart().getTitle().isVisible());
        this.btnVisible.addSelectionListener((SelectionListener)this);
        this.btnAuto = new Button(cmpBasic, 32);
        this.btnAuto.setText(Messages.getString("ChartTitleSheetImpl.Text.Auto"));
        this.btnAuto.setSelection(this.getChart().getTitle().isAuto());
        this.btnAuto.addSelectionListener((SelectionListener)this);
        this.btnAuto.setEnabled(this.isAutoEnabled());
        this.btnAuto.setVisible(this.getContext().getUIFactory().createUIHelper().isDefaultTitleSupported());
        Label lblFont = new Label(cmpBasic, 0);
        lblFont.setText(Messages.getString("LabelAttributesComposite.Lbl.Font"));
        this.fdcFont = new FontDefinitionComposite(cmpBasic, 0, this.getContext(), this.getChart().getTitle().getLabel().getCaption().getFont(), this.getChart().getTitle().getLabel().getCaption().getColor(), true);
        GridData gdFDCFont = new GridData();
        gdFDCFont.widthHint = 200;
        gdFDCFont.grabExcessVerticalSpace = false;
        this.fdcFont.setLayoutData(gdFDCFont);
        this.fdcFont.addListener(this);
        this.createButtonGroup(this.cmpContent);
    }

    private void init() {
        if (this.getChart().getInteractivity() == null) {
            Interactivity interactivity = InteractivityImpl.create();
            interactivity.eAdapters().addAll((Collection)this.getChart().eAdapters());
            this.getChart().setInteractivity(interactivity);
        }
    }

    private void createButtonGroup(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout(5, false));
        GridData gridData = new GridData(768);
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 0x1000008;
        cmp.setLayoutData((Object)gridData);
        AbstractPopupSheet popup = new TitleTextSheet(Messages.getString("ChartTitleSheetImpl.Text.TitleText"), this.getContext());
        Button btnTitleProp = this.createToggleButton(cmp, ".Text", Messages.getString("ChartTitleSheetImpl.Text.TitleText&"), popup, this.getChart().getTitle().isVisible());
        btnTitleProp.addSelectionListener((SelectionListener)this);
        popup = new TitleBlockSheet(Messages.getString("ChartTitleSheetImpl.Text.TitleLayout"), this.getContext());
        Button btnBlockProp = this.createToggleButton(cmp, ".Layout", Messages.getString("ChartTitleSheetImpl.Text.Layout&"), popup, this.getChart().getTitle().isVisible());
        btnBlockProp.addSelectionListener((SelectionListener)this);
        popup = new InteractivitySheet(Messages.getString("ChartTitleSheetImpl.Label.Interactivity"), this.getContext(), this.getChart().getTitle().getTriggers(), (EObject)this.getChart().getTitle(), 2, false, true);
        Button btnInteractivity = this.createToggleButton(cmp, ".Interactivity", Messages.getString("SeriesYSheetImpl.Label.Interactivity&"), popup, this.getChart().getInteractivity().isEnable());
        btnInteractivity.addSelectionListener((SelectionListener)this);
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.txtTitle)) {
            this.getChart().getTitle().getLabel().getCaption().setValue(this.txtTitle.getText());
        } else if (event.widget.equals((Object)this.fdcFont) && event.type == 1) {
            this.getChart().getTitle().getLabel().getCaption().setFont((FontDefinition)((Object[])event.data)[0]);
            this.getChart().getTitle().getLabel().getCaption().setColor((ColorDefinition)((Object[])event.data)[1]);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.detachPopup(e.widget)) {
            return;
        }
        if (this.isRegistered(e.widget)) {
            this.attachPopup(((Button)e.widget).getData().toString());
        }
        if (e.widget.equals(this.btnVisible)) {
            this.getChart().getTitle().setVisible(this.btnVisible.getSelection());
            this.txtTitle.setEnabled(this.isTitleEnabled());
            this.btnAuto.setEnabled(this.isAutoEnabled());
            this.setToggleButtonEnabled(".Text", this.btnVisible.getSelection());
            this.setToggleButtonEnabled(".Layout", this.btnVisible.getSelection());
            if (this.getToggleButton(".Text").getSelection() || this.getToggleButton(".Layout").getSelection()) {
                this.detachPopup();
            }
        } else if (e.widget.equals(this.btnAuto)) {
            this.getChart().getTitle().setAuto(this.btnAuto.getSelection());
            this.txtTitle.setEnabled(this.isTitleEnabled());
            this.txtTitle.setText(this.getTitleText());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private boolean isAutoEnabled() {
        return this.getChart().getTitle().isVisible();
    }

    private boolean isTitleEnabled() {
        return this.getChart().getTitle().isVisible() && !this.getChart().getTitle().isAuto();
    }

    private String getTitleText() {
        if (this.getChart().getTitle().isAuto()) {
            return this.getContext().getUIFactory().createUIHelper().getDefaultTitle(this.getContext());
        }
        return this.getChart().getTitle().getLabel().getCaption().getValue();
    }
}

