/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.ui.eclipse.launch;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.emf.mwe.internal.core.debug.communication.Connection;
import org.eclipse.emf.mwe.internal.ui.debug.model.DebugTarget;
import org.eclipse.emf.mwe.internal.ui.workflow.Activator;
import org.eclipse.jdt.launching.AbstractVMRunner;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

public class MWEDebuggerLauncher
extends AbstractVMRunner {
    private final IVMInstall vm;

    public MWEDebuggerLauncher(IVMInstall vmInstance) {
        this.vm = vmInstance;
    }

    protected String getPluginIdentifier() {
        return "org.eclipse.emf.mwe.ui";
    }

    public void run(VMRunnerConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        int commPort = SocketUtil.findFreePort();
        if (commPort == -1) {
            throw new DebugException(Activator.createErrorStatus("Unable to find free port to start communication with debugger runtime VM --> aborting", null));
        }
        String[] cmdLine = this.renderCommandLine(config, commPort);
        File workingDir = new File(config.getWorkingDirectory());
        String[] envp = config.getEnvironment();
        Connection connection = new Connection();
        Process p = null;
        try {
            try {
                connection.startListeningSocket(commPort);
            }
            catch (IOException e) {
                throw new DebugException(Activator.createErrorStatus("Unable to start debugger listening socket on port " + commPort + " --> aborting", e));
            }
            ConnectRunnable runnable = this.startListeningThread(connection);
            p = DebugPlugin.exec((String[])cmdLine, (File)workingDir, (String[])envp);
            if (p == null) {
                throw new DebugException(Activator.createErrorStatus("Couldn't start Debugger runtime process --> aborting", null));
            }
            IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)MWEDebuggerLauncher.renderProcessLabel("Debugger Process"));
            while (runnable.isRunning() && !process.isTerminated()) {
                if (monitor.isCanceled()) {
                    p.destroy();
                    runnable.cancel();
                }
                try {
                    if (p.exitValue() != 0) {
                        runnable.cancel();
                    }
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    // empty catch block
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Exception e = runnable.getException();
            if (e != null || process.isTerminated()) {
                if (runnable.isRunning()) {
                    runnable.cancel();
                }
                throw new DebugException(Activator.createErrorStatus("Debugger runtime process didn't respond properly --> aborting", null));
            }
            DebugTarget.newDebugTarget(launch, process, connection);
        }
        catch (CoreException e) {
            if (p != null) {
                p.destroy();
            }
            connection.close();
            throw e;
        }
    }

    private String[] renderCommandLine(VMRunnerConfiguration config, int commPort) throws CoreException {
        int n;
        String[] stringArray;
        String[] cp;
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(this.findJavaExecutable());
        String[] vmArgs = config.getVMArguments();
        if (vmArgs != null) {
            String[] stringArray2 = vmArgs;
            int n2 = vmArgs.length;
            int n3 = 0;
            while (n3 < n2) {
                String element = stringArray2[n3];
                arguments.add(element);
                ++n3;
            }
        }
        if ((cp = config.getClassPath()).length > 0) {
            arguments.add("-classpath");
            StringBuilder cpSb = new StringBuilder();
            stringArray = cp;
            n = cp.length;
            int n4 = 0;
            while (n4 < n) {
                String cpEntry = stringArray[n4];
                cpSb.append(cpEntry);
                cpSb.append(File.pathSeparator);
                ++n4;
            }
            arguments.add(cpSb.substring(0, cpSb.lastIndexOf(File.pathSeparator)));
        }
        arguments.add(config.getClassToLaunch());
        String[] progArgs = config.getProgramArguments();
        stringArray = progArgs;
        n = progArgs.length;
        int n5 = 0;
        while (n5 < n) {
            String element = stringArray[n5];
            arguments.add(element);
            ++n5;
        }
        arguments.add("port=" + commPort);
        String[] cmdLine = new String[arguments.size()];
        arguments.toArray(cmdLine);
        return cmdLine;
    }

    private String findJavaExecutable() throws CoreException {
        char fgSeparator = File.separatorChar;
        String[] fgCandidateJavaLocations = new String[]{"bin" + fgSeparator + "javaw", "bin" + fgSeparator + "javaw.exe", "jre" + fgSeparator + "bin" + fgSeparator + "javaw", "jre" + fgSeparator + "bin" + fgSeparator + "javaw.exe", "bin" + fgSeparator + "java", "bin" + fgSeparator + "java.exe", "jre" + fgSeparator + "bin" + fgSeparator + "java", "jre" + fgSeparator + "bin" + fgSeparator + "java.exe"};
        File vmInstallLocation = this.vm.getInstallLocation();
        String[] stringArray = fgCandidateJavaLocations;
        int n = fgCandidateJavaLocations.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            File javaFile = new File(vmInstallLocation, element);
            if (javaFile.isFile()) {
                return javaFile.getAbsolutePath();
            }
            ++n2;
        }
        throw new DebugException(Activator.createErrorStatus("Unable to locate executable for " + this.vm.getName() + " --> aborting", null));
    }

    private static String renderProcessLabel(String command) {
        String timestamp = DateFormat.getDateTimeInstance(2, 2).format(new Date(System.currentTimeMillis()));
        return String.valueOf(command) + " (" + timestamp + ")";
    }

    private ConnectRunnable startListeningThread(Connection connector) {
        ConnectRunnable runnable = new ConnectRunnable(connector);
        Thread connectThread = new Thread((Runnable)runnable, "Listening Connector");
        runnable.setThread(connectThread);
        connectThread.setDaemon(true);
        connectThread.start();
        return runnable;
    }

    class ConnectRunnable
    implements Runnable {
        private Connection fConnector = null;
        private Exception fException = null;
        private Thread thread = null;

        public ConnectRunnable(Connection connector) {
            this.fConnector = connector;
        }

        public void run() {
            try {
                int timeout = JavaRuntime.getPreferences().getInt(JavaRuntime.PREF_CONNECT_TIMEOUT);
                this.fConnector.accept(timeout);
            }
            catch (Exception e) {
                this.fException = e;
            }
        }

        public void cancel() {
            this.fConnector.close();
        }

        public Exception getException() {
            return this.fException;
        }

        public void setThread(Thread thread) {
            this.thread = thread;
        }

        public boolean isRunning() {
            return this.thread.isAlive();
        }
    }
}

