/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.targetdefinition;

import org.eclipse.pde.internal.core.target.provisional.ITargetDefinition;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.targetdefinition.TargetEditor;
import org.eclipse.pde.internal.ui.shared.target.ITargetChangedListener;
import org.eclipse.pde.internal.ui.shared.target.TargetLocationsGroup;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class LocationsSection
extends SectionPart {
    private TargetLocationsGroup fContainerGroup;
    private TargetEditor fEditor;

    public LocationsSection(FormPage page, Composite parent) {
        super(parent, page.getManagedForm().getToolkit(), 384);
        this.fEditor = (TargetEditor)page.getEditor();
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    private ITargetDefinition getTarget() {
        return this.fEditor.getTarget();
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearTableWrapLayout(false, 1));
        GridData sectionData = new GridData(1808);
        sectionData.horizontalSpan = 2;
        section.setLayoutData((Object)sectionData);
        section.setText(PDEUIMessages.LocationSection_0);
        section.setDescription(PDEUIMessages.TargetDefinitionContentPage_LocationDescription);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 1));
        client.setLayoutData((Object)new GridData(1808));
        this.fContainerGroup = TargetLocationsGroup.createInForm(client, toolkit);
        this.fEditor.getTargetChangedListener().setLocationTree(this.fContainerGroup);
        this.fContainerGroup.addTargetChangedListener(this.fEditor.getTargetChangedListener());
        this.fContainerGroup.addTargetChangedListener(new ITargetChangedListener(){

            public void contentsChanged(ITargetDefinition definition, Object source, boolean resolve, boolean forceResolve) {
                LocationsSection.this.markDirty();
            }
        });
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
    }

    public void refresh() {
        this.fContainerGroup.setInput(this.getTarget());
        super.refresh();
    }
}

