/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.branding;

import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.rwt.branding.AbstractBranding;
import org.eclipse.rwt.branding.Header;
import org.eclipse.rwt.internal.util.ParamCheck;

public class BrandingManager {
    public static final String DEFAULT_SERVLET_NAME = "rap";
    public static final String DEFAULT_BRANDING_ID = "org.eclipse.rap.rwt.branding.default";
    private static final Header[] EMPTY_HEADERS = new Header[0];
    private static final String[] EMPTY_ENTRY_POINTS = new String[0];
    private static final AbstractBranding DEFAULT_BRANDING = new AbstractBranding(){

        public String getBody() {
            return "";
        }

        public String[] getEntryPoints() {
            return EMPTY_ENTRY_POINTS;
        }

        public String getDefaultEntryPoint() {
            return null;
        }

        public String getFavIcon() {
            return null;
        }

        public Header[] getHeaders() {
            return EMPTY_HEADERS;
        }

        public String getServletName() {
            return BrandingManager.DEFAULT_SERVLET_NAME;
        }

        public String getThemeId() {
            return null;
        }

        public String getId() {
            return BrandingManager.DEFAULT_BRANDING_ID;
        }

        public String getTitle() {
            return "RAP Startup Page";
        }
    };
    private final List brandings = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(AbstractBranding branding) {
        ParamCheck.notNull(branding, "branding");
        List list = this.brandings;
        synchronized (list) {
            this.brandings.add(branding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(AbstractBranding branding) {
        ParamCheck.notNull(branding, "branding");
        List list = this.brandings;
        synchronized (list) {
            this.brandings.remove(branding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractBranding[] getAll() {
        AbstractBranding[] result;
        List list = this.brandings;
        synchronized (list) {
            result = new AbstractBranding[this.brandings.size()];
            this.brandings.toArray(result);
        }
        return result;
    }

    public AbstractBranding find(String servletName, String entryPoint) {
        ParamCheck.notNull(servletName, "servletName");
        AbstractBranding result = null;
        AbstractBranding[] brandings = this.getAll();
        int i = 0;
        while (result == null && i < brandings.length) {
            AbstractBranding branding = brandings[i];
            if (servletName.equals(branding.getServletName())) {
                if (BrandingManager.matches(branding, entryPoint)) {
                    result = branding;
                }
                if (result == null) {
                    String text = "Entry point ''{0}'' not allowed for branding ''{1}''";
                    Object[] args = new Object[]{entryPoint, branding};
                    String msg = MessageFormat.format(text, args);
                    throw new IllegalArgumentException(msg);
                }
            }
            ++i;
        }
        if (result == null) {
            result = DEFAULT_BRANDING;
        }
        return result;
    }

    private static boolean matches(AbstractBranding branding, String entryPoint) {
        String[] entryPoints;
        boolean result = false;
        String defaultEntryPoint = branding.getDefaultEntryPoint();
        if (defaultEntryPoint != null && !"".equals(defaultEntryPoint) && (entryPoint == null || "".equals(entryPoint) || defaultEntryPoint.equals(entryPoint))) {
            result = true;
        }
        if ((entryPoints = branding.getEntryPoints()) != null && entryPoints.length > 0) {
            if (BrandingManager.search(entryPoints, entryPoint) != -1) {
                result = true;
            }
        } else {
            result = true;
        }
        return result;
    }

    private static int search(String[] strings, String string) {
        int result = -1;
        if (string != null) {
            int i = 0;
            while (result == -1 && i < strings.length) {
                if (string.equals(strings[i])) {
                    result = i;
                }
                ++i;
            }
        }
        return result;
    }
}

